/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonChar;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPrimitiveBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonPrimitiveElementBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractPrimitiveTsonElement;

public class TsonCharImpl
extends AbstractPrimitiveTsonElement
implements TsonChar {
    private char value;

    public TsonCharImpl(char value) {
        super(TsonElementType.CHAR);
        this.value = value;
    }

    @Override
    public TsonChar toChar() {
        return this;
    }

    @Override
    public char value() {
        return this.value;
    }

    @Override
    public char charValue() {
        return this.value();
    }

    @Override
    public Character charObject() {
        return Character.valueOf(this.value());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonCharImpl tsonChar = (TsonCharImpl)o;
        return this.value == tsonChar.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Character.valueOf(this.value));
    }

    @Override
    public TsonPrimitiveBuilder builder() {
        return new TsonPrimitiveElementBuilderImpl().copyFrom(this);
    }

    @Override
    protected int compareCore(TsonElement o) {
        return Character.compare(this.value, o.toChar().value());
    }
}

