/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBinaryStream;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPrimitiveBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonPrimitiveElementBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractPrimitiveTsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonBinaryStreamSource;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.AppendableWriter;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.util.Base64EncoderAdapter;

public class TsonBinaryStreamImpl
extends AbstractPrimitiveTsonElement
implements TsonBinaryStream {
    private TsonBinaryStreamSource value;

    public TsonBinaryStreamImpl(TsonBinaryStreamSource value) {
        super(TsonElementType.BINARY_STREAM);
        this.value = value;
    }

    @Override
    public InputStream value() {
        return this.value.open();
    }

    @Override
    public Reader getBase64Value() {
        return this.getBase64Value(80);
    }

    @Override
    public Reader getBase64Value(int lineMax) {
        return new Base64EncoderAdapter(this.value(), lineMax);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonBinaryStreamImpl that = (TsonBinaryStreamImpl)o;
        return Objects.equals(this.value(), that.value());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value());
    }

    @Override
    public TsonPrimitiveBuilder builder() {
        return new TsonPrimitiveElementBuilderImpl().copyFrom(this);
    }

    @Override
    protected int compareCore(TsonElement o) {
        return this == o ? 1 : 0;
    }

    @Override
    public TsonBinaryStream toBinaryStream() {
        return this;
    }

    @Override
    public String stringValue() {
        StringBuilder sb = new StringBuilder();
        try (AppendableWriter w = AppendableWriter.of(sb);
             Reader r = this.getBase64Value();){
            int c;
            char[] b = new char[1024];
            while ((c = r.read(b)) > 0) {
                w.write(b, 0, c);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return sb.toString();
    }
}

