/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotation;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotationBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonAnnotationBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;
import net.thevpc.nuts.util.NOptional;

public class TsonAnnotationImpl
implements TsonAnnotation {
    private String name;
    private List<TsonElement> params;

    public TsonAnnotationImpl(String name, List<TsonElement> params) {
        this.name = name;
        this.params = params == null ? null : new ArrayList<TsonElement>(params);
    }

    @Override
    public boolean isParametrized() {
        return this.params != null;
    }

    @Override
    public boolean isNamed() {
        return this.name != null;
    }

    @Override
    public TsonAnnotationBuilder builder() {
        return new TsonAnnotationBuilderImpl().merge(this);
    }

    @Override
    public NOptional<String> name() {
        return NOptional.ofNamed(this.name, "name");
    }

    @Override
    public List<TsonElement> params() {
        return this.params;
    }

    @Override
    public int size() {
        return this.params.size();
    }

    @Override
    public TsonElement param(int index) {
        return this.params.get(index);
    }

    @Override
    public List<TsonElement> children() {
        return this.params == null ? null : Collections.unmodifiableList(this.params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsonAnnotationImpl that = (TsonAnnotationImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        int result = Objects.hash(this.name);
        result = 31 * result + Objects.hashCode(this.params);
        return result;
    }

    @Override
    public int compareTo(TsonAnnotation o) {
        int i = TsonUtils.compare(this.name, o.name().orNull());
        if (i != 0) {
            return i;
        }
        List<TsonElement> params1 = o.params();
        return TsonUtils.compareElementsArray(this.params == null ? null : this.params.toArray(new TsonElement[0]), params1 == null ? null : params1.toArray(new TsonElement[0]));
    }

    @Override
    public String toString(boolean compact) {
        return "@" + Tson.ofUplet(this.name, (TsonElementBase[])this.params.toArray(new TsonElement[0])).toString(compact);
    }
}

