/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Base64;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonBinaryStreamSource;

public class InputStreamTsonBinaryStreamSource
extends TsonBinaryStreamSource {
    private ByteArrayOutputStream memoryBuffer = new ByteArrayOutputStream();
    private OutputStream persistentBuffer;
    private int MAX_MEM_LEN = 80960;
    private long length;
    private boolean inMemory = true;
    private File tempFile;

    public void set(InputStream inputStream) {
        byte[] b = new byte[8096];
        while (true) {
            int r;
            try {
                r = inputStream.read(b);
                if (r <= 0) {
                    break;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.push(b, 0, r);
        }
    }

    public void pushBase64(String str) {
        byte[] y = Base64.getDecoder().decode(str);
        this.push(y, 0, y.length);
    }

    public void push(byte[] buffer, int offset, int len) {
        try {
            if (this.inMemory) {
                if (this.length + (long)len < (long)this.MAX_MEM_LEN) {
                    this.memoryBuffer.write(buffer, offset, len);
                } else {
                    this.tempFile = File.createTempFile("tsonbin", ".temp");
                    this.persistentBuffer = new FileOutputStream(this.tempFile);
                    this.inMemory = false;
                    this.persistentBuffer.write(this.memoryBuffer.toByteArray());
                    this.memoryBuffer = null;
                }
            } else {
                this.persistentBuffer.write(this.memoryBuffer.toByteArray());
            }
            this.length += (long)len;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public InputStreamTsonBinaryStreamSource() {
    }

    public InputStreamTsonBinaryStreamSource(InputStream inputStream) {
        this.set(inputStream);
    }

    @Override
    public InputStream open() {
        if (this.inMemory) {
            return new ByteArrayInputStream(this.memoryBuffer.toByteArray());
        }
        try {
            if (this.persistentBuffer != null) {
                this.persistentBuffer.close();
                this.persistentBuffer = null;
            }
            return new FileInputStream(this.tempFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

