/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArray;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFormat;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonListContainer;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObject;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPair;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonUplet;

public abstract class AbstractTsonElementBase
implements TsonElement {
    @Override
    public String toString() {
        return Tson.DEFAULT_FORMAT.format(this);
    }

    @Override
    public String toString(boolean compact) {
        return compact ? Tson.COMPACT_FORMAT.format(this) : Tson.DEFAULT_FORMAT.format(this);
    }

    @Override
    public String toString(TsonFormat format) {
        return format == null ? Tson.DEFAULT_FORMAT.format(this) : format.format(this);
    }

    @Override
    public boolean isListContainer() {
        return this.type().isListContainer();
    }

    @Override
    public boolean isNumber() {
        return this.type().isNumber();
    }

    @Override
    public boolean isFloatingNumber() {
        switch (this.type()) {
            case FLOAT: 
            case DOUBLE: 
            case BIG_DECIMAL: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isComplexNumber() {
        switch (this.type()) {
            case BIG_COMPLEX: 
            case FLOAT_COMPLEX: 
            case DOUBLE_COMPLEX: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isOrdinalNumber() {
        switch (this.type()) {
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: 
            case BIG_INTEGER: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isString() {
        return this.type().isString();
    }

    @Override
    public boolean isPair() {
        return this.type() == TsonElementType.PAIR;
    }

    @Override
    public boolean isSimple() {
        return this.type().isSimple();
    }

    @Override
    public boolean isSimplePair() {
        if (!this.isPair()) {
            return false;
        }
        TsonPair pair = this.toPair();
        return this.type() == TsonElementType.PAIR && pair.key().isSimple();
    }

    @Override
    public boolean isName() {
        return this.type() == TsonElementType.NAME;
    }

    @Override
    public boolean isBoolean() {
        return this.type() == TsonElementType.BOOLEAN;
    }

    @Override
    public boolean isArray() {
        return this.type() == TsonElementType.ARRAY;
    }

    @Override
    public boolean isObject() {
        return this.type() == TsonElementType.OBJECT;
    }

    @Override
    public boolean isNamedObject() {
        return this.type() == TsonElementType.NAMED_OBJECT;
    }

    @Override
    public boolean isNamedUplet() {
        return this.type() == TsonElementType.NAMED_UPLET;
    }

    @Override
    public boolean isNamedArray() {
        return this.type() == TsonElementType.NAMED_ARRAY;
    }

    @Override
    public boolean isUplet() {
        return this.type() == TsonElementType.UPLET;
    }

    @Override
    public boolean isAnyString() {
        switch (this.type()) {
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: 
            case TRIPLE_ANTI_QUOTED_STRING: 
            case LINE_STRING: 
            case CHAR: 
            case NAME: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return this.type().isPrimitive();
    }

    @Override
    public boolean isTemporal() {
        return this.type().isTemporal();
    }

    @Override
    public TsonListContainer toListContainer() {
        if (this.isListContainer()) {
            return (TsonListContainer)((Object)this);
        }
        return this.toArray();
    }

    @Override
    public TsonArray toArray() {
        if (this.isArray()) {
            return (TsonArray)((Object)this);
        }
        if (this.isListContainer()) {
            return Tson.ofArray(this.toListContainer().body().toList().toArray(new TsonElement[0]));
        }
        return Tson.ofArray(this);
    }

    @Override
    public TsonObject toObject() {
        if (this.isObject()) {
            return (TsonObject)((Object)this);
        }
        if (this.isListContainer()) {
            return Tson.ofObjectBuilder(this.toListContainer().body().toList().toArray(new TsonElement[0])).build();
        }
        return Tson.ofObjectBuilder(this).build();
    }

    @Override
    public TsonUplet toUplet() {
        if (this.isUplet()) {
            return (TsonUplet)((Object)this);
        }
        if (this.isListContainer()) {
            return Tson.ofUplet(this.toListContainer().body().toList().toArray(new TsonElement[0]));
        }
        return Tson.ofUplet(this);
    }
}

