/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAlias;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotation;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBigComplex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBigDecimal;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBigInt;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBinaryStream;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBoolean;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonByte;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonChar;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonCharStream;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonComments;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonCustom;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDouble;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDoubleComplex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFloat;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFloatComplex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonInstant;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonInt;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLocalDate;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLocalDateTime;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLocalTime;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLong;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonMatrix;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonName;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNumber;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObject;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonOp;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPair;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonRegex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonShort;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonString;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonUplet;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractTsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonNullImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;

public abstract class AbstractTsonElement
extends AbstractTsonElementBase {
    private TsonElementType type;

    public AbstractTsonElement(TsonElementType type) {
        this.type = type;
    }

    @Override
    public TsonElementType type() {
        return this.type;
    }

    @Override
    public TsonComments comments() {
        return TsonComments.BLANK;
    }

    @Override
    public List<TsonAnnotation> annotations() {
        return Collections.emptyList();
    }

    @Override
    public int annotationsCount() {
        return 0;
    }

    protected abstract <T> T throwPrimitive(TsonElementType var1);

    protected abstract <T> T throwNonPrimitive(TsonElementType var1);

    @Override
    public TsonString toStr() {
        return (TsonString)this.throwPrimitive(TsonElementType.DOUBLE_QUOTED_STRING);
    }

    @Override
    public TsonLong toLong() {
        return (TsonLong)this.throwPrimitive(TsonElementType.LONG);
    }

    @Override
    public TsonInt toInt() {
        return (TsonInt)this.throwPrimitive(TsonElementType.INTEGER);
    }

    @Override
    public TsonFloat toFloat() {
        return (TsonFloat)this.throwPrimitive(TsonElementType.FLOAT);
    }

    @Override
    public TsonDouble toDouble() {
        return (TsonDouble)this.throwPrimitive(TsonElementType.DOUBLE);
    }

    @Override
    public TsonShort toShort() {
        return (TsonShort)this.throwPrimitive(TsonElementType.SHORT);
    }

    @Override
    public TsonByte toByte() {
        return (TsonByte)this.throwPrimitive(TsonElementType.BYTE);
    }

    @Override
    public TsonChar toChar() {
        return (TsonChar)this.throwPrimitive(TsonElementType.CHAR);
    }

    @Override
    public TsonCustom toCustom() {
        return (TsonCustom)this.throwPrimitive(TsonElementType.CUSTOM);
    }

    @Override
    public TsonBoolean toBoolean() {
        String svalue;
        if (this.isBoolean()) {
            return (TsonBoolean)((Object)this);
        }
        if (this.isNumber()) {
            Number value = this.numberValue();
            if (value instanceof Number) {
                if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof BigInteger) {
                    return (TsonBoolean)Tson.of(value.longValue() != 0L);
                }
                if (value instanceof Float || value instanceof Double || value instanceof BigDecimal) {
                    double d = value.doubleValue();
                    return (TsonBoolean)Tson.of(d != 0.0 && !Double.isNaN(d));
                }
            }
        } else if (this.isAnyString() && !(svalue = this.toStr().value().trim().toLowerCase()).isEmpty()) {
            if (svalue.matches("true|enable|enabled|yes|always|y|on|ok|t|o")) {
                return (TsonBoolean)Tson.of(true);
            }
            if (svalue.matches("false|disable|disabled|no|none|never|n|off|ko|f")) {
                return (TsonBoolean)Tson.of(false);
            }
        }
        return (TsonBoolean)this.throwPrimitive(TsonElementType.BOOLEAN);
    }

    @Override
    public TsonName toName() {
        return (TsonName)this.throwPrimitive(TsonElementType.NAME);
    }

    @Override
    public TsonAlias toAlias() {
        return (TsonAlias)this.throwPrimitive(TsonElementType.ALIAS);
    }

    @Override
    public TsonLocalDate toLocalDate() {
        return (TsonLocalDate)this.throwPrimitive(TsonElementType.LOCAL_DATE);
    }

    @Override
    public TsonInstant toInstant() {
        return (TsonInstant)this.throwPrimitive(TsonElementType.INSTANT);
    }

    @Override
    public TsonLocalDateTime toLocalDateTime() {
        return (TsonLocalDateTime)this.throwPrimitive(TsonElementType.LOCAL_DATETIME);
    }

    @Override
    public TsonLocalTime toLocalTime() {
        return (TsonLocalTime)this.throwPrimitive(TsonElementType.LOCAL_TIME);
    }

    @Override
    public TsonRegex toRegex() {
        return (TsonRegex)this.throwPrimitive(TsonElementType.REGEX);
    }

    @Override
    public Boolean booleanObject() {
        return (Boolean)this.throwPrimitive(TsonElementType.BOOLEAN);
    }

    @Override
    public Character charObject() {
        return (Character)this.throwPrimitive(TsonElementType.CHAR);
    }

    @Override
    public Byte byteObject() {
        return (Byte)this.throwPrimitive(TsonElementType.BYTE);
    }

    @Override
    public Number numberValue() {
        return (Number)this.throwPrimitive(TsonElementType.DOUBLE);
    }

    @Override
    public Temporal temporalValue() {
        return (Temporal)this.throwPrimitive(TsonElementType.LOCAL_DATETIME);
    }

    @Override
    public Long longObject() {
        return (Long)this.throwPrimitive(TsonElementType.LONG);
    }

    @Override
    public Integer intObject() {
        return (Integer)this.throwPrimitive(TsonElementType.INTEGER);
    }

    @Override
    public Short shortObject() {
        return (Short)this.throwPrimitive(TsonElementType.SHORT);
    }

    @Override
    public Float floatObject() {
        return (Float)this.throwPrimitive(TsonElementType.FLOAT);
    }

    @Override
    public Double doubleObject() {
        return (Double)this.throwPrimitive(TsonElementType.DOUBLE);
    }

    @Override
    public float floatValue() {
        return ((Float)this.throwPrimitive(TsonElementType.FLOAT)).floatValue();
    }

    @Override
    public double doubleValue() {
        return (Double)this.throwPrimitive(TsonElementType.DOUBLE);
    }

    @Override
    public byte byteValue() {
        return (Byte)this.throwPrimitive(TsonElementType.BYTE);
    }

    @Override
    public char charValue() {
        return ((Character)this.throwPrimitive(TsonElementType.CHAR)).charValue();
    }

    @Override
    public boolean booleanValue() {
        return (Boolean)this.throwPrimitive(TsonElementType.BOOLEAN);
    }

    @Override
    public int intValue() {
        return (Integer)this.throwPrimitive(TsonElementType.INTEGER);
    }

    @Override
    public long longValue() {
        return (Long)this.throwPrimitive(TsonElementType.LONG);
    }

    @Override
    public short shortValue() {
        return (Short)this.throwPrimitive(TsonElementType.SHORT);
    }

    @Override
    public LocalDate localDateValue() {
        return (LocalDate)this.throwPrimitive(TsonElementType.LOCAL_DATE);
    }

    @Override
    public Instant instantValue() {
        return (Instant)this.throwPrimitive(TsonElementType.INSTANT);
    }

    @Override
    public LocalDateTime localDateTimeValue() {
        return (LocalDateTime)this.throwPrimitive(TsonElementType.LOCAL_DATETIME);
    }

    @Override
    public LocalTime localTimeValue() {
        return (LocalTime)this.throwPrimitive(TsonElementType.LOCAL_TIME);
    }

    @Override
    public Pattern regexValue() {
        return (Pattern)this.throwPrimitive(TsonElementType.REGEX);
    }

    @Override
    public String stringValue() {
        return (String)this.throwPrimitive(TsonElementType.DOUBLE_QUOTED_STRING);
    }

    @Override
    public TsonNumber toNumber() {
        throw new ClassCastException((Object)((Object)this.type()) + " is not a number");
    }

    @Override
    public TsonMatrix toMatrix() {
        return (TsonMatrix)this.throwNonPrimitive(TsonElementType.MATRIX);
    }

    @Override
    public TsonObject toObject() {
        return (TsonObject)this.throwNonPrimitive(TsonElementType.OBJECT);
    }

    @Override
    public TsonUplet toUplet() {
        return (TsonUplet)this.throwNonPrimitive(TsonElementType.UPLET);
    }

    @Override
    public TsonPair toPair() {
        return (TsonPair)this.throwNonPrimitive(TsonElementType.PAIR);
    }

    @Override
    public TsonOp toOp() {
        return (TsonOp)this.throwNonPrimitive(TsonElementType.OP);
    }

    @Override
    public TsonBinaryStream toBinaryStream() {
        return (TsonBinaryStream)this.throwPrimitive(TsonElementType.BINARY_STREAM);
    }

    @Override
    public TsonCharStream toCharStream() {
        return (TsonCharStream)this.throwPrimitive(TsonElementType.CHAR_STREAM);
    }

    @Override
    public TsonBigInt toBigInt() {
        return (TsonBigInt)this.throwPrimitive(TsonElementType.BIG_INTEGER);
    }

    @Override
    public TsonBigDecimal toBigDecimal() {
        return (TsonBigDecimal)this.throwPrimitive(TsonElementType.BIG_DECIMAL);
    }

    @Override
    public TsonBigComplex toBigComplex() {
        return (TsonBigComplex)this.throwPrimitive(TsonElementType.BIG_COMPLEX);
    }

    @Override
    public TsonFloatComplex toFloatComplex() {
        return (TsonFloatComplex)this.throwPrimitive(TsonElementType.FLOAT_COMPLEX);
    }

    @Override
    public TsonDoubleComplex toDoubleComplex() {
        return (TsonDoubleComplex)this.throwPrimitive(TsonElementType.DOUBLE_COMPLEX);
    }

    @Override
    public BigInteger bigIntegerValue() {
        return (BigInteger)this.throwPrimitive(TsonElementType.BIG_INTEGER);
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return (BigDecimal)this.throwPrimitive(TsonElementType.BIG_DECIMAL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTsonElement that = (AbstractTsonElement)o;
        return this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }

    @Override
    public boolean visit(TsonDocumentVisitor visitor) {
        return true;
    }

    @Override
    public int compareTo(TsonElement o) {
        TsonElementType t2;
        TsonElementType t1;
        int i;
        if (o == null) {
            o = TsonNullImpl.INSTANCE;
        }
        if ((i = (t1 = this.type()).compareTo(t2 = o.type())) != 0) {
            return i;
        }
        i = this.compareCore(o);
        if (i != 0) {
            return i;
        }
        i = TsonUtils.compareLists(this.annotations(), o.annotations());
        if (i != 0) {
            return i;
        }
        TsonComments c1 = this.comments();
        TsonComments c2 = o.comments();
        if (c1 == null) {
            c1 = TsonComments.BLANK;
        }
        if (c2 == null) {
            c2 = TsonComments.BLANK;
        }
        return c1.compareTo(c2);
    }

    protected abstract int compareCore(TsonElement var1);

    @Override
    public boolean isNull() {
        return false;
    }
}

