/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArray;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonMatrix;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonMatrixBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObject;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonUplet;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.AbstractTsonElementBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonElementListImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonMatrixImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;

public class TsonMatrixBuilderImpl
extends AbstractTsonElementBuilder<TsonMatrixBuilder>
implements TsonMatrixBuilder {
    private ArrayList<ArrayList<TsonElement>> rows = new ArrayList();
    private int rowsCount;
    private int columnsCount;
    private String name;
    private List<TsonElement> params;

    @Override
    public TsonMatrixBuilder ensureCapacity(int columns0, int rows0) {
        int oldColumnsCount = this.columnsCount;
        int oldRowsCount = this.rowsCount;
        this.columnsCount = columns0 = Math.max(columns0, this.columnsCount);
        this.rowsCount = rows0 = Math.max(rows0, this.rowsCount);
        TsonElement nullElem = Tson.ofNull();
        if (this.columnsCount != oldColumnsCount) {
            for (int i = 0; i < this.rowsCount; ++i) {
                ArrayList<TsonElement> row = this.rows.get(i);
                row.ensureCapacity(columns0);
                while (row.size() < columns0) {
                    row.add(nullElem);
                }
            }
        }
        if (this.rowsCount != oldRowsCount) {
            while (this.rowsCount < rows0) {
                ArrayList<TsonElement> row = new ArrayList<TsonElement>(columns0);
                for (int i = 0; i < columns0; ++i) {
                    row.add(nullElem);
                }
            }
        }
        return this;
    }

    @Override
    public TsonElementType type() {
        return this.name == null && this.params == null ? TsonElementType.MATRIX : (this.name == null && this.params != null ? TsonElementType.PARAMETRIZED_MATRIX : (this.name != null && this.params == null ? TsonElementType.NAMED_MATRIX : TsonElementType.NAMED_PARAMETRIZED_MATRIX));
    }

    @Override
    public TsonElement get(int column, int row) {
        return this.rows.get(row).get(column);
    }

    @Override
    public TsonArray getRow(int row) {
        return TsonUtils.toArray((List<TsonElement>)this.rows.get(row));
    }

    @Override
    public TsonArray getColumn(int column) {
        ArrayList<TsonElement> col = new ArrayList<TsonElement>(this.rowsCount());
        for (int i = 0; i < this.rowsCount(); ++i) {
            col.add(this.rows.get(i).get(column));
        }
        return TsonUtils.toArray(col);
    }

    @Override
    public TsonMatrixBuilder addRow(TsonArray element) {
        this.rows.add(new ArrayList<TsonElement>(element.body().toList()));
        this.ensureCapacity(this.columnsCount, this.rowsCount + 1);
        return this;
    }

    @Override
    public TsonMatrixBuilder addRows(TsonArray ... elements) {
        for (TsonArray element : elements) {
            this.rows.add(new ArrayList<TsonElement>(element.body().toList()));
        }
        this.ensureCapacity(this.columnsCount, this.rowsCount + elements.length);
        return this;
    }

    @Override
    public TsonMatrixBuilder addRows(Iterable<? extends TsonArray> elements) {
        int count = 0;
        for (TsonArray tsonArray : elements) {
            this.rows.add(new ArrayList<TsonElement>(tsonArray.body().toList()));
            ++count;
        }
        this.ensureCapacity(this.columnsCount, this.rowsCount + count);
        return null;
    }

    @Override
    public TsonMatrixBuilder addColumn(TsonArray element) {
        this.ensureCapacity(this.columnsCount(), element.size());
        int i = 0;
        TsonElement nullElem = Tson.ofNull();
        for (ArrayList<TsonElement> row : this.rows) {
            if (i < element.size()) {
                row.add(element.get(i));
            } else {
                row.add(nullElem);
            }
            ++i;
        }
        this.ensureCapacity(this.columnsCount() + 1, this.rowsCount());
        return this;
    }

    @Override
    public TsonMatrixBuilder addColumns(TsonArray ... elements) {
        for (TsonArray element : elements) {
            this.addColumn(element);
        }
        this.ensureCapacity(this.columnsCount() + elements.length, this.rowsCount());
        return this;
    }

    @Override
    public TsonMatrixBuilder addColumns(Iterable<? extends TsonArray> elements) {
        int count = 0;
        for (TsonArray tsonArray : elements) {
            this.addColumn(tsonArray);
            ++count;
        }
        this.ensureCapacity(this.columnsCount() + count, this.rowsCount());
        return this;
    }

    @Override
    public List<TsonArray> rows() {
        return this.getRows();
    }

    @Override
    public List<TsonArray> getRows() {
        return new AbstractList<TsonArray>(){

            @Override
            public TsonArray get(int index) {
                return TsonMatrixBuilderImpl.this.getRow(index);
            }

            @Override
            public int size() {
                return TsonMatrixBuilderImpl.this.columnsCount();
            }
        };
    }

    @Override
    public TsonMatrixBuilder removeRow(int row) {
        if (row >= 0 && row < this.rowsCount) {
            this.rows.remove(row);
            --this.rowsCount;
        } else {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return this;
    }

    @Override
    public TsonMatrixBuilder removeColumn(int column) {
        if (column >= 0 && column < this.columnsCount) {
            for (ArrayList<TsonElement> row : this.rows) {
                row.remove(column);
            }
            --this.columnsCount;
        } else {
            throw new ArrayIndexOutOfBoundsException(column);
        }
        return this;
    }

    @Override
    public int columnsCount() {
        return this.columnsCount;
    }

    @Override
    public int rowsCount() {
        return this.columnsCount;
    }

    @Override
    public TsonMatrixBuilder set(TsonElementBase element, int column, int row) {
        this.ensureCapacity(column, row);
        this.rows.get(row).set(column, Tson.of(element));
        return this;
    }

    @Override
    public Iterator<TsonArray> iterator() {
        final Iterator<ArrayList<TsonElement>> t = this.rows.iterator();
        return new Iterator<TsonArray>(){

            @Override
            public boolean hasNext() {
                return t.hasNext();
            }

            @Override
            public TsonArray next() {
                return TsonUtils.toArray((List)t.next());
            }
        };
    }

    @Override
    public TsonMatrixBuilder reset() {
        this.rows.clear();
        this.name = null;
        this.params = null;
        this.rowsCount = 0;
        this.columnsCount = 0;
        return this;
    }

    @Override
    public TsonMatrix build() {
        ArrayList<TsonArray> arrays = new ArrayList<TsonArray>();
        for (ArrayList<TsonElement> row : this.rows) {
            arrays.add(TsonUtils.toArray(row));
        }
        TsonMatrixImpl built = new TsonMatrixImpl(this.name, this.params == null ? null : new TsonElementListImpl(this.params), TsonUtils.unmodifiableArrays(arrays));
        return (TsonMatrix)TsonUtils.decorate(built, this.comments(), this.annotations());
    }

    @Override
    public TsonMatrixBuilder merge(TsonElementBase element) {
        TsonElement e = Tson.of(element);
        switch (e.type()) {
            case UPLET: 
            case NAMED_UPLET: {
                TsonUplet uplet = e.toUplet();
                if (uplet.isNamed()) {
                    this.name(uplet.name());
                }
                this.addParams(uplet);
                break;
            }
            case NAME: {
                this.name(e.toName().value());
                break;
            }
            case OBJECT: 
            case NAMED_PARAMETRIZED_OBJECT: 
            case NAMED_OBJECT: 
            case PARAMETRIZED_OBJECT: {
                TsonObject h = e.toObject();
                this.name(h.name());
                this.addParams(h.params());
                this.addRow(TsonUtils.toArray(e.toObject().body()));
                break;
            }
            case ARRAY: 
            case NAMED_PARAMETRIZED_ARRAY: 
            case PARAMETRIZED_ARRAY: 
            case NAMED_ARRAY: {
                TsonArray h = e.toArray();
                this.name(h.name());
                this.addParams(h.params());
                this.addRow(TsonUtils.toArray(e.toArray().body()));
                break;
            }
            case MATRIX: 
            case NAMED_MATRIX: 
            case PARAMETRIZED_MATRIX: 
            case NAMED_PARAMETRIZED_MATRIX: {
                TsonMatrix h = e.toMatrix();
                this.name(h.name());
                this.addParams(h.params());
                for (TsonArray m : e.toMatrix()) {
                    this.addRow(m);
                }
                break;
            }
        }
        return this;
    }

    @Override
    public boolean isParametrized() {
        return this.params != null;
    }

    @Override
    public TsonMatrixBuilder setParametrized(boolean parametrized) {
        if (parametrized) {
            if (this.params == null) {
                this.params = new ArrayList<TsonElement>();
            }
        } else {
            this.params = null;
        }
        return this;
    }

    @Override
    public List<TsonElement> params() {
        return this.params;
    }

    @Override
    public int paramsCount() {
        return this.params == null ? 0 : this.params.size();
    }

    @Override
    public TsonMatrixBuilder clearParams() {
        if (this.params != null) {
            this.params.clear();
        }
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TsonMatrixBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public TsonMatrixBuilder addParam(TsonElementBase element) {
        if (element != null) {
            if (this.params == null) {
                this.params = new ArrayList<TsonElement>();
            }
            this.params.add(Tson.of(element).build());
        }
        return this;
    }

    @Override
    public TsonMatrixBuilder removeParam(TsonElementBase element) {
        if (element != null && this.params != null) {
            this.params.remove(Tson.of(element).build());
        }
        return this;
    }

    @Override
    public TsonMatrixBuilder addParam(TsonElementBase element, int index) {
        if (element != null) {
            if (this.params == null) {
                this.params = new ArrayList<TsonElement>();
            }
            this.params.add(index, Tson.of(element).build());
        }
        return this;
    }

    @Override
    public TsonMatrixBuilder removeParamAt(int index) {
        if (this.params != null) {
            this.params.remove(index);
        }
        return this;
    }

    @Override
    public TsonMatrixBuilder addParams(TsonElement[] element) {
        if (element != null) {
            for (TsonElement tsonElement : element) {
                this.addParam(tsonElement);
            }
        }
        return this;
    }

    @Override
    public TsonMatrixBuilder addParams(TsonElementBase[] element) {
        if (element != null) {
            for (TsonElementBase tsonElement : element) {
                this.addParam(tsonElement);
            }
        }
        return this;
    }

    @Override
    public TsonMatrixBuilder addParams(Iterable<? extends TsonElementBase> element) {
        if (element != null) {
            for (TsonElementBase tsonElementBase : element) {
                this.addParam(tsonElementBase);
            }
        }
        return this;
    }
}

