/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBaseList;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBaseListBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPair;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonElementBaseListBuilderImpl;

public class TsonElementBaseListImpl
implements TsonElementBaseList {
    private ArrayList<TsonElementBase> elements = new ArrayList();

    public TsonElementBaseListImpl(ArrayList<TsonElementBase> elements) {
        for (TsonElementBase element : elements) {
            this.elements.add(Tson.ofElementBase(element));
        }
    }

    @Override
    public TsonElementBase getAt(int index) {
        return this.elements.get(index);
    }

    @Override
    public TsonElementBase get(String name) {
        return this.get(name == null ? null : Tson.ofString(name));
    }

    @Override
    public TsonElementBase get(TsonElementBase name) {
        TsonElement vn = (name == null ? Tson.ofNull() : name).build();
        for (TsonElementBase element : this.elements) {
            if (element instanceof TsonPair) {
                TsonPair element1 = (TsonPair)element;
                if (!Objects.equals(element1.key().build(), vn)) continue;
                return element1.value();
            }
            if (!Objects.equals(element.build(), vn)) continue;
            return element;
        }
        return null;
    }

    @Override
    public List<TsonElementBase> get2(String name) {
        return this.get2(name == null ? null : Tson.ofString(name));
    }

    @Override
    public List<TsonElementBase> get2(TsonElementBase name) {
        TsonElement vn = (name == null ? Tson.ofNull() : name).build();
        ArrayList<TsonElementBase> all = new ArrayList<TsonElementBase>();
        LinkedHashMap m = new LinkedHashMap();
        for (TsonElementBase element : this.elements) {
            if (element instanceof TsonPair) {
                TsonPair element1 = (TsonPair)element;
                if (!Objects.equals(element1.key().build(), vn)) continue;
                all.add(element1.value());
                continue;
            }
            if (!Objects.equals(element.build(), vn)) continue;
            all.add(element);
        }
        return all;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public TsonElementBaseListBuilder builder() {
        return new TsonElementBaseListBuilderImpl(this.elements);
    }

    @Override
    public Iterator<TsonElementBase> iterator() {
        return this.elements.iterator();
    }

    @Override
    public Map<TsonElementBase, TsonElementBase> toMap() {
        LinkedHashMap<TsonElementBase, TsonElementBase> m = new LinkedHashMap<TsonElementBase, TsonElementBase>();
        for (TsonElementBase element : this.elements) {
            if (element instanceof TsonPair) {
                TsonPair element1 = (TsonPair)element;
                m.put(element1.key(), element1.value());
                continue;
            }
            m.put(element, element);
        }
        return m;
    }

    @Override
    public Map<TsonElementBase, List<TsonElementBase>> toMap2() {
        LinkedHashMap<TsonElementBase, List<TsonElementBase>> m = new LinkedHashMap<TsonElementBase, List<TsonElementBase>>();
        for (TsonElementBase element : this.elements) {
            if (element instanceof TsonPair) {
                TsonPair element1 = (TsonPair)element;
                m.computeIfAbsent(element1.key(), k -> new ArrayList()).add(element1.value());
                continue;
            }
            m.computeIfAbsent(element, k -> new ArrayList()).add(element);
        }
        return m;
    }

    @Override
    public List<TsonElementBase> toList() {
        return new ArrayList<TsonElementBase>(this.elements);
    }
}

