/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotation;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotationBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentHeader;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentHeaderBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPair;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonDocumentHeaderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;

public class TsonDocumentHeaderBuilderImpl
implements TsonDocumentHeaderBuilder {
    private String version = null;
    private String encoding = null;
    private List<TsonElement> params = new ArrayList<TsonElement>();

    @Override
    public TsonDocumentHeaderBuilderImpl reset() {
        this.version = null;
        this.encoding = null;
        return this;
    }

    @Override
    public TsonDocumentHeaderBuilderImpl parse(TsonAnnotation a) {
        if (Objects.equals(a.name().orNull(), "tson")) {
            List<TsonElement> params = a.params();
            boolean acceptStr = true;
            if (params != null) {
                for (TsonElement param : params) {
                    block0 : switch (param.type()) {
                        case PAIR: {
                            acceptStr = false;
                            TsonPair kv = param.toPair();
                            switch (kv.key().stringValue()) {
                                case "version": {
                                    this.version = kv.value().stringValue();
                                    break block0;
                                }
                                case "encoding": {
                                    this.encoding = kv.value().stringValue();
                                    break block0;
                                }
                            }
                            this.params.add(kv);
                            break;
                        }
                        case DOUBLE_QUOTED_STRING: 
                        case SINGLE_QUOTED_STRING: 
                        case ANTI_QUOTED_STRING: 
                        case TRIPLE_DOUBLE_QUOTED_STRING: 
                        case TRIPLE_SINGLE_QUOTED_STRING: 
                        case TRIPLE_ANTI_QUOTED_STRING: 
                        case LINE_STRING: 
                        case CHAR: 
                        case NAME: {
                            if (acceptStr) {
                                String v = param.stringValue();
                                if (this.version == null && v.startsWith("v")) {
                                    this.version = v.substring(1);
                                    break;
                                }
                                if (this.encoding == null) {
                                    String y = param.stringValue();
                                    if (Charset.availableCharsets().containsKey(y)) {
                                        this.encoding = y;
                                    }
                                    acceptStr = false;
                                    break;
                                }
                                acceptStr = false;
                                this.params.add(param);
                                break;
                            }
                            this.params.add(param);
                            break;
                        }
                        default: {
                            acceptStr = false;
                            this.params.add(param);
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public TsonDocumentHeaderBuilderImpl setVersion(String version) {
        this.version = version;
        return this;
    }

    @Override
    public TsonDocumentHeaderBuilderImpl setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public TsonElement[] getParams() {
        return this.params.toArray(TsonUtils.TSON_ELEMENTS_EMPTY_ARRAY);
    }

    @Override
    public TsonDocumentHeaderBuilder with(TsonElementBase ... elements) {
        return this.addParams(elements);
    }

    @Override
    public TsonDocumentHeaderBuilder addParam(TsonElementBase element) {
        if (element != null) {
            this.params.add(Tson.of(element));
        }
        return this;
    }

    @Override
    public TsonDocumentHeaderBuilder removeParam(TsonElementBase element) {
        this.params.remove(Tson.of(element));
        return this;
    }

    @Override
    public TsonDocumentHeaderBuilder addParam(TsonElementBase element, int index) {
        this.params.add(index, Tson.of(element));
        return this;
    }

    @Override
    public TsonDocumentHeaderBuilder removeParamAt(int index) {
        this.params.remove(index);
        return this;
    }

    @Override
    public TsonDocumentHeaderBuilder addParams(TsonElementBase ... element) {
        for (TsonElementBase tsonElement : element) {
            this.addParam(tsonElement);
        }
        return this;
    }

    @Override
    public TsonDocumentHeaderBuilder addParams(Iterable<? extends TsonElementBase> elements) {
        if (elements != null) {
            for (TsonElementBase tsonElementBase : elements) {
                this.addParam(tsonElementBase);
            }
        }
        return this;
    }

    @Override
    public TsonAnnotation toAnnotation() {
        TsonAnnotationBuilder b = Tson.ofAnnotationBuilder().name("tson");
        if (this.version == null && this.encoding == null && this.params.isEmpty()) {
            b.add(Tson.ofString("v" + Tson.getVersion()));
        } else {
            b.add(Tson.ofPair("version", (TsonElementBase)Tson.ofString(TsonUtils.isBlank(this.version) ? Tson.getVersion() : this.version.trim())));
            if (this.encoding != null) {
                b.add(Tson.ofPair("encoding", (TsonElementBase)Tson.ofString(TsonUtils.isBlank(this.version) ? Tson.getVersion() : this.version.trim())));
            }
            for (TsonElement e : this.params) {
                b.add(e);
            }
        }
        return b.build();
    }

    @Override
    public TsonDocumentHeader build() {
        return new TsonDocumentHeaderImpl(TsonUtils.isBlank(this.version) ? Tson.getVersion() : this.version.trim(), this.encoding, this.params.toArray(TsonUtils.TSON_ELEMENTS_EMPTY_ARRAY));
    }
}

