/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonApiUtils;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonComment;

public class TsonComments
implements Comparable<TsonComments> {
    public static final TsonComments BLANK = new TsonComments();
    private TsonComment[] leadingComments;
    private TsonComment[] trailingComments;

    private static TsonComment[] _trim(TsonComment[] all) {
        ArrayList<TsonComment> ok = new ArrayList<TsonComment>();
        if (all != null) {
            for (TsonComment a : all) {
                if (a == null || a.text().length() <= 0) continue;
                ok.add(a);
            }
        }
        return ok.toArray(new TsonComment[0]);
    }

    public TsonComments() {
        this.leadingComments = new TsonComment[0];
        this.trailingComments = new TsonComment[0];
    }

    public TsonComments(TsonComment[] leadingComments, TsonComment[] trailingComments) {
        this.leadingComments = TsonComments._trim(leadingComments);
        this.trailingComments = TsonComments._trim(trailingComments);
    }

    public static TsonComments concat(TsonComments a, TsonComments b) {
        if (a == null && b == null) {
            return null;
        }
        if (a != null) {
            return a.concat(b);
        }
        return b;
    }

    public static TsonComments ofMultiLine(String a) {
        return new TsonComments(new TsonComment[]{TsonComment.ofMultiLine(a)}, null);
    }

    public static TsonComments ofSingleLine(String a) {
        return new TsonComments(new TsonComment[]{TsonComment.ofSingleLine(a)}, null);
    }

    public TsonComments concat(TsonComments other) {
        if (other != null && !other.isEmpty()) {
            ArrayList<TsonComment> a = new ArrayList<TsonComment>();
            ArrayList<TsonComment> b = new ArrayList<TsonComment>();
            a.addAll(Arrays.asList(this.leadingComments()));
            a.addAll(Arrays.asList(other.leadingComments()));
            b.addAll(Arrays.asList(this.trailingComments()));
            b.addAll(Arrays.asList(other.trailingComments()));
            return new TsonComments(a.toArray(new TsonComment[0]), b.toArray(new TsonComment[0]));
        }
        return this;
    }

    public TsonComments addLeading(TsonComment ... other) {
        if (other != null) {
            ArrayList<TsonComment> a = new ArrayList<TsonComment>();
            ArrayList<TsonComment> b = new ArrayList<TsonComment>();
            a.addAll(Arrays.asList(this.leadingComments()));
            b.addAll(Arrays.asList(this.trailingComments()));
            a.addAll(Arrays.asList(TsonComments._trim(other)));
            return new TsonComments(a.toArray(new TsonComment[0]), b.toArray(new TsonComment[0]));
        }
        return this;
    }

    public TsonComments addTrailing(TsonComment ... other) {
        if (other != null) {
            ArrayList<TsonComment> a = new ArrayList<TsonComment>();
            ArrayList<TsonComment> b = new ArrayList<TsonComment>();
            a.addAll(Arrays.asList(this.leadingComments()));
            b.addAll(Arrays.asList(this.trailingComments()));
            b.addAll(Arrays.asList(TsonComments._trim(other)));
            return new TsonComments(a.toArray(new TsonComment[0]), b.toArray(new TsonComment[0]));
        }
        return this;
    }

    public TsonComments addLeading(TsonComment other) {
        if (other != null) {
            ArrayList<TsonComment> a = new ArrayList<TsonComment>();
            ArrayList<TsonComment> b = new ArrayList<TsonComment>();
            a.addAll(Arrays.asList(this.leadingComments()));
            b.addAll(Arrays.asList(this.trailingComments()));
            a.add(other);
            return new TsonComments(a.toArray(new TsonComment[0]), b.toArray(new TsonComment[0]));
        }
        return this;
    }

    public TsonComments addTrailing(TsonComment other) {
        if (other != null) {
            ArrayList<TsonComment> a = new ArrayList<TsonComment>();
            ArrayList<TsonComment> b = new ArrayList<TsonComment>();
            a.addAll(Arrays.asList(this.leadingComments()));
            b.addAll(Arrays.asList(this.trailingComments()));
            b.add(other);
            return new TsonComments(a.toArray(new TsonComment[0]), b.toArray(new TsonComment[0]));
        }
        return this;
    }

    public TsonComment[] getComments() {
        return this.leadingComments;
    }

    public TsonComment[] trailingComments() {
        return this.trailingComments;
    }

    public TsonComment[] leadingComments() {
        return this.leadingComments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsonComments that = (TsonComments)o;
        return Objects.deepEquals(this.leadingComments, that.leadingComments) && Objects.deepEquals(this.trailingComments, that.trailingComments);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.leadingComments), Arrays.hashCode(this.trailingComments));
    }

    public boolean isEmpty() {
        return this.leadingComments.length == 0 && this.trailingComments.length == 0;
    }

    @Override
    public int compareTo(TsonComments o) {
        int i = TsonApiUtils.compareArrays((Comparable[])this.leadingComments(), (Comparable[])o.leadingComments());
        if (i != 0) {
            return i;
        }
        i = TsonApiUtils.compareArrays((Comparable[])this.trailingComments(), (Comparable[])o.trailingComments());
        if (i != 0) {
            return i;
        }
        return 0;
    }
}

