/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled;

import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonCommentType;

public class TsonComment
implements Comparable<TsonComment> {
    private TsonCommentType type;
    private String text;

    public static TsonComment of(String text) {
        return TsonComment.ofMultiLine(text);
    }

    public static TsonComment ofMultiLine(String text) {
        return new TsonComment(TsonCommentType.MULTI_LINE, text);
    }

    public static TsonComment ofSingleLine(String text) {
        return new TsonComment(TsonCommentType.SINGLE_LINE, text);
    }

    public TsonComment(TsonCommentType type, String text) {
        this.type = type;
        this.text = text == null ? "" : text;
    }

    public TsonCommentType type() {
        return this.type;
    }

    public String text() {
        return this.text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsonComment that = (TsonComment)o;
        return this.type == that.type && Objects.equals(this.text, that.text);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.text});
    }

    @Override
    public int compareTo(TsonComment o) {
        int i = this.text.compareTo(o.text);
        if (i != 0) {
            return i;
        }
        return this.type.compareTo(o.type);
    }
}

