/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.table;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElements;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.text.art.table.DefaultNTextArtTableRenderer;
import net.thevpc.nuts.runtime.standalone.text.util.NTextUtils;
import net.thevpc.nuts.text.NFormattable;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NMutableTableModel;
import net.thevpc.nuts.text.NTableFormat;
import net.thevpc.nuts.text.NTableModel;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NUnsupportedArgumentException;

public class DefaultTableFormat
extends DefaultFormatBase<NTableFormat>
implements NTableFormat {
    private Object model;
    private DefaultNTextArtTableRenderer helper = new DefaultNTextArtTableRenderer();

    public DefaultTableFormat(NWorkspace workspace) {
        super("table-format");
    }

    @Override
    public NTableModel getModel() {
        return this.createTableModel(this.model);
    }

    @Override
    public NTableFormat setValue(Object value) {
        this.model = value;
        return this;
    }

    @Override
    public void print(NPrintStream w) {
        NPrintStream out = this.getValidPrintStream(w);
        out.print(this.helper.render(this.getModel()));
        out.flush();
    }

    @Override
    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter(out);
        this.print(w);
        try {
            w.flush();
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
        return out.toString();
    }

    private NTableModel createTableModel(Object o) {
        if (o == null) {
            return NMutableTableModel.of();
        }
        if (o instanceof NTableModel) {
            return (NTableModel)o;
        }
        if (o instanceof String || o instanceof Number || o instanceof Date || o instanceof Temporal || o instanceof Path || o instanceof File) {
            ArrayList<NElement> a = new ArrayList<NElement>();
            a.add(NElements.of().toElement(o));
            return this.createTableModel(NElements.of().toElement(a));
        }
        o = NElements.of().destruct(o);
        if (o instanceof Collection) {
            return this._model2(o);
        }
        if (o instanceof Map) {
            NMutableTableModel model = NMutableTableModel.of();
            LinkedHashSet<String> columns = new LinkedHashSet<String>();
            columns.add("Name");
            columns.add("Value");
            for (String string : columns) {
                model.addHeaderCell(NText.of(string));
            }
            for (Map.Entry entry : ((Map)o).entrySet()) {
                model.newRow();
                model.addCell(this.formatObject(entry.getKey()));
                model.addCell(this.formatObject(entry.getValue()));
            }
            return model;
        }
        if (o instanceof NMsg || o instanceof NText || o instanceof NFormattable) {
            NMutableTableModel model = NMutableTableModel.of();
            model.newRow();
            model.addCell(this.formatObject(o));
            return model;
        }
        if (!(o instanceof NElement)) {
            return this.createTableModel(NElements.of().toElement(o));
        }
        NElement elem = (NElement)o;
        switch (elem.type()) {
            case BOOLEAN: 
            case INSTANT: 
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: 
            case TRIPLE_ANTI_QUOTED_STRING: 
            case LINE_STRING: 
            case INT: 
            case FLOAT: 
            case NULL: {
                ArrayList<NElement> a = new ArrayList<NElement>();
                a.add(elem);
                return this.createTableModel(NElements.of().toElement(a));
            }
            case OBJECT: {
                return this.createTableModel(NElements.of().toElement(elem.asObject().get().children()));
            }
            case ARRAY: {
                return this._model2(elem);
            }
        }
        throw new NUnsupportedArgumentException(NMsg.ofC("unsupported %s", elem.type()));
    }

    public NMutableTableModel _model2(Object obj) {
        NMutableTableModel model = NMutableTableModel.of();
        List<SimpleRow> rows = this.resolveColumnsFromRows(obj);
        ArrayList<String> titles = new ArrayList<String>();
        HashSet<String> titlesSet = new HashSet<String>();
        if (rows.size() > 0) {
            titles.addAll(rows.get((int)0).cells.stream().map(x -> ((SimpleCell)x).title).collect(Collectors.toList()));
            titlesSet.addAll(titles);
        }
        for (SimpleRow row : rows) {
            for (SimpleCell cell : row.cells) {
                if (titlesSet.contains(cell.title)) continue;
                titlesSet.add(cell.title);
                titles.add(cell.title);
            }
        }
        for (String column : titles) {
            model.addHeaderCell(NText.of(column));
        }
        for (SimpleRow row : rows) {
            model.newRow();
            Boolean[] visited = new Boolean[row.cells.size()];
            block4: for (String title : titles) {
                List<SimpleCell> cells = row.cells;
                for (int i = 0; i < cells.size(); ++i) {
                    SimpleCell cell = cells.get(i);
                    if (visited[i] != null || !Objects.equals(cell.title, title)) continue;
                    if (cell.value != null) {
                        model.addCell(this.formatObject(cell.value));
                    } else {
                        model.addCell(NText.of(""));
                    }
                    visited[i] = true;
                    continue block4;
                }
            }
        }
        return model;
    }

    public List<SimpleRow> resolveColumnsFromRows(Object obj) {
        ArrayList<SimpleRow> rows;
        block8: {
            block7: {
                rows = new ArrayList<SimpleRow>();
                if (!(obj instanceof NElement)) break block7;
                NElement value = (NElement)obj;
                switch (value.type()) {
                    case ARRAY: {
                        for (NElement value2 : value.asArray().get().children()) {
                            rows.add(this.resolveColumnsFromRow(value2));
                        }
                        break block8;
                    }
                    default: {
                        rows.add(this.resolveColumnsFromRow(value));
                    }
                }
                break block8;
            }
            if (obj instanceof Collection) {
                for (Object value2 : (Collection)obj) {
                    rows.add(this.resolveColumnsFromRow(value2));
                }
            } else {
                rows.add(this.resolveColumnsFromRow(obj));
            }
        }
        return rows;
    }

    public SimpleRow resolveColumnsFromRow(Object obj) {
        if (obj instanceof NElement) {
            NElement value = (NElement)obj;
            switch (value.type()) {
                case OBJECT: {
                    SimpleRow e = new SimpleRow();
                    int column = 1;
                    for (NElement ne : value.asObject().get().children()) {
                        if (ne instanceof NPairElement) {
                            NPairElement nee = (NPairElement)ne;
                            NElement k = nee.key();
                            if (!k.isString()) {
                                k = NElement.ofString(k.toString());
                            }
                            e.cells.add(this.resolveColumnsFromCell(k.asStringValue().get(), nee.value()));
                        } else {
                            e.cells.add(this.resolveColumnsFromCell("COL " + column, ne));
                        }
                        ++column;
                    }
                    return e;
                }
                case ARRAY: {
                    SimpleRow e = new SimpleRow();
                    int column = 1;
                    for (NElement value2 : value.asArray().get().children()) {
                        e.cells.add(this.resolveColumnsFromCell("COL " + column, value2));
                        ++column;
                    }
                    return e;
                }
            }
            SimpleRow e = new SimpleRow();
            e.cells.add(this.resolveColumnsFromCell("value", value));
            return e;
        }
        if (obj instanceof Collection) {
            SimpleRow e = new SimpleRow();
            int column = 1;
            for (Object value2 : (Collection)obj) {
                e.cells.add(this.resolveColumnsFromCell("COL " + column, value2));
                ++column;
            }
            return e;
        }
        if (obj instanceof Map) {
            HashMap<String, NText> m = new HashMap<String, NText>();
            Map omap = (Map)obj;
            SimpleRow e = new SimpleRow();
            for (Map.Entry vv : omap.entrySet()) {
                String k = String.valueOf(vv.getKey());
                m.put(k, this.formatObject(vv.getValue()));
                e.cells.add(this.resolveColumnsFromCell(k, vv.getValue()));
            }
            return e;
        }
        SimpleRow e = new SimpleRow();
        e.cells.add(this.resolveColumnsFromCell("value", obj));
        return e;
    }

    public SimpleCell resolveColumnsFromCell(String title, Object obj) {
        return new SimpleCell(title, obj == null ? null : this.formatObject(obj));
    }

    @Override
    public Object getValue() {
        return this.model;
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg a = cmdLine.nextFlag("--no-header").orNull();
        if (a != null) {
            boolean val = a.getBooleanValue().get();
            if (a.isUncommented()) {
                this.helper.setVisibleHeader(!val);
            }
            return true;
        }
        a = cmdLine.nextFlag("--header").orNull();
        if (a != null) {
            boolean val = a.getBooleanValue().get();
            if (a.isUncommented()) {
                this.helper.setVisibleHeader(val);
            }
            return true;
        }
        a = cmdLine.nextEntry("--border").orNull();
        if (a != null) {
            if (a.isUncommented()) {
                this.helper.setBorder(a.getValue().asString().orElse(""));
            }
            return true;
        }
        if (cmdLine.hasNext() && cmdLine.isNextOption()) {
            int cc = this.getModel().getColumnsCount();
            HashMap<String, Integer> columns = new HashMap<String, Integer>();
            for (int i = 0; i < cc; ++i) {
                NText v = this.getModel().getHeaderValue(cc);
                if (!(v instanceof String)) continue;
                columns.put(((Object)v).toString().toLowerCase(), i);
            }
            NArg a2 = null;
            for (Map.Entry e : columns.entrySet()) {
                a2 = cmdLine.next("--" + (String)e.getKey()).orNull();
                if (a2 != null) {
                    if (a2.isUncommented()) {
                        this.helper.setVisibleColumn((Integer)e.getValue(), true);
                    }
                    return true;
                }
                a2 = cmdLine.next("--no-" + (String)e.getKey()).orNull();
                if (a2 == null) continue;
                if (a2.isUncommented()) {
                    this.helper.setVisibleColumn((Integer)e.getValue(), false);
                }
                return true;
            }
        }
        return false;
    }

    private NText formatObject(Object any) {
        return NTextUtils.stringValueFormatted(any, false);
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    private static class SimpleRow {
        List<SimpleCell> cells = new ArrayList<SimpleCell>();

        private SimpleRow() {
        }
    }

    private static class SimpleCell {
        private String title;
        private NText value;

        public SimpleCell(String title, NText value) {
            this.title = title;
            this.value = value;
        }
    }
}

