/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.props;

import java.io.Reader;
import java.io.StringReader;
import net.thevpc.nuts.elem.NArrayElement;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementFactoryContext;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.elem.NElementStreamFormat;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NHex;
import net.thevpc.nuts.util.NUnsupportedOperationException;

public class DefaultPropsElementFormat
implements NElementStreamFormat {
    public NElement parseElement(String string, NElementFactoryContext context, Object readerSource) {
        if (string == null) {
            string = "";
        }
        return this.parseElement(new StringReader(string), context, readerSource);
    }

    @Override
    public NElement normalize(NElement e) {
        return e;
    }

    public void write(NPrintStream out, NElement data, boolean compact) {
        this.write(out, data, compact ? null : "");
    }

    private void write(NPrintStream out, NElement data, String indent) {
        switch (data.type()) {
            case NULL: {
                out.print("null");
                break;
            }
            case BOOLEAN: {
                out.print(data.asBooleanValue().orElse(false));
                break;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                out.print(data.asNumberValue().orElse(0));
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                out.print(data.asNumberValue().orElse(0.0));
                break;
            }
            case INSTANT: 
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: 
            case TRIPLE_ANTI_QUOTED_STRING: 
            case LINE_STRING: {
                StringBuilder sb = new StringBuilder("\"");
                String str = data.asStringValue().orElse("");
                char[] chars = str.toCharArray();
                block20: for (int i = 0; i < chars.length; ++i) {
                    char c = chars[i];
                    if (c < ' ') {
                        switch (c) {
                            case '\n': {
                                sb.append('\\').append('n');
                                break;
                            }
                            case '\f': {
                                sb.append('\\').append('f');
                                break;
                            }
                            case '\t': {
                                sb.append('\\').append('t');
                                break;
                            }
                            case '\r': {
                                sb.append('\\').append('r');
                                break;
                            }
                            case '\b': {
                                sb.append('\\').append('b');
                                break;
                            }
                            default: {
                                sb.append('\\');
                                sb.append('u');
                                sb.append(NHex.toHexChar(c >> 12 & 0xF));
                                sb.append(NHex.toHexChar(c >> 8 & 0xF));
                                sb.append(NHex.toHexChar(c >> 4 & 0xF));
                                sb.append(NHex.toHexChar(c & 0xF));
                                break;
                            }
                        }
                        continue;
                    }
                    switch (c) {
                        case '\\': {
                            sb.append(c).append(c);
                            continue block20;
                        }
                        case '\"': {
                            sb.append('\\').append('\"');
                            continue block20;
                        }
                        default: {
                            if (c > '~') {
                                sb.append('\\');
                                sb.append('u');
                                sb.append(NHex.toHexChar(c >> 12 & 0xF));
                                sb.append(NHex.toHexChar(c >> 8 & 0xF));
                                sb.append(NHex.toHexChar(c >> 4 & 0xF));
                                sb.append(NHex.toHexChar(c & 0xF));
                                continue block20;
                            }
                            sb.append(c);
                        }
                    }
                }
                sb.append('\"');
                out.print(sb);
                break;
            }
            case ARRAY: {
                NArrayElement arr = data.asArray().get();
                if (arr.size() == 0) {
                    out.print("[]");
                    break;
                }
                out.print('[');
                boolean first = true;
                String indent2 = indent + "  ";
                for (NElement e : arr.children()) {
                    if (first) {
                        first = false;
                    } else {
                        out.print(',');
                    }
                    if (indent != null) {
                        out.print('\n');
                        out.print(indent2);
                        this.write(out, e, indent2);
                        continue;
                    }
                    this.write(out, e, null);
                }
                if (indent != null) {
                    out.print('\n');
                    out.print(indent);
                }
                out.print(']');
                break;
            }
            case OBJECT: {
                NObjectElement obj = data.asObject().get();
                if (obj.size() <= 0) break;
                boolean first = true;
                String indent2 = indent + "  ";
                for (NElement e : obj.children()) {
                    NPairElement ee;
                    if (first) {
                        first = false;
                    } else {
                        out.print("\n");
                    }
                    if (indent != null) {
                        out.print('\n');
                        out.print(indent2);
                        if (e instanceof NPairElement) {
                            ee = (NPairElement)e;
                            this.write(out, ee.key(), indent2);
                            out.print(':');
                            out.print(' ');
                            this.write(out, ee.value(), indent2);
                            continue;
                        }
                        this.write(out, e, indent2);
                        continue;
                    }
                    if (e instanceof NPairElement) {
                        ee = (NPairElement)e;
                        this.write(out, ee.key(), null);
                        out.print(':');
                        this.write(out, ee.value(), null);
                        continue;
                    }
                    this.write(out, e, null);
                }
                if (indent == null) break;
                out.print('\n');
                out.print(indent);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported");
            }
        }
    }

    @Override
    public NElement parseElement(Reader reader, NElementFactoryContext context, Object readerSource) {
        throw new NUnsupportedOperationException(NMsg.ofC("unable to parse Props for the moment"));
    }

    @Override
    public void printElement(NElement value, NPrintStream out, boolean compact, NElementFactoryContext context) {
        this.write(out, value, compact);
    }
}

