/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.props;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NArrayElement;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElements;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.format.ObjectOutputFormatWriterHelper;
import net.thevpc.nuts.runtime.standalone.text.util.NTextUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.text.NPositionType;
import net.thevpc.nuts.text.NPropertiesFormat;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NPropsTransformer;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNPropertiesFormat
extends DefaultFormatBase<NPropertiesFormat>
implements NPropertiesFormat {
    public static final String OPTION_MULTILINE_PROPERTY = "--multiline-property";
    private boolean sorted;
    private boolean compact;
    private boolean javaProps;
    private String rootName = "";
    private final boolean omitNull = true;
    private boolean escapeText = true;
    private String separator = " = ";
    private Object value;
    private Map<String, String> multilineProperties = new HashMap<String, String>();

    public DefaultNPropertiesFormat(NWorkspace workspace) {
        super("props-format");
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg a = cmdLine.nextEntry(OPTION_MULTILINE_PROPERTY).orNull();
        if (a != null) {
            NArg i = NArg.of(a.getStringValue().get());
            if (i.isUncommented()) {
                this.addMultilineProperty(i.getKey().asString().get(), i.getStringValue().get());
            }
            return true;
        }
        a = cmdLine.nextFlag("--compact").orNull();
        if (a != null) {
            if (a.isUncommented()) {
                this.compact = a.getBooleanValue().get();
            }
            return true;
        }
        a = cmdLine.nextFlag("--props").orNull();
        if (a != null) {
            if (a.isUncommented()) {
                this.javaProps = a.getBooleanValue().get();
            }
            return true;
        }
        a = cmdLine.nextFlag("--escape-text").orNull();
        if (a != null) {
            if (a.isUncommented()) {
                this.escapeText = a.getBooleanValue().get();
            }
            return true;
        }
        return false;
    }

    public DefaultNPropertiesFormat addMultilineProperty(String property, String separator) {
        this.multilineProperties.put(property, separator);
        return this;
    }

    public Map buildModel() {
        NElements e = NElements.of();
        Object value = e.destruct(this.getValue());
        LinkedHashMap<NText, NText> map = new LinkedHashMap<NText, NText>();
        this.fillMap(NText.of(this.rootName == null ? "" : this.rootName), value, map);
        return map;
    }

    private void fillMap(NText entryKey, Object entryValue, Map<NText, NText> map) {
        if (entryValue instanceof Map) {
            for (Map.Entry entry : ((Map)entryValue).entrySet()) {
                Object k = entry.getKey();
                NText ns = entryKey.isEmpty() ? this.stringValue(k) : entryKey.builder().append(".").append(this.stringValue(k));
                Object v = entry.getValue();
                this.fillMap(ns, v, map);
            }
        } else if (entryValue instanceof NObjectElement) {
            int i = 0;
            for (NElement item : (NObjectElement)entryValue) {
                if (item instanceof NPairElement) {
                    NPairElement entry = (NPairElement)item;
                    NElement k = entry.key();
                    NText ns = entryKey.isEmpty() ? this.stringValue(k) : entryKey.builder().append(".").append(this.stringValue(k));
                    NElement v = entry.value();
                    this.fillMap(ns, v, map);
                    continue;
                }
                NTextBuilder ns = entryKey.builder().append("[").append(this.stringValue(i + 1)).append("]");
                this.fillMap(ns, item, map);
                ++i;
            }
        } else if (entryValue instanceof NArrayElement) {
            NArrayElement objects = (NArrayElement)entryValue;
            for (int i = 0; i < objects.size(); ++i) {
                NTextBuilder ns = entryKey.builder().append("[").append(this.stringValue(i + 1)).append("]");
                this.fillMap(ns, objects.get(i), map);
            }
        } else if (entryValue instanceof List) {
            List objects = (List)entryValue;
            for (int i = 0; i < objects.size(); ++i) {
                NTextBuilder ns = entryKey.builder().append("[").append(this.stringValue(i + 1)).append("]");
                this.fillMap(ns, objects.get(i), map);
            }
        } else if (entryValue != null) {
            if (!entryKey.isEmpty()) {
                map.put(entryKey, this.stringValue(entryValue));
            } else {
                map.put(NText.ofPlain("value"), this.stringValue(entryValue));
            }
        }
    }

    public Map getModel() {
        return this.buildModel();
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public String getSeparator() {
        return this.separator;
    }

    @Override
    public DefaultNPropertiesFormat setSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    @Override
    public DefaultNPropertiesFormat setSorted(boolean sort) {
        this.sorted = sort;
        return this;
    }

    @Override
    public void print(NPrintStream w) {
        LinkedHashMap<Object, Object> mm;
        NPrintStream out = this.getValidPrintStream(w);
        LinkedHashMap<Object, Object> model = this.buildModel();
        if (this.sorted) {
            mm = new LinkedHashMap<Object, Object>();
            ArrayList keys = new ArrayList(model.keySet());
            if (this.sorted) {
                keys.sort(null);
            }
            for (Object k : keys) {
                Object v = model.get(k);
                mm.put(k, v);
            }
        } else {
            mm = model;
        }
        if (this.javaProps) {
            NPropsTransformer.storeProperties(ObjectOutputFormatWriterHelper.explodeMap(mm), w.asPrintStream(), this.sorted);
        } else {
            this.printMap(out, NText.ofBlank(), mm);
        }
    }

    private void printMap(NPrintStream out, NText prefix, Map<Object, Object> props) {
        int len = 1;
        for (Object extraKey : props.keySet()) {
            int x = this.stringValue(extraKey).length();
            if (x <= len) continue;
            len = x;
        }
        boolean first = true;
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            if (first) {
                first = false;
            } else {
                out.println();
            }
            this.printKeyValue(out, prefix, len, this.stringValue(e.getKey()), this.stringValue(e.getValue()));
        }
        out.flush();
    }

    private String getMultilineSeparator(NText key) {
        String sep = this.multilineProperties.get(key.filteredText());
        if (sep != null && sep.length() == 0) {
            sep = ":|;";
        }
        return sep;
    }

    private void printKeyValue(NPrintStream out, NText prefix, int len, NText key, NText value) {
        this.printKeyValue(out, prefix, len, this.getMultilineSeparator(key), key, value);
    }

    private void printKeyValue(NPrintStream out, NText prefix, int len, String fancySep, NText key, NText value) {
        NText formattedKey;
        NTexts txt = NTexts.of();
        if (prefix == null) {
            prefix = txt.ofBlank();
        }
        NText nText = formattedKey = this.compact ? key : txt.ofBuilder().append(key).append(CoreStringUtils.fillString(' ', len - key.length()));
        if (fancySep != null) {
            NText cc = this.compact ? key : txt.ofPlain(NStringUtils.formatAlign("", len + 3, NPositionType.FIRST));
            String[] split = value.toString().split(fancySep);
            if (split.length == 0) {
                out.print(prefix);
                out.print(formattedKey);
                out.print(this.separator);
            } else {
                for (int i = 0; i < split.length; ++i) {
                    String s = split[i];
                    if (i == 0) {
                        out.print(prefix);
                        if ((prefix.isEmpty() || prefix.toString().endsWith("#")) && out.isNtf()) {
                            out.print('\u001e');
                        }
                        out.print(formattedKey);
                        if ((this.separator.isEmpty() || this.separator.startsWith("#")) && out.isNtf()) {
                            out.print('\u001e');
                        }
                        out.print(this.separator);
                        out.print(s);
                        continue;
                    }
                    out.println();
                    out.print(cc);
                    out.print(s);
                }
            }
        } else {
            out.print(prefix);
            if ((prefix.isEmpty() || prefix.toString().endsWith("#")) && out.isNtf()) {
                out.print('\u001e');
            }
            out.print(txt.ofStyled(formattedKey, NTextStyle.primary3()));
            if ((this.separator.isEmpty() || this.separator.startsWith("#")) && out.isNtf()) {
                out.print('\u001e');
            }
            out.print(this.separator);
            out.print(value);
        }
    }

    private NText stringValue(Object o) {
        if (this.escapeText) {
            return NTextUtils.stringValueFormatted(o, this.escapeText);
        }
        return NText.of(o);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public NPropertiesFormat setValue(Object value) {
        this.value = value;
        return this;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

