/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import net.thevpc.nuts.elem.NArrayElement;
import net.thevpc.nuts.elem.NArrayElementBuilder;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementFactoryContext;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.elem.NObjectElementBuilder;
import net.thevpc.nuts.elem.NOperatorElement;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.elem.NPairElementBuilder;
import net.thevpc.nuts.elem.NUpletElement;
import net.thevpc.nuts.expr.NParseException;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.elem.NElementStreamFormat;
import net.thevpc.nuts.runtime.standalone.format.json.ReaderLocation;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NHex;
import net.thevpc.nuts.util.NUnsupportedOperationException;

public class DefaultJsonElementFormat
implements NElementStreamFormat {
    public NElement parseElement(String string, NElementFactoryContext context, Object readerSource) {
        if (string == null) {
            string = "";
        }
        return this.parseElement(new StringReader(string), context, readerSource);
    }

    public void write(NPrintStream out, NElement data, boolean compact) {
        this.writeSafe(out, this.ensureJson(data), compact ? null : "");
    }

    private void write(NPrintStream out, NElement data, String indent) {
        this.writeSafe(out, this.ensureJson(data), indent);
    }

    private void writeSafe(NPrintStream out, NElement data, String indent) {
        switch (data.type()) {
            case NULL: {
                out.print("null");
                break;
            }
            case BOOLEAN: {
                out.print(data.asBooleanValue().orElse(false));
                break;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                out.print(data.asNumberValue().orElse(0));
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                out.print(data.asNumberValue().orElse(0.0));
                break;
            }
            case INSTANT: 
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: 
            case TRIPLE_ANTI_QUOTED_STRING: 
            case LINE_STRING: 
            case NAME: {
                StringBuilder sb = new StringBuilder("\"");
                String str = data.asStringValue().orElse("");
                char[] chars = str.toCharArray();
                block20: for (int i = 0; i < chars.length; ++i) {
                    char c = chars[i];
                    if (c < ' ') {
                        switch (c) {
                            case '\n': {
                                sb.append('\\').append('n');
                                break;
                            }
                            case '\f': {
                                sb.append('\\').append('f');
                                break;
                            }
                            case '\t': {
                                sb.append('\\').append('t');
                                break;
                            }
                            case '\r': {
                                sb.append('\\').append('r');
                                break;
                            }
                            case '\b': {
                                sb.append('\\').append('b');
                                break;
                            }
                            default: {
                                sb.append('\\');
                                sb.append('u');
                                sb.append(NHex.toHexChar(c >> 12 & 0xF));
                                sb.append(NHex.toHexChar(c >> 8 & 0xF));
                                sb.append(NHex.toHexChar(c >> 4 & 0xF));
                                sb.append(NHex.toHexChar(c & 0xF));
                                break;
                            }
                        }
                        continue;
                    }
                    switch (c) {
                        case '\\': {
                            sb.append(c).append(c);
                            continue block20;
                        }
                        case '\"': {
                            sb.append('\\').append('\"');
                            continue block20;
                        }
                        default: {
                            if (c > '~') {
                                sb.append('\\');
                                sb.append('u');
                                sb.append(NHex.toHexChar(c >> 12 & 0xF));
                                sb.append(NHex.toHexChar(c >> 8 & 0xF));
                                sb.append(NHex.toHexChar(c >> 4 & 0xF));
                                sb.append(NHex.toHexChar(c & 0xF));
                                continue block20;
                            }
                            sb.append(c);
                        }
                    }
                }
                sb.append('\"');
                out.print(sb);
                break;
            }
            case ARRAY: {
                NArrayElement arr = data.asArray().get();
                if (arr.size() == 0) {
                    out.print("[]");
                    break;
                }
                out.print('[');
                boolean first = true;
                String indent2 = indent + "  ";
                for (NElement e : arr.children()) {
                    if (first) {
                        first = false;
                    } else {
                        out.print(',');
                    }
                    if (indent != null) {
                        out.print('\n');
                        out.print(indent2);
                        this.writeSafe(out, e, indent2);
                        continue;
                    }
                    this.writeSafe(out, e, null);
                }
                if (indent != null) {
                    out.print('\n');
                    out.print(indent);
                }
                out.print(']');
                break;
            }
            case OBJECT: {
                NObjectElement obj = data.asObject().get();
                if (obj.size() == 0) {
                    out.print("{}");
                    break;
                }
                out.print('{');
                boolean first = true;
                String indent2 = indent + "  ";
                for (NElement e : obj.children()) {
                    NPairElement ee;
                    if (first) {
                        first = false;
                    } else {
                        out.print(',');
                    }
                    if (indent != null) {
                        out.print('\n');
                        out.print(indent2);
                        if (e instanceof NPairElement) {
                            ee = (NPairElement)e;
                            this.writeSafe(out, ee.key(), indent2);
                            out.print(':');
                            out.print(' ');
                            this.writeSafe(out, ee.value(), indent2);
                            continue;
                        }
                        this.writeSafe(out, e, indent2);
                        continue;
                    }
                    if (e instanceof NPairElement) {
                        ee = (NPairElement)e;
                        this.writeSafe(out, ee.key(), null);
                        out.print(':');
                        this.writeSafe(out, ee.value(), null);
                        continue;
                    }
                    this.writeSafe(out, e, null);
                }
                if (indent != null) {
                    out.print('\n');
                    out.print(indent);
                }
                out.print('}');
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported JSON format for " + data.type());
            }
        }
    }

    private NElement _jsonAnnotations(List<NElementAnnotation> a) {
        return NElement.ofArray((NElement[])a.stream().map(x -> this._jsonAnnotation((NElementAnnotation)x)).toArray(NElement[]::new));
    }

    private NElement _jsonAnnotation(NElementAnnotation a) {
        NObjectElementBuilder u = NElement.ofObjectBuilder().add("annotationName", a.name());
        if (a.params() != null) {
            u.add("annotationParams", (NElement)NElement.ofArray((NElement[])a.params().stream().map(x -> this.ensureJson((NElement)x)).toArray(NElement[]::new)));
        }
        return u.build();
    }

    @Override
    public NElement normalize(NElement e) {
        return this.ensureJson(e);
    }

    private NElement ensureJson(NElement e) {
        switch (e.type().typeGroup()) {
            case OPERATOR: {
                NOperatorElement ope = (NOperatorElement)e;
                NObjectElementBuilder value1 = NElement.ofObjectBuilder().copyFrom(e);
                value1.clearChildren();
                value1.set("op", ope.type().opSymbol());
                value1.set("mode", ope.operatorType().id());
                value1.name(null);
                if (ope.first().isPresent()) {
                    value1.set("$first", ope.first().get());
                }
                if (ope.second().isPresent()) {
                    value1.set("$second", ope.second().get());
                }
                return value1.build();
            }
        }
        switch (e.type()) {
            case NULL: 
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BIG_DECIMAL: 
            case BIG_INT: {
                List<NElementAnnotation> a = e.annotations();
                if (a.isEmpty()) {
                    return e;
                }
                return NElement.ofObjectBuilder().add("value", e.builder().clearAnnotations().build()).add(a.isEmpty() ? null : NElement.ofPair("@annotations", this._jsonAnnotations(a))).build();
            }
            case INSTANT: 
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: 
            case TRIPLE_ANTI_QUOTED_STRING: 
            case LINE_STRING: 
            case NAME: 
            case REGEX: 
            case BIG_COMPLEX: 
            case DOUBLE_COMPLEX: 
            case FLOAT_COMPLEX: 
            case CUSTOM: 
            case CHAR_STREAM: 
            case BINARY_STREAM: 
            case LOCAL_TIME: 
            case LOCAL_DATE: 
            case LOCAL_DATETIME: 
            case CHAR: {
                List<NElementAnnotation> a = e.annotations();
                if (a.isEmpty()) {
                    return NElement.ofString(e.asStringValue().get());
                }
                return NElement.ofObjectBuilder().add("value", e.builder().clearAnnotations().build()).add(a.isEmpty() ? null : NElement.ofPair("@annotations", this._jsonAnnotations(a))).build();
            }
            case ALIAS: {
                List<NElementAnnotation> a = e.annotations();
                if (a.isEmpty()) {
                    return NElement.ofString("&" + e.asStringValue().get());
                }
                return NElement.ofObjectBuilder().add("value", "&" + e.builder().clearAnnotations().build().asStringValue().get()).add(a.isEmpty() ? null : NElement.ofPair("@annotations", this._jsonAnnotations(a))).build();
            }
            case PAIR: {
                List<NElementAnnotation> a = e.annotations();
                NPairElement p0 = e.asPair().get();
                NPairElementBuilder p = p0.builder().clearAnnotations().key(this.ensureJson(p0.key())).value(this.ensureJson(p0.value()));
                if (p.key().isPrimitive()) {
                    if (a.isEmpty()) {
                        return p.build();
                    }
                    return NElement.ofObjectBuilder().add("value", (NElement)p.build()).add(a.isEmpty() ? null : NElement.ofPair("@annotations", this._jsonAnnotations(a))).build();
                }
                if (a.isEmpty()) {
                    return NElement.ofObjectBuilder().add("key", p.key()).add("value", p.value()).add(a.isEmpty() ? null : NElement.ofPair("@annotations", this._jsonAnnotations(a))).build();
                }
                return NElement.ofObjectBuilder().add("key", p.key()).add("value", p.value()).add(a.isEmpty() ? null : NElement.ofPair("@annotations", this._jsonAnnotations(a))).build();
            }
            case ARRAY: 
            case NAMED_ARRAY: 
            case NAMED_PARAMETRIZED_ARRAY: 
            case PARAMETRIZED_ARRAY: {
                List<NElementAnnotation> a = e.annotations();
                NArrayElement p0 = e.asArray().get();
                NArrayElementBuilder p = NElement.ofArrayBuilder().addAll((NElement[])p0.children().stream().map(x -> this.ensureJson((NElement)x)).toArray(NElement[]::new));
                if (a.isEmpty() && !p0.isNamed() && !p0.isParametrized()) {
                    return p.build();
                }
                return NElement.ofObjectBuilder().add("value", (NElement)p.build()).add(a.isEmpty() ? null : NElement.ofPair("@annotations", this._jsonAnnotations(a))).add(!p0.isNamed() ? null : NElement.ofPair("@name", (NElement)NElement.ofString(p0.name().orNull()))).add(!p0.isParametrized() ? null : NElement.ofPair("@params", (NElement)NElement.ofArray((NElement[])p0.params().get().stream().map(x -> this.ensureJson((NElement)x)).toArray(NElement[]::new)))).build();
            }
            case OBJECT: 
            case NAMED_OBJECT: 
            case NAMED_PARAMETRIZED_OBJECT: 
            case PARAMETRIZED_OBJECT: {
                List<NElementAnnotation> a = e.annotations();
                NObjectElement p0 = e.asObject().get();
                NObjectElementBuilder p = NElement.ofObjectBuilder().addAll((NElement[])p0.children().stream().map(x -> this.ensureJson((NElement)x)).toArray(NElement[]::new));
                if (a.isEmpty() && !p0.isNamed() && !p0.isParametrized()) {
                    return p.build();
                }
                return NElement.ofObjectBuilder().add("value", (NElement)p.build()).add(a.isEmpty() ? null : NElement.ofPair("@annotations", this._jsonAnnotations(a))).add(!p0.isNamed() ? null : NElement.ofPair("@name", (NElement)NElement.ofString(p0.name().orNull()))).add(!p0.isParametrized() ? null : NElement.ofPair("@params", (NElement)NElement.ofArray((NElement[])p0.params().get().stream().map(x -> this.ensureJson((NElement)x)).toArray(NElement[]::new)))).build();
            }
            case UPLET: 
            case NAMED_UPLET: {
                List<NElementAnnotation> a = e.annotations();
                NUpletElement p0 = e.asUplet().get();
                NArrayElementBuilder p = NElement.ofArrayBuilder().addAll((NElement[])p0.children().stream().map(x -> this.ensureJson((NElement)x)).toArray(NElement[]::new));
                if (a.isEmpty() && !p0.isNamed() && !p0.isParametrized()) {
                    return p.build();
                }
                return NElement.ofObjectBuilder().add("value", (NElement)p.build()).add(a.isEmpty() ? null : NElement.ofPair("@annotations", this._jsonAnnotations(a))).add(!p0.isNamed() ? null : NElement.ofPair("@name", (NElement)NElement.ofString(p0.name().orNull()))).build();
            }
        }
        throw new NUnsupportedOperationException(NMsg.ofC("unsupported ensureJson for %s", e.type()));
    }

    @Override
    public NElement parseElement(Reader reader, NElementFactoryContext context, Object readerSource) {
        return new JsonElementParser(context).parseElement(reader);
    }

    @Override
    public void printElement(NElement value, NPrintStream out, boolean compact, NElementFactoryContext context) {
        this.write(out, value, compact);
    }

    private static class JsonElementParser {
        private BufferedReader reader;
        private NElementFactoryContext context;
        private int fileOffset;
        private int lineNumber;
        private int lineOffset;
        private int current;
        private boolean skipLF;

        public JsonElementParser(NElementFactoryContext context) {
            this.context = context;
        }

        public NElement parseElement(Reader reader) {
            NAssert.requireNonNull(reader, "reader");
            this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            this.fileOffset = 0;
            this.lineNumber = 1;
            this.lineOffset = 0;
            this.current = 0;
            this.readNext();
            this.skipWhiteSpaceAndComments();
            NElement e = this.readValue();
            this.skipWhiteSpaceAndComments();
            if (this.current != -1) {
                throw this.error("unexpected character");
            }
            return e;
        }

        private NElement readValue() {
            switch (this.current) {
                case 110: {
                    String n = this.readStringLiteralUnQuoted();
                    if ("null".equals(n)) {
                        return NElement.ofNull();
                    }
                    return NElement.ofString(n);
                }
                case 116: {
                    String n = this.readStringLiteralUnQuoted();
                    if ("true".equals(n)) {
                        return NElement.ofTrue();
                    }
                    return NElement.ofString(n);
                }
                case 102: {
                    String n = this.readStringLiteralUnQuoted();
                    if ("false".equals(n)) {
                        return NElement.ofFalse();
                    }
                    return NElement.ofString(n);
                }
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.readNumber();
                }
                case 34: 
                case 39: 
                case 96: {
                    return this.readJsonString();
                }
                case 91: {
                    return this.readJsonArray();
                }
                case 123: {
                    return this.readJsonObject();
                }
            }
            if (Character.isAlphabetic(this.current)) {
                return this.readJsonString();
            }
            throw this.expected("value");
        }

        private NElement readJsonArray() {
            NArrayElementBuilder array = NElement.ofArrayBuilder();
            this.readNext();
            this.skipWhiteSpaceAndComments();
            if (this.readChar(']')) {
                return array.build();
            }
            do {
                this.skipWhiteSpaceAndComments();
                if (this.current == 93) break;
                array.add(this.readValue());
                this.skipWhiteSpaceAndComments();
            } while (this.readChar(','));
            this.skipWhiteSpaceAndComments();
            if (!this.readChar(']')) {
                throw this.expected("',' or ']'");
            }
            return array.build();
        }

        private NElement readJsonObject() {
            NObjectElementBuilder object = NElement.ofObjectBuilder();
            this.readNext();
            this.skipWhiteSpaceAndComments();
            if (this.readChar('}')) {
                return object.build();
            }
            do {
                String name;
                this.skipWhiteSpaceAndComments();
                if (this.current == 125) break;
                NElement k = this.readValue();
                switch (k.type()) {
                    case ARRAY: 
                    case OBJECT: {
                        throw this.expected("name");
                    }
                    case NULL: {
                        name = "null";
                        break;
                    }
                    default: {
                        name = k.asStringValue().get();
                    }
                }
                this.skipWhiteSpaceAndComments();
                if (!this.readChar(':')) {
                    throw this.expected("':'");
                }
                this.skipWhiteSpaceAndComments();
                NElement v = this.readValue();
                object.set(name, v);
                this.skipWhiteSpaceAndComments();
            } while (this.readChar(','));
            if (!this.readChar('}')) {
                throw this.expected("',' or '}'");
            }
            return object.build();
        }

        private void readTerminal(String s) {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                if (this.readChar(ch)) continue;
                throw this.expected("'" + ch + "'");
            }
        }

        private NElement readJsonString() {
            return NElement.ofString(this.readStringLiteral());
        }

        private String readStringLiteral() {
            if (this.current == 34) {
                return this.readStringLiteralDblQuoted();
            }
            if (this.current == 39) {
                return this.readStringLiteralSimpleQuoted();
            }
            if (this.current == 96) {
                return this.readStringLiteralAntiQuoted();
            }
            return this.readStringLiteralUnQuoted();
        }

        private String readStringLiteralDblQuoted() {
            this.readNext();
            StringBuilder sb = new StringBuilder();
            while (this.current != 34) {
                if (this.current == 92) {
                    this.readNext();
                    switch (this.current) {
                        case 34: 
                        case 39: 
                        case 47: 
                        case 92: {
                            sb.append((char)this.current);
                            break;
                        }
                        case 98: {
                            sb.append('\b');
                            break;
                        }
                        case 102: {
                            sb.append('\f');
                            break;
                        }
                        case 110: {
                            sb.append('\n');
                            break;
                        }
                        case 114: {
                            sb.append('\r');
                            break;
                        }
                        case 116: {
                            sb.append('\t');
                            break;
                        }
                        case 117: {
                            char[] hexChars = new char[4];
                            for (int i = 0; i < 4; ++i) {
                                this.readNext();
                                if (!this.isHexDigit()) {
                                    throw this.expected("hexadecimal digit");
                                }
                                hexChars[i] = (char)this.current;
                            }
                            sb.append((char)Integer.parseInt(new String(hexChars), 16));
                            break;
                        }
                        default: {
                            throw this.expected("valid escape sequence");
                        }
                    }
                    this.readNext();
                    continue;
                }
                if (this.current < 32) {
                    throw this.expected("valid string character");
                }
                sb.append((char)this.current);
                this.readNext();
            }
            this.readNext();
            return sb.toString();
        }

        private String readStringLiteralSimpleQuoted() {
            this.readNext();
            StringBuilder sb = new StringBuilder();
            while (this.current != 39) {
                if (this.current == 92) {
                    this.readNext();
                    switch (this.current) {
                        case 34: 
                        case 39: 
                        case 47: 
                        case 92: {
                            sb.append((char)this.current);
                            break;
                        }
                        case 98: {
                            sb.append('\b');
                            break;
                        }
                        case 102: {
                            sb.append('\f');
                            break;
                        }
                        case 110: {
                            sb.append('\n');
                            break;
                        }
                        case 114: {
                            sb.append('\r');
                            break;
                        }
                        case 116: {
                            sb.append('\t');
                            break;
                        }
                        case 117: {
                            char[] hexChars = new char[4];
                            for (int i = 0; i < 4; ++i) {
                                this.readNext();
                                if (!this.isHexDigit()) {
                                    throw this.expected("hexadecimal digit");
                                }
                                hexChars[i] = (char)this.current;
                            }
                            sb.append((char)Integer.parseInt(new String(hexChars), 16));
                            break;
                        }
                        default: {
                            throw this.expected("valid escape sequence");
                        }
                    }
                    this.readNext();
                    continue;
                }
                if (this.current < 32) {
                    throw this.expected("valid string character");
                }
                sb.append((char)this.current);
                this.readNext();
            }
            this.readNext();
            return sb.toString();
        }

        private String readStringLiteralAntiQuoted() {
            this.readNext();
            StringBuilder sb = new StringBuilder();
            while (this.current != 96) {
                if (this.current == 92) {
                    this.readNext();
                    switch (this.current) {
                        case 34: 
                        case 39: 
                        case 47: 
                        case 92: 
                        case 96: {
                            sb.append((char)this.current);
                            break;
                        }
                        case 98: {
                            sb.append('\b');
                            break;
                        }
                        case 102: {
                            sb.append('\f');
                            break;
                        }
                        case 110: {
                            sb.append('\n');
                            break;
                        }
                        case 114: {
                            sb.append('\r');
                            break;
                        }
                        case 116: {
                            sb.append('\t');
                            break;
                        }
                        case 117: {
                            char[] hexChars = new char[4];
                            for (int i = 0; i < 4; ++i) {
                                this.readNext();
                                if (!this.isHexDigit()) {
                                    throw this.expected("hexadecimal digit");
                                }
                                hexChars[i] = (char)this.current;
                            }
                            sb.append((char)Integer.parseInt(new String(hexChars), 16));
                            break;
                        }
                        default: {
                            throw this.expected("valid escape sequence");
                        }
                    }
                    this.readNext();
                    continue;
                }
                if (this.current < 32) {
                    throw this.expected("valid string character");
                }
                sb.append((char)this.current);
                this.readNext();
            }
            this.readNext();
            return sb.toString();
        }

        private String readStringLiteralUnQuotedPar(char end) {
            this.readNext();
            StringBuilder sb = new StringBuilder();
            while (this.current != -1 && this.current != end) {
                sb.append(this.skipWhiteSpaceAndComments());
                String str = this.readStringLiteralUnQuoted();
                if (str.isEmpty()) break;
                sb.append(str);
            }
            if (this.current != -1) {
                this.readNext();
            }
            return sb.toString();
        }

        private String readStringLiteralUnQuoted() {
            StringBuilder sb = new StringBuilder();
            while (this.current > 32) {
                if (this.current == 92) {
                    this.readNext();
                    switch (this.current) {
                        case 34: 
                        case 39: 
                        case 47: 
                        case 92: {
                            sb.append((char)this.current);
                            break;
                        }
                        case 98: {
                            sb.append('\b');
                            break;
                        }
                        case 102: {
                            sb.append('\f');
                            break;
                        }
                        case 110: {
                            sb.append('\n');
                            break;
                        }
                        case 114: {
                            sb.append('\r');
                            break;
                        }
                        case 116: {
                            sb.append('\t');
                            break;
                        }
                        case 117: {
                            char[] hexChars = new char[4];
                            for (int i = 0; i < 4; ++i) {
                                this.readNext();
                                if (!this.isHexDigit()) {
                                    throw this.expected("hexadecimal digit");
                                }
                                hexChars[i] = (char)this.current;
                            }
                            sb.append((char)Integer.parseInt(new String(hexChars), 16));
                            break;
                        }
                        default: {
                            throw this.expected("valid escape sequence");
                        }
                    }
                    this.readNext();
                    continue;
                }
                if (this.current == 40) {
                    sb.append(this.readStringLiteralUnQuotedPar(')'));
                    continue;
                }
                if (this.current == 123) {
                    sb.append(this.readStringLiteralUnQuotedPar('}'));
                    continue;
                }
                if (this.current == 91) {
                    sb.append(this.readStringLiteralUnQuotedPar(']'));
                    continue;
                }
                if (this.current == 34 || this.current == 39 || this.current == 96) {
                    sb.append(this.readStringLiteral());
                    continue;
                }
                if (this.current == 58 || this.current == 44 || this.current == 41 || this.current == 125 || this.current == 93) break;
                sb.append((char)this.current);
                this.readNext();
            }
            return sb.toString();
        }

        private NElement readNumber() {
            StringBuilder sb = new StringBuilder();
            boolean inWhile = true;
            block4: while (inWhile) {
                switch (this.current) {
                    case -1: {
                        throw this.expected("number");
                    }
                    case 43: 
                    case 45: 
                    case 46: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 69: 
                    case 101: {
                        sb.append((char)this.current);
                        this.readNext();
                        continue block4;
                    }
                }
                inWhile = false;
            }
            return NElement.ofNumber(sb.toString());
        }

        private boolean readChar(char ch) {
            if (this.current != ch) {
                return false;
            }
            this.readNext();
            return true;
        }

        private String skipWhiteSpaceAndComments() {
            StringBuilder sb = new StringBuilder();
            block0: while (true) {
                if (this.current == 32 || this.current == 9 || this.current == 10 || this.current == 13) {
                    sb.append((char)this.current);
                    this.readNext();
                    continue;
                }
                if (this.current != 47) break;
                String s = this.foreSeek(2);
                if ("//".equals(s)) {
                    sb.append((char)this.current);
                    this.readNext();
                    sb.append((char)this.current);
                    this.readNext();
                    while (true) {
                        if (this.current <= 0 || this.current == 13 || this.current == 10) continue block0;
                        sb.append((char)this.current);
                        this.readNext();
                    }
                }
                if (!"/*".equals(s)) break;
                sb.append((char)this.current);
                this.readNext();
                sb.append((char)this.current);
                this.readNext();
                while (true) {
                    if (this.current <= 0) continue block0;
                    if (this.current == 42 && "*/".equals(this.foreSeek(2))) {
                        sb.append((char)this.current);
                        this.readNext();
                        sb.append((char)this.current);
                        this.readNext();
                        continue block0;
                    }
                    sb.append((char)this.current);
                    this.readNext();
                }
                break;
            }
            return sb.toString();
        }

        private String foreSeek(int count) {
            StringBuilder sb = new StringBuilder();
            if (this.current > 0) {
                sb.append((char)this.current);
                --count;
            }
            if (count > 0) {
                try {
                    int r;
                    this.reader.mark(count);
                    for (int i = 0; i < count && (r = this.reader.read()) >= 0; ++i) {
                        sb.append((char)r);
                    }
                    if (sb.length() > 0) {
                        this.reader.reset();
                    }
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
            }
            return sb.toString();
        }

        private void readNext() {
            try {
                this.current = this.reader.read();
                if (this.current != -1) {
                    ++this.lineOffset;
                    ++this.fileOffset;
                    if (this.skipLF) {
                        if (this.current == 10) {
                            this.current = this.reader.read();
                        }
                        this.skipLF = false;
                    }
                    switch (this.current) {
                        case 13: {
                            this.skipLF = true;
                        }
                        case 10: {
                            ++this.lineNumber;
                            this.lineOffset = 0;
                            this.current = 10;
                        }
                    }
                }
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
        }

        ReaderLocation getLocation() {
            return new ReaderLocation(this.fileOffset, this.lineNumber, this.lineOffset);
        }

        private RuntimeException expected(String expected) {
            if (this.current == -1) {
                return this.error("unexpected end of input");
            }
            return this.error("expected " + expected);
        }

        private RuntimeException error(String message) {
            return new NParseException(NMsg.ofC("%s : %s", message, this.getLocation().toString()));
        }

        private boolean isHexDigit() {
            return this.current >= 48 && this.current <= 57 || this.current >= 97 && this.current <= 102 || this.current >= 65 && this.current <= 70;
        }
    }
}

