/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.impl;

import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.spi.NFormatSPI;
import net.thevpc.nuts.text.NFormats;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.time.NChronometer;
import net.thevpc.nuts.time.NDurationFormatMode;

public class NChronometerNFormatSPI
implements NFormatSPI {
    private NDurationFormatMode formatMode;
    private NChronometer value;

    public NChronometerNFormatSPI(NChronometer value) {
        this.value = value;
    }

    @Override
    public String getName() {
        return "chronometer";
    }

    @Override
    public void print(NPrintStream out) {
        if (this.value.getName() != null) {
            out.print(this.value.getName());
            out.print((Object)"=", NTextStyle.separator());
        }
        out.print(NFormats.of(this.value.getDuration()).get().configure(true, "--mode", (this.formatMode == null ? NDurationFormatMode.DEFAULT : this.formatMode).id()).format());
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg a = cmdLine.peek().get();
        switch (a.key()) {
            case "--mode": {
                a = cmdLine.nextEntry().get();
                if (a.isUncommented()) {
                    this.formatMode = NDurationFormatMode.parse(a.getStringValue().get()).get();
                }
                return true;
            }
        }
        return false;
    }
}

