/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format;

import java.util.Iterator;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.elem.NElementFormat;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.format.NFetchDisplayOptions;
import net.thevpc.nuts.text.NIterableFormat;
import net.thevpc.nuts.util.NIteratorBase;

public class NPrintIterator<T>
extends NIteratorBase<T> {
    Iterator<T> curr;
    NWorkspace ws;
    NIterableFormat listFormat;
    NPrintStream out;
    NFetchDisplayOptions displayOptions;
    long count = 0L;

    public NPrintIterator(Iterator<T> curr, NWorkspace ws, NPrintStream out, NFetchDisplayOptions displayOptions) {
        this.curr = curr;
        this.ws = ws;
        this.out = out;
        this.listFormat = NSession.of().getIterableOutput();
        this.displayOptions = displayOptions;
        if (this.listFormat == null) {
            this.listFormat = NElementFormat.of().setContentType(NSession.of().getOutputFormat().orDefault()).iter(out);
        }
        this.listFormat.configure(true, displayOptions.toCmdLineOptions());
    }

    @Override
    public NElement describe() {
        return NElementDescribables.describeResolveOrDestructAsObject(this.curr).builder().set("print", (NElement)NElement.ofObjectBuilder().set("format", this.listFormat.getOutputFormat().id()).build()).build();
    }

    @Override
    public boolean hasNext() {
        boolean p = this.curr.hasNext();
        if (!p) {
            this.listFormat.complete(this.count);
        }
        return p;
    }

    @Override
    public T next() {
        T n = this.curr.next();
        if (this.count == 0L) {
            this.listFormat.start();
        }
        this.listFormat.next(n, this.count);
        ++this.count;
        return n;
    }
}

