/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.artifact.NDependencyTreeNode;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NExecutionEntry;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.command.NFetchStrategy;
import net.thevpc.nuts.command.NInstallInformation;
import net.thevpc.nuts.command.NInstallStatus;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryEvent;
import net.thevpc.nuts.core.NRepositoryListener;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceEvent;
import net.thevpc.nuts.core.NWorkspaceListener;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.format.NDisplayProperty;
import net.thevpc.nuts.runtime.standalone.format.NFetchDisplayOptions;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NInstalledRepository;
import net.thevpc.nuts.runtime.standalone.text.util.NTextUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreEnumUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.NRepositoryConfigManagerExt;
import net.thevpc.nuts.security.NUserConfig;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextPlain;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NUnsupportedEnumException;

public class NIdFormatHelper {
    NId id;
    NInstallStatus installStatus = NInstallStatus.NONE;
    Boolean executable = null;
    Boolean executableApp = null;
    boolean fetched = false;
    boolean checkDependencies = false;
    NDefinition defFetched;
    NDefinition def;
    NDescriptor desc;
    NDependency dep;
    NWorkspace workspace;
    Instant dte;
    String usr;
    char status_f;
    char status_e;
    char status_i;
    char status_s;
    char status_o;
    boolean built = false;
    boolean ntf = true;

    public static NIdFormatHelper of(Object object) {
        if (object instanceof NId) {
            NId v = (NId)object;
            return new NIdFormatHelper(v, NWorkspace.of());
        }
        if (object instanceof NDescriptor) {
            NDescriptor v = (NDescriptor)object;
            return new NIdFormatHelper(v, NWorkspace.of());
        }
        if (object instanceof NDefinition) {
            NDefinition v = (NDefinition)object;
            return new NIdFormatHelper(v, NWorkspace.of());
        }
        if (object instanceof NDependency) {
            NDependency v = (NDependency)object;
            return new NIdFormatHelper(v, NWorkspace.of());
        }
        if (object instanceof NDependencyTreeNode) {
            NDependencyTreeNode v = (NDependencyTreeNode)object;
            return new NIdFormatHelper(v, NWorkspace.of());
        }
        return null;
    }

    public NIdFormatHelper(NDependencyTreeNode id, NWorkspace workspace) {
        this(null, null, null, id.getDependency(), workspace);
    }

    public NIdFormatHelper(NId id, NWorkspace workspace) {
        this(id, null, null, null, workspace);
    }

    public NIdFormatHelper(NDescriptor desc, NWorkspace workspace) {
        this(null, desc, null, null, workspace);
    }

    public NIdFormatHelper(NDefinition def, NWorkspace workspace) {
        this(null, null, def, null, workspace);
    }

    public NIdFormatHelper(NDependency dep, NWorkspace workspace) {
        this(null, null, null, dep, workspace);
    }

    private NIdFormatHelper(NId id, NDescriptor desc, NDefinition def, NDependency dep, NWorkspace workspace) {
        if (id == null) {
            if (def != null) {
                id = def.getId();
            } else if (desc != null) {
                id = desc.getId();
            } else if (dep != null) {
                id = dep.toId();
            }
        }
        if (desc == null && def != null) {
            desc = def.getDescriptor();
        }
        this.workspace = workspace;
        this.id = id;
        this.def = def;
        this.dep = dep;
        this.desc = desc;
    }

    public String[] getMultiColumnRowStrings(NFetchDisplayOptions oo) {
        NText[] oa = this.getMultiColumnRow(oo);
        String[] ss = new String[oa.length];
        for (int i = 0; i < oa.length; ++i) {
            ss[i] = String.valueOf(oa[i]);
        }
        return ss;
    }

    public NText[] getMultiColumnRow(NFetchDisplayOptions oo) {
        NDisplayProperty[] a = oo.getDisplayProperties();
        NText[] b = new NText[a.length];
        for (int j = 0; j < b.length; ++j) {
            b[j] = this.buildMain(oo, a[j]);
        }
        return b;
    }

    private static FormatHelper getFormatHelper(NWorkspace workspace) {
        FormatHelper h = (FormatHelper)NWorkspace.of().getProperties().get(FormatHelper.class.getName());
        if (h != null) {
            return h;
        }
        FormatHelperResetListener h2 = workspace.getProperty(FormatHelperResetListener.class).orNull();
        if (h2 == null) {
            h2 = new FormatHelperResetListener();
            workspace.addWorkspaceListener(h2);
        }
        h = new FormatHelper(workspace);
        NWorkspace.of().setProperty(FormatHelper.class.getName(), h);
        return h;
    }

    public NText getSingleColumnRow(NFetchDisplayOptions oo) {
        NDisplayProperty[] a = oo.getDisplayProperties();
        NTexts txt = NTexts.of();
        NTextBuilder sb = txt.ofBuilder();
        for (int j = 0; j < a.length; ++j) {
            NText s = this.buildMain(oo, a[j]);
            int z = 0;
            switch (a[j]) {
                case INSTALL_DATE: {
                    z = 23;
                    break;
                }
                case REPOSITORY: {
                    z = NIdFormatHelper.getFormatHelper(this.workspace).maxRepoNameSize();
                    break;
                }
                case REPOSITORY_ID: {
                    z = 25;
                    break;
                }
                case INSTALL_USER: {
                    z = NIdFormatHelper.getFormatHelper(this.workspace).maxUserNameSize();
                }
            }
            int len = txt.ofBuilder().append(s).length();
            if (j > 0) {
                sb.append(Character.valueOf(' '));
            }
            sb.append(s);
            if (len >= z) continue;
            char[] c = new char[z - len];
            Arrays.fill(c, ' ');
            sb.append(new String(c));
        }
        return sb.immutable();
    }

    public NText buildMain(NFetchDisplayOptions oo, NDisplayProperty dp) {
        NTexts text = NTexts.of();
        if (oo.isRequireDefinition()) {
            this.buildLong();
        }
        if (dp == null) {
            dp = NDisplayProperty.ID;
        }
        switch (dp) {
            case ID: {
                return oo.getIdFormat().setValue(this.id).setNtf(this.ntf).format();
            }
            case STATUS: {
                return this.getFormattedStatusString();
            }
            case FILE: {
                if (this.def != null && this.def.getContent().isPresent()) {
                    return text.of(this.def.getContent().orNull());
                }
                return text.ofStyled("missing-path", NTextStyle.error());
            }
            case FILE_NAME: {
                if (this.def != null && this.def.getContent().isPresent()) {
                    return text.ofPlain(this.def.getContent().get().getName());
                }
                return text.ofStyled("missing-file-name", NTextStyle.error());
            }
            case ARCH: {
                if (this.desc != null && this.desc.getCondition().getArch().size() > 0) {
                    return this.keywordArr1(this.desc.getCondition().getArch());
                }
                return text.ofStyled("missing-arch", NTextStyle.error());
            }
            case NAME: {
                if (this.desc != null) {
                    return this.stringValue(this.desc.getName());
                }
                return text.ofStyled("missing-name", NTextStyle.error());
            }
            case OS: {
                if (this.desc != null && this.desc.getCondition().getOs().size() > 0) {
                    return this.keywordArr2(this.desc.getCondition().getOs());
                }
                return text.ofStyled("missing-os", NTextStyle.error());
            }
            case OSDIST: {
                if (this.desc != null && this.desc.getCondition().getOsDist().size() > 0) {
                    return this.keywordArr2(this.desc.getCondition().getOsDist());
                }
                return text.ofStyled("missing-osdist", NTextStyle.error());
            }
            case PACKAGING: {
                if (this.desc != null) {
                    return text.ofStyled(this.stringValue(this.desc.getPackaging()), NTextStyle.primary3());
                }
                return text.ofStyled("missing-packaging", NTextStyle.error());
            }
            case PLATFORM: {
                if (this.desc != null && this.desc.getCondition().getPlatform().size() > 0) {
                    return this.keywordArr1(this.desc.getCondition().getPlatform());
                }
                return text.ofStyled("missing-platform", NTextStyle.error());
            }
            case PROFILE: {
                if (this.desc != null && this.desc.getCondition().getProfiles().size() > 0) {
                    return this.keywordArr1(this.desc.getCondition().getProfiles());
                }
                return text.ofStyled("no-profile", NTextStyle.error());
            }
            case DESKTOP_ENVIRONMENT: {
                if (this.desc != null && this.desc.getCondition().getDesktopEnvironment().size() > 0) {
                    return this.keywordArr1(this.desc.getCondition().getDesktopEnvironment());
                }
                return text.ofStyled("missing-desktop-environment", NTextStyle.error());
            }
            case INSTALL_DATE: {
                if (this.def != null && this.def.getInstallInformation().isPresent()) {
                    return this.stringValue(this.def.getInstallInformation().get().getCreatedInstant());
                }
                return text.ofStyled("<null>", NTextStyle.pale());
            }
            case REPOSITORY: {
                String rname = null;
                if (this.def != null) {
                    NRepository r;
                    if (this.def.getRepositoryName() != null) {
                        rname = this.def.getRepositoryName();
                    }
                    if (this.def.getRepositoryUuid() != null && (r = this.workspace.findRepositoryById(this.def.getRepositoryUuid()).orNull()) != null) {
                        rname = r.getName();
                    }
                }
                if (rname == null && this.id != null) {
                    rname = this.id.getRepository();
                }
                return this.stringValue(rname);
            }
            case REPOSITORY_ID: {
                String p;
                NRepository r;
                String ruuid = null;
                if (this.def != null && this.def.getRepositoryUuid() != null) {
                    ruuid = this.def.getRepositoryUuid();
                }
                if (ruuid == null && this.id != null && (r = this.workspace.findRepositoryByName(p = this.id.getRepository()).orNull()) != null) {
                    ruuid = r.getUuid();
                }
                return this.stringValue(ruuid);
            }
            case INSTALL_USER: {
                if (this.def != null && this.def.getInstallInformation().isPresent()) {
                    return this.stringValue(this.def.getInstallInformation().get().getInstallUser());
                }
                return text.ofStyled("nobody", NTextStyle.error());
            }
            case CACHE_FOLDER: {
                if (this.def != null) {
                    return this.stringValue(NPath.ofIdStore(this.def.getId(), NStoreType.CACHE));
                }
                return text.ofStyled("<null>", NTextStyle.error());
            }
            case CONF_FOLDER: {
                if (this.def != null) {
                    return this.stringValue(NPath.ofIdStore(this.def.getId(), NStoreType.CONF));
                }
                return text.ofStyled("<null>", NTextStyle.error());
            }
            case LIB_FOLDER: {
                if (this.def != null) {
                    return this.stringValue(NPath.ofIdStore(this.def.getId(), NStoreType.LIB));
                }
                return text.ofStyled("<null>", NTextStyle.error());
            }
            case LOG_FOLDER: {
                if (this.def != null) {
                    return this.stringValue(NPath.ofIdStore(this.def.getId(), NStoreType.LOG));
                }
                return text.ofStyled("<null>", NTextStyle.error());
            }
            case TEMP_FOLDER: {
                if (this.def != null) {
                    return this.stringValue(NPath.ofIdStore(this.def.getId(), NStoreType.TEMP));
                }
                return text.ofStyled("<null>", NTextStyle.error());
            }
            case VAR_LOCATION: {
                if (this.def != null) {
                    return this.stringValue(NPath.ofIdStore(this.def.getId(), NStoreType.VAR));
                }
                return text.ofStyled("<null>", NTextStyle.error());
            }
            case BIN_FOLDER: {
                if (this.def != null) {
                    return this.stringValue(NPath.ofIdStore(this.def.getId(), NStoreType.BIN));
                }
                return text.ofStyled("<null>", NTextStyle.error());
            }
            case EXEC_ENTRY: {
                if (this.def != null && this.def.getContent().isPresent()) {
                    ArrayList<NTextPlain> results = new ArrayList<NTextPlain>();
                    for (NExecutionEntry entry : NExecutionEntry.parse(this.def.getContent().get())) {
                        if (entry.isDefaultEntry()) {
                            results.add(text.ofPlain(entry.getName()));
                            continue;
                        }
                        results.add(text.ofPlain(entry.getName()));
                    }
                    if (results.size() == 1) {
                        return (NText)results.get(0);
                    }
                    return text.ofBuilder().appendJoined(text.ofPlain(","), results);
                }
                return text.ofStyled("<missing-class>", NTextStyle.error());
            }
            case INSTALL_FOLDER: {
                if (this.def != null && this.def.getInstallInformation().isPresent()) {
                    return this.stringValue(this.def.getInstallInformation().get().getInstallFolder());
                }
                return text.ofStyled("<null>", NTextStyle.pale());
            }
            case LONG_STATUS: {
                ArrayList<NText> all = new ArrayList<NText>();
                if (this.def != null && this.def.getDescriptor().getIdType() != null) {
                    switch (this.def.getDescriptor().getIdType()) {
                        case REGULAR: {
                            all.add(text.ofPlain(this.def.getDescriptor().getIdType().id()));
                            break;
                        }
                        default: {
                            all.add(text.ofStyled(this.def.getDescriptor().getIdType().id(), NTextStyle.primary1()));
                        }
                    }
                }
                if (this.executableApp.booleanValue()) {
                    all.add(text.ofStyled("application", NTextStyle.primary5()));
                } else if (this.executable.booleanValue()) {
                    all.add(text.ofStyled("executable", NTextStyle.primary3()));
                } else {
                    all.add(text.ofStyled("library", NTextStyle.primary4()));
                }
                if (this.dep != null) {
                    NDependencyScope ss = CoreEnumUtils.parseEnumString(this.dep.getScope(), NDependencyScope.class, true);
                    if (this.dep.isOptional()) {
                        all.add(text.ofStyled("optional", NTextStyle.primary5()));
                    }
                    if (ss != null) {
                        all.add(text.ofStyled(NDependencyScope.API.id(), NTextStyle.primary5()));
                    }
                }
                return text.ofBuilder().appendJoined(text.ofStyled(",", NTextStyle.pale()), all).build();
            }
        }
        throw new NUnsupportedEnumException(dp);
    }

    public NIdFormatHelper buildLong() {
        if (!this.built) {
            this.built = true;
            NWorkspace ws = this.workspace;
            NInstalledRepository rr = NWorkspaceExt.of().getInstalledRepository();
            this.installStatus = rr.getInstallStatus(this.id);
            NInstallInformation iif = rr.getInstallInformation(this.id);
            this.dte = iif == null ? null : iif.getCreatedInstant();
            this.usr = iif == null ? null : iif.getInstallUser();
            this.executable = null;
            this.executableApp = null;
            this.fetched = false;
            this.checkDependencies = false;
            this.defFetched = null;
            try {
                if (this.installStatus.isNonDeployed() || this.def == null) {
                    this.defFetched = NFetchCmd.of(this.id).setFetchStrategy(NFetchStrategy.OFFLINE).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDefinition();
                    this.fetched = true;
                } else {
                    this.fetched = true;
                }
            }
            catch (Exception ex) {
                NLog.of(NIdFormatHelper.class).log(NMsg.ofC("failed to build id format for %s", this.id).asFine(ex));
            }
            if (this.def != null) {
                this.executable = this.def.getDescriptor().isExecutable();
                this.executableApp = this.def.getDescriptor().isNutsApplication();
            } else if (this.defFetched != null) {
                this.executable = this.defFetched.getDescriptor().isExecutable();
                this.executableApp = this.defFetched.getDescriptor().isNutsApplication();
            } else if (this.desc != null) {
                this.executable = this.desc.isExecutable();
                this.executableApp = this.desc.isNutsApplication();
            }
            this.status_f = (char)(this.installStatus.isDefaultVersion() ? 73 : (this.installStatus.isInstalled() ? 105 : (this.installStatus.isRequired() ? 100 : (this.fetched ? 102 : 114))));
            if (this.def != null) {
                switch (this.def.getDescriptor().getIdType()) {
                    case API: {
                        this.status_e = (char)97;
                        break;
                    }
                    case RUNTIME: {
                        this.status_e = (char)114;
                        break;
                    }
                    case EXTENSION: {
                        this.status_e = (char)101;
                        break;
                    }
                    case COMPANION: {
                        this.status_e = (char)99;
                        break;
                    }
                    case REGULAR: {
                        this.status_e = (char)45;
                        break;
                    }
                    default: {
                        this.status_e = (char)63;
                    }
                }
            }
            this.status_i = this.buildComponentAppStatus();
            this.status_s = (char)45;
            this.status_o = (char)45;
            if (this.dep != null) {
                NDependencyScope ss = CoreEnumUtils.parseEnumString(this.dep.getScope(), NDependencyScope.class, true);
                if (ss != null) {
                    switch (ss) {
                        case API: {
                            this.status_s = (char)99;
                            break;
                        }
                        case IMPLEMENTATION: {
                            this.status_s = (char)105;
                            break;
                        }
                        case RUNTIME: {
                            this.status_s = (char)114;
                            break;
                        }
                        case SYSTEM: {
                            this.status_s = (char)115;
                            break;
                        }
                        case PROVIDED: {
                            this.status_s = (char)112;
                            break;
                        }
                        case TEST_API: 
                        case TEST_IMPLEMENTATION: 
                        case TEST_PROVIDED: 
                        case TEST_RUNTIME: 
                        case TEST_OTHER: {
                            this.status_s = (char)116;
                            break;
                        }
                        case IMPORT: {
                            this.status_s = (char)109;
                            break;
                        }
                        case OTHER: {
                            this.status_s = (char)79;
                            break;
                        }
                        default: {
                            this.status_s = (char)45;
                        }
                    }
                }
                if (this.dep.isOptional()) {
                    this.status_s = (char)111;
                }
            }
        }
        return this;
    }

    private char buildComponentAppStatus() {
        return (char)(this.executableApp != null ? (this.executableApp.booleanValue() ? 88 : (this.executable.booleanValue() ? 120 : 45)) : 46);
    }

    public NText getFormattedStatusString() {
        NTexts text = NTexts.of();
        if (this.dep != null) {
            return text.ofStyled("" + this.status_f + this.status_e + this.status_i + this.status_s, NTextStyle.primary3());
        }
        return text.ofStyled("" + this.status_f + this.status_e + this.status_i, NTextStyle.primary3());
    }

    public String getStatusString() {
        if (this.dep != null) {
            return "" + this.status_f + this.status_e + this.status_i + this.status_s;
        }
        return "" + this.status_f + this.status_e + this.status_i;
    }

    private NText keywordArr1(List<String> any) {
        return this.keywordArr0(any, NTextStyle.primary1());
    }

    private NText keywordArr2(List<String> any) {
        return this.keywordArr0(any, NTextStyle.primary3());
    }

    private NText keywordArr0(List<String> any, NTextStyle style) {
        NTexts txt = NTexts.of();
        if (any == null || any.size() == 0) {
            return txt.ofBlank();
        }
        if (any.size() == 1) {
            return txt.ofBuilder().append(txt.ofStyled(this.stringValue(any.get(0)), style)).immutable();
        }
        return txt.ofBuilder().append("[").appendJoined(txt.ofPlain(","), any.stream().map(x -> txt.ofStyled(this.stringValue(x), style)).collect(Collectors.toList())).append("]").immutable();
    }

    private NText stringValue(Object any) {
        return NTextUtils.stringValueFormatted(any, false);
    }

    public static class FormatHelper {
        NWorkspace workspace;
        private Integer maxRepoNameSize;
        private Integer maxUserNameSize;

        public FormatHelper(NWorkspace workspace) {
            this.workspace = workspace;
        }

        public int maxRepoNameSize() {
            if (this.maxRepoNameSize != null) {
                return this.maxRepoNameSize;
            }
            int z = 0;
            Stack<NRepository> stack = new Stack<NRepository>();
            for (NRepository repository : this.workspace.getRepositories()) {
                stack.push(repository);
            }
            while (!stack.isEmpty()) {
                NRepository r = (NRepository)stack.pop();
                int n = r.getName().length();
                if (n > z) {
                    z = n;
                }
                if (!r.config().isSupportedMirroring()) continue;
                for (NRepository repository : r.config().getMirrors()) {
                    stack.push(repository);
                }
            }
            this.maxRepoNameSize = z;
            return this.maxRepoNameSize;
        }

        public int maxUserNameSize() {
            if (this.maxUserNameSize != null) {
                return this.maxUserNameSize;
            }
            int z = "anonymous".length();
            NUserConfig[] users = NWorkspaceExt.of(this.workspace).getConfigModel().getStoredConfigSecurity().getUsers();
            if (users != null) {
                for (NUserConfig user : users) {
                    String s = user.getUser();
                    if (s == null) continue;
                    z = Math.max(s.length(), z);
                }
            }
            Stack<NRepository> stack = new Stack<NRepository>();
            for (NRepository repository : this.workspace.getRepositories()) {
                stack.push(repository);
            }
            while (!stack.isEmpty()) {
                NRepository r = (NRepository)stack.pop();
                NRepositoryConfigManagerExt rc = NRepositoryConfigManagerExt.of(r.config());
                NUserConfig[] users1 = rc.getModel().findUsers();
                if (users1 != null) {
                    for (NUserConfig user : users1) {
                        String s = user.getUser();
                        if (s == null) continue;
                        z = Math.max(s.length(), z);
                    }
                }
                if (!r.config().isSupportedMirroring()) continue;
                for (NRepository repository : r.config().getMirrors()) {
                    stack.push(repository);
                }
            }
            this.maxUserNameSize = z;
            return this.maxUserNameSize;
        }
    }

    public static class FormatHelperResetListener
    implements NWorkspaceListener,
    NRepositoryListener {
        private void _onReset() {
            NWorkspace.of().setProperty(FormatHelper.class.getName(), null);
        }

        @Override
        public void onAddRepository(NWorkspaceEvent event) {
            this._onReset();
        }

        @Override
        public void onRemoveRepository(NWorkspaceEvent event) {
            this._onReset();
        }

        @Override
        public void onReloadWorkspace(NWorkspaceEvent event) {
            this._onReset();
        }

        @Override
        public void onCreateWorkspace(NWorkspaceEvent event) {
            this._onReset();
        }

        @Override
        public void onUpdateProperty(NWorkspaceEvent event) {
        }

        @Override
        public void onAddRepository(NRepositoryEvent event) {
            this._onReset();
        }

        @Override
        public void onRemoveRepository(NRepositoryEvent event) {
            this._onReset();
        }

        @Override
        public void onConfigurationChanged(NRepositoryEvent event) {
            this._onReset();
        }

        @Override
        public void onConfigurationChanged(NWorkspaceEvent event) {
            this._onReset();
        }
    }
}

