/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format;

import java.util.Map;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NUnsupportedOperationException;

public class NFormatUtils {
    public static void putAllInProps(String prefix, Map<String, String> dest, NElement value) {
        switch (value.type()) {
            case BOOLEAN: 
            case INSTANT: 
            case INT: 
            case FLOAT: 
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: 
            case TRIPLE_ANTI_QUOTED_STRING: 
            case LINE_STRING: 
            case NULL: 
            case BYTE: 
            case REGEX: 
            case SHORT: 
            case CHAR: 
            case NAME: 
            case DOUBLE: 
            case LONG: 
            case BIG_INT: 
            case BIG_DECIMAL: {
                dest.put(prefix, CoreStringUtils.stringValue(value.asPrimitive().get().asLiteral().asObject().orNull()));
                break;
            }
            case PAIR: {
                NPairElement ee = (NPairElement)value;
                NFormatUtils.putAllInProps(prefix + ee.key(), dest, ee.value());
                break;
            }
            case OBJECT: {
                prefix = !NBlankable.isBlank(prefix) ? prefix + "." : "";
                int i = 0;
                for (NElement e : value.asObject().get().children()) {
                    if (e instanceof NPairElement) {
                        NPairElement ee = (NPairElement)e;
                        NFormatUtils.putAllInProps(prefix + ee.key(), dest, ee.value());
                        continue;
                    }
                    NFormatUtils.putAllInProps(prefix + (i + 1), dest, e);
                    ++i;
                }
                break;
            }
            case ARRAY: {
                prefix = !NBlankable.isBlank(prefix) ? prefix + "." : "";
                int i = 0;
                for (NElement e : value.asArray().get().children()) {
                    NFormatUtils.putAllInProps(prefix + (i + 1), dest, e);
                    ++i;
                }
                break;
            }
            case CUSTOM: {
                throw new NUnsupportedOperationException(NMsg.ofC("unable flatten custom element to properties"));
            }
            default: {
                throw new NUnsupportedOperationException();
            }
        }
    }
}

