/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NIdFormat;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.runtime.standalone.format.NDisplayProperty;
import net.thevpc.nuts.runtime.standalone.util.CoreEnumUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;

public class NFetchDisplayOptions {
    public static NDisplayProperty[] DISPLAY_LONG = new NDisplayProperty[]{NDisplayProperty.STATUS, NDisplayProperty.INSTALL_DATE, NDisplayProperty.INSTALL_USER, NDisplayProperty.REPOSITORY, NDisplayProperty.ID};
    public static NDisplayProperty[] DISPLAY_LONG_LONG = new NDisplayProperty[]{NDisplayProperty.LONG_STATUS, NDisplayProperty.INSTALL_DATE, NDisplayProperty.INSTALL_USER, NDisplayProperty.REPOSITORY, NDisplayProperty.ID};
    public static NDisplayProperty[] DISPLAY_MIN = new NDisplayProperty[]{NDisplayProperty.ID};
    private NIdFormat idFormat;
    private List<NDisplayProperty> displays = new ArrayList<NDisplayProperty>();
    private boolean dependencies;
    private boolean content;

    public NFetchDisplayOptions() {
        this.idFormat = NIdFormat.of();
        this.idFormat.setHighlightImportedGroupId(true);
        this.idFormat.setOmitOtherProperties(true);
        this.idFormat.setOmitFace(true);
        this.idFormat.setOmitRepository(true);
        this.idFormat.setOmitGroupId(false);
        this.idFormat.setOmitImportedGroupId(false);
        this.idFormat.setOmitCondition(true);
        this.idFormat.setOmitExclusion(true);
    }

    public boolean isDependencies() {
        return this.dependencies;
    }

    public NFetchDisplayOptions setDependencies(boolean dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public boolean isContent() {
        return this.content;
    }

    public NFetchDisplayOptions setContent(boolean content) {
        this.content = content;
        return this;
    }

    public void setIdFormat(NIdFormat idFormat) {
        this.idFormat = idFormat;
    }

    public NIdFormat getIdFormat() {
        return this.idFormat;
    }

    public NDisplayProperty[] getDisplayProperties() {
        if (this.displays.isEmpty()) {
            return new NDisplayProperty[]{NDisplayProperty.ID};
        }
        return this.displays.toArray(new NDisplayProperty[0]);
    }

    public void addDisplay(String[] columns) {
        if (columns != null) {
            this.addDisplay(NFetchDisplayOptions.parseNutsDisplayProperty(Arrays.stream(columns).collect(Collectors.joining(","))));
        }
    }

    public void setDisplay(NDisplayProperty display) {
        if (display == null) {
            this.setDisplay(new NDisplayProperty[0]);
        } else {
            this.setDisplay(new NDisplayProperty[]{display});
        }
    }

    public void setDisplay(NDisplayProperty[] display) {
        this.displays.clear();
        this.addDisplay(display);
    }

    public void addDisplay(NDisplayProperty[] display) {
        if (display != null) {
            for (NDisplayProperty t : display) {
                if (t == null) continue;
                this.displays.add(t);
            }
        }
    }

    public void setDisplayLong(boolean longFormat) {
        if (longFormat) {
            this.setDisplay(DISPLAY_LONG);
        } else {
            this.setDisplay(DISPLAY_MIN);
        }
    }

    public boolean isRequireDefinition() {
        for (NDisplayProperty display : this.getDisplayProperties()) {
            if (NDisplayProperty.ID.equals(display)) continue;
            return true;
        }
        return false;
    }

    public final NFetchDisplayOptions configure(boolean skipUnsupported, String ... args) {
        this.configure(false, NCmdLine.of(args));
        return this;
    }

    public final boolean configure(boolean skipUnsupported, NCmdLine cmdLine) {
        boolean conf = false;
        while (cmdLine.hasNext()) {
            if (!this.configureFirst(cmdLine)) {
                if (skipUnsupported) {
                    cmdLine.skip();
                    continue;
                }
                cmdLine.throwUnexpectedArgument();
                continue;
            }
            conf = true;
        }
        return conf;
    }

    public boolean configureFirst(NCmdLine cmdLine) {
        if (this.idFormat.configureFirst(cmdLine)) {
            return true;
        }
        NArg a = cmdLine.peek().get();
        if (a == null) {
            return false;
        }
        switch (a.key()) {
            case "-l": 
            case "--long": {
                a = cmdLine.nextFlag().get();
                if (a.isUncommented()) {
                    if (a.getBooleanValue().get().booleanValue()) {
                        this.setDisplay(DISPLAY_LONG);
                    } else {
                        this.setDisplay(DISPLAY_MIN);
                    }
                }
                return true;
            }
            case "--ll": 
            case "--long-long": {
                a = cmdLine.nextFlag().get();
                if (a.isUncommented()) {
                    if (a.getBooleanValue().get().booleanValue()) {
                        this.setDisplay(DISPLAY_LONG_LONG);
                    } else {
                        this.setDisplay(DISPLAY_MIN);
                    }
                }
                return true;
            }
            case "--display": {
                a = cmdLine.nextEntry().get();
                if (a.isUncommented()) {
                    this.setDisplay(NFetchDisplayOptions.parseNutsDisplayProperty(a.getStringValue().get()));
                }
                return true;
            }
            case "--dependencies": {
                cmdLine.matcher().matchFlag(v -> this.setDependencies(v.booleanValue())).anyMatch();
                return true;
            }
            case "--content": {
                cmdLine.matcher().matchFlag(v -> this.setContent(v.booleanValue())).anyMatch();
                return true;
            }
        }
        return false;
    }

    public String[] toCmdLineOptions() {
        ArrayList<String> displayOptionsArgs = new ArrayList<String>();
        if (this.getIdFormat() != null) {
            if (this.getIdFormat().isHighlightImportedGroupId()) {
                displayOptionsArgs.add("--highlight-imported-group");
            }
            if (this.getIdFormat().isOmitOtherProperties()) {
                displayOptionsArgs.add("--omit-env");
            }
            if (this.getIdFormat().isOmitFace()) {
                displayOptionsArgs.add("--omit-face");
            }
            if (this.getIdFormat().isOmitGroupId()) {
                displayOptionsArgs.add("--omit-group");
            }
            if (this.getIdFormat().isOmitImportedGroupId()) {
                displayOptionsArgs.add("--omit-imported-group");
            }
            if (this.getIdFormat().isOmitRepository()) {
                displayOptionsArgs.add("--omit-repo");
            }
            displayOptionsArgs.add("--display=" + String.join((CharSequence)",", Arrays.asList(this.getDisplayProperties()).stream().map(x -> CoreEnumUtils.getEnumString(x)).collect(Collectors.toList())));
        }
        return displayOptionsArgs.toArray(new String[0]);
    }

    public static NDisplayProperty[] parseNutsDisplayProperty(String str) {
        String[] dispNames = StringTokenizerUtils.splitDefault(str).toArray(new String[0]);
        HashSet<NDisplayProperty> visited = new HashSet<NDisplayProperty>();
        block20: for (int i = 0; i < dispNames.length; ++i) {
            switch (dispNames[i]) {
                case "all": {
                    continue block20;
                }
                case "long": {
                    visited.addAll(Arrays.asList(DISPLAY_LONG));
                    continue block20;
                }
                case "long-long": {
                    visited.addAll(Arrays.asList(DISPLAY_LONG_LONG));
                    continue block20;
                }
                default: {
                    visited.add(CoreEnumUtils.parseEnumString(dispNames[i], NDisplayProperty.class, true));
                }
            }
        }
        ArrayList<NDisplayProperty> all2 = new ArrayList<NDisplayProperty>();
        block21: for (int i = 0; i < dispNames.length; ++i) {
            switch (dispNames[i]) {
                case "all": {
                    for (NDisplayProperty value : NDisplayProperty.values()) {
                        if (visited.contains(value)) continue;
                        all2.add(value);
                    }
                    continue block21;
                }
                case "long": {
                    all2.addAll(Arrays.asList(DISPLAY_LONG));
                    continue block21;
                }
                case "long-long": {
                    all2.addAll(Arrays.asList(DISPLAY_LONG_LONG));
                    continue block21;
                }
                default: {
                    all2.add(CoreEnumUtils.parseEnumString(dispNames[i], NDisplayProperty.class, false));
                }
            }
        }
        return all2.toArray(new NDisplayProperty[0]);
    }

    public String toString() {
        return "NutsFetchDisplayOptions{idFormat=" + this.idFormat + ", displays=" + this.displays + '}';
    }
}

