/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format;

import java.io.File;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.elem.NElementFormat;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminal;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.format.obj.RollingFileService;
import net.thevpc.nuts.runtime.standalone.format.plain.NFormatPlain;
import net.thevpc.nuts.spi.NPathSPI;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NContentTypeFormat;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NObjectFormat;
import net.thevpc.nuts.text.NPropertiesFormat;
import net.thevpc.nuts.text.NTableFormat;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTreeFormat;
import net.thevpc.nuts.util.NFunction;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NMemorySize;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUnsupportedEnumException;

public class DefaultNObjectFormat
extends DefaultFormatBase<NObjectFormat>
implements NObjectFormat {
    private Object value;
    private String formatMode;
    private String formatString;
    private Map<String, Object> formatParams = new HashMap<String, Object>();
    private boolean compact;
    private NContentType outputFormat;

    public DefaultNObjectFormat(NWorkspace workspace) {
        super("object-format");
    }

    @Override
    public String getFormatMode() {
        return this.formatMode;
    }

    @Override
    public NObjectFormat setFormatMode(String formatMode) {
        this.formatMode = formatMode;
        return this;
    }

    @Override
    public String getFormatString() {
        return this.formatString;
    }

    @Override
    public NObjectFormat setFormatString(String formatString) {
        this.formatString = formatString;
        return this;
    }

    @Override
    public Map<String, Object> getFormatParams() {
        return this.formatParams;
    }

    @Override
    public NObjectFormat setFormatParams(Map<String, Object> formatParams) {
        this.formatParams = formatParams;
        return this;
    }

    @Override
    public NObjectFormat setFormatParam(String name, Object value) {
        if (value == null) {
            if (this.formatParams != null) {
                this.formatParams.remove(name);
            }
        } else {
            if (this.formatParams == null) {
                this.formatParams = new LinkedHashMap<String, Object>();
            }
            this.formatParams.put(name, value);
        }
        return this;
    }

    @Override
    public NContentType getOutputFormat() {
        return this.outputFormat;
    }

    @Override
    public NObjectFormat setOutputFormat(NContentType outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public NObjectFormat setValue(Object value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean isCompact() {
        return this.compact;
    }

    @Override
    public DefaultNObjectFormat setCompact(boolean compact) {
        this.compact = compact;
        return this;
    }

    public NContentTypeFormat getBase() {
        NSession session = NSession.of();
        NContentTypeFormat base = this.createObjectFormat();
        base.configure(true, NWorkspace.of().getBootOptions().getOutputFormatOptions().orElseGet(Collections::emptyList).toArray(new String[0]));
        base.configure(true, session.getOutputFormatOptions().toArray(new String[0]));
        return base;
    }

    public NContentTypeFormat createObjectFormat() {
        String type2;
        NSession session = NSession.of();
        Object value = this.getValue();
        String formatMode = this.getFormatMode();
        switch (type2 = formatMode == null ? "" : NNameFormat.CLASS_NAME.format(NStringUtils.trim(formatMode))) {
            case "Byte": 
            case "Bytes": 
            case "Memory": {
                value = NOptional.of(new NMemorySize(((Number)value).longValue(), 0, false));
                break;
            }
            case "RollingPath": {
                if (!(value instanceof NPath)) {
                    if (value instanceof File) {
                        value = NPath.of((File)value);
                    } else if (value instanceof URL) {
                        value = NPath.of((URL)value);
                    } else if (value instanceof String) {
                        value = NPath.of((String)value);
                    } else if (value instanceof NPathSPI) {
                        value = NPath.of((NPathSPI)value);
                    } else {
                        throw new NIllegalArgumentException(NMsg.ofC("invalid RollingPath value %s", value));
                    }
                }
                NLiteral count = NLiteral.of(this.formatParams != null ? this.formatParams.get("count") : null);
                RollingFileService fs = new RollingFileService((NPath)value, count.asInt().isPresent() ? count.asInt().get() : 3);
                value = fs.roll();
                break;
            }
        }
        switch (session.getOutputFormat().orDefault()) {
            case XML: 
            case JSON: 
            case TSON: 
            case YAML: {
                A[] r;
                NContentTypeFormat ee = NElementFormat.of().setNtf(this.isNtf()).setCompact(this.isCompact()).setContentType(session.getOutputFormat().orDefault());
                if (value instanceof NText) {
                    NTextBuilder builder = ((NText)value).builder();
                    r = builder.lines().map(NFunction.of((T x) -> x.filteredText()).redescribe((Supplier)NElementDescribables.ofDesc("filteredText"))).toArray(Object[]::new);
                    ee.setValue(r);
                } else {
                    ee.setValue(value);
                }
                return ee;
            }
            case PROPS: {
                A[] r;
                NContentTypeFormat ee = NPropertiesFormat.of().setNtf(this.isNtf());
                if (value instanceof NText) {
                    NTextBuilder builder = ((NText)value).builder();
                    r = builder.lines().toArray(Object[]::new);
                    ee.setValue(r);
                } else {
                    ee.setValue(value);
                }
                return ee;
            }
            case TREE: {
                A[] r;
                NContentTypeFormat ee = NTreeFormat.of().setNtf(this.isNtf());
                if (value instanceof NText) {
                    NTextBuilder builder = ((NText)value).builder();
                    r = builder.lines().toArray(Object[]::new);
                    ee.setValue(r);
                } else {
                    ee.setValue(value);
                }
                return ee;
            }
            case TABLE: {
                A[] r;
                NContentTypeFormat ee = NTableFormat.of().setNtf(this.isNtf());
                if (value instanceof NText) {
                    NTextBuilder builder = ((NText)value).builder();
                    r = builder.lines().toArray(Object[]::new);
                    ee.setValue(r);
                } else {
                    ee.setValue(value);
                }
                return ee;
            }
            case PLAIN: {
                NContentTypeFormat ee = new NFormatPlain().setCompact(this.isCompact()).setNtf(this.isNtf());
                ((NFormatPlain)ee).setValue(value);
                return ee;
            }
        }
        throw new NUnsupportedEnumException(session.getOutputFormat().orDefault());
    }

    @Override
    public NText format() {
        return this.getBase().format();
    }

    @Override
    public void print() {
        this.getBase().print();
    }

    @Override
    public void println() {
        this.getBase().println();
    }

    @Override
    public void print(NPrintStream out) {
        this.getBase().print(out);
    }

    @Override
    public void print(Writer out) {
        this.getBase().print(out);
    }

    @Override
    public void print(Path out) {
        this.getBase().print(out);
    }

    @Override
    public void print(File out) {
        this.getBase().print(out);
    }

    @Override
    public void print(NTerminal terminal) {
        this.getBase().print(terminal);
    }

    @Override
    public void println(Writer w) {
        this.getBase().println(w);
    }

    @Override
    public void println(NPrintStream out) {
        this.getBase().println(out);
    }

    @Override
    public void println(Path path) {
        this.getBase().println(path);
    }

    @Override
    public void println(NTerminal terminal) {
        this.getBase().println(terminal);
    }

    @Override
    public void println(File file) {
        this.getBase().println(file);
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        return this.getBase().configureFirst(cmdLine);
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

