/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.extension;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NMutableClassLoader;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NChronometer;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class NMutableClassLoaderImpl
extends URLClassLoader
implements NMutableClassLoader {
    private final List<NDefinition> dependencies = new ArrayList<NDefinition>();

    public NMutableClassLoaderImpl(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public <S> List<S> loadServices(Class<S> serviceClass) {
        return NCollections.list(ServiceLoader.load(serviceClass, this));
    }

    @Override
    public ClassLoader asClassLoader() {
        return this;
    }

    @Override
    public List<NDefinition> getLoadedDependencies() {
        return new ArrayList<NDefinition>(this.dependencies);
    }

    @Override
    public boolean loadDependencies(NDependency ... allDefinitions) {
        ArrayList<NDefinition> ok = new ArrayList<NDefinition>();
        for (NDependency dep : allDefinitions) {
            List<NDefinition> d;
            NChronometer ch;
            NDependency id = dep;
            if (!NBlankable.isBlank(id.getGroupId())) {
                ch = NChronometer.startNow();
                NLog.of(NMutableClassLoaderImpl.class).log(NMsg.ofC("searching dependency %s...", id).asConfig().withIntent(NMsgIntent.PROGRESS));
                d = NSearchCmd.of(id.toId()).latest().setInlineDependencies(true).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDefinitions().toList();
                if (d.isEmpty()) {
                    throw new NIllegalArgumentException(NMsg.ofC("unable to load %s", dep));
                }
            } else {
                throw new NIllegalArgumentException(NMsg.ofC("unable to load %s", dep));
            }
            NLog.of(NMutableClassLoaderImpl.class).log(NMsg.ofC("found dependency %s in %s...", id, ch.stop()).asConfig().withIntent(NMsgIntent.PROGRESS));
            ok.addAll(d);
        }
        return this.load(ok.toArray(new NDefinition[0]));
    }

    private boolean load(NDefinition ... allDefinitions) {
        ArrayList<NDefinition> ok = new ArrayList<NDefinition>();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (NDefinition id : allDefinitions) {
            if (NBlankable.isBlank(id)) continue;
            if (this.isLoadedDependency(id.getId())) {
                NLog.of(NMutableClassLoaderImpl.class).log(NMsg.ofC("dependency already loaded %s...", id.getId()).asWarning().withIntent(NMsgIntent.PROGRESS));
                continue;
            }
            URL u = id.getContent().map(x -> x.toURL().orNull()).orNull();
            if (u == null) {
                throw new NIllegalArgumentException(NMsg.ofC("unable to load %s", id.getId()).asError());
            }
            urls.add(u);
            NLog.of(NMutableClassLoaderImpl.class).log(NMsg.ofC("loaded dependency %s...", id.getId()).asConfig().withIntent(NMsgIntent.PROGRESS));
            ok.add(id);
        }
        this.dependencies.addAll(ok);
        for (URL a : urls) {
            super.addURL(a);
        }
        return !ok.isEmpty();
    }

    @Override
    public boolean isLoadedDependency(NId id) {
        if (this.dependencies.stream().anyMatch(x -> x.getId().equalsShortId(id))) {
            return true;
        }
        URL s = this.getResource("META-INF/maven/" + id.getGroupId() + "/" + id.getArtifactId() + "/pom.properties");
        if (s != null) {
            return true;
        }
        s = this.getResource("META-INF/maven/" + id.getGroupId() + "/" + id.getArtifactId() + "/pom.xml");
        if (s != null) {
            return true;
        }
        s = this.getResource("META-INF/nuts/" + id.getGroupId() + "/" + id.getArtifactId() + "/nuts.nuts");
        return s != null;
    }

    public String toString() {
        return "NMutableClassLoader" + this.dependencies.stream().map(x -> x.getId().toString()).collect(Collectors.toList());
    }
}

