/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.extension;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorParser;
import net.thevpc.nuts.artifact.NDescriptorStyle;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.core.NMutableClassLoader;
import net.thevpc.nuts.core.NWorkspaceOptions;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.io.NServiceLoader;
import net.thevpc.nuts.log.NLogs;
import net.thevpc.nuts.runtime.standalone.extension.DefaultNWorkspaceExtensionModel;
import net.thevpc.nuts.runtime.standalone.extension.NMutableClassLoaderImpl;
import net.thevpc.nuts.runtime.standalone.format.NFormatsImpl;
import net.thevpc.nuts.runtime.standalone.log.DefaultNLogs;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTexts;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceModel;
import net.thevpc.nuts.spi.NComponent;
import net.thevpc.nuts.text.NFormats;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NExceptions;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNExtensions
implements NExtensions {
    private NWorkspaceModel wsModel;

    public DefaultNExtensions(NWorkspaceModel wsModel) {
        this.wsModel = wsModel;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    public DefaultNWorkspaceExtensionModel getModel() {
        return this.wsModel.extensionModel;
    }

    @Override
    public Set<NId> getCompanionIds() {
        return Collections.unmodifiableSet(new HashSet<NId>(Arrays.asList(NId.get("net.thevpc.nsh:nsh").get())));
    }

    @Override
    public <T extends NComponent> boolean installWorkspaceExtensionComponent(Class<T> extensionPointType, T extensionImpl) {
        return this.wsModel.extensionModel.installWorkspaceExtensionComponent(extensionPointType, extensionImpl);
    }

    @Override
    public Set<Class<? extends NComponent>> discoverTypes(NId id, ClassLoader classLoader) {
        return this.wsModel.extensionModel.discoverTypes(id, classLoader);
    }

    @Override
    public <T extends NComponent, B> NServiceLoader<T> createServiceLoader(Class<T> serviceType, Class<B> criteriaType) {
        return this.wsModel.extensionModel.createServiceLoader(serviceType, criteriaType);
    }

    @Override
    public <T extends NComponent, B> NServiceLoader<T> createServiceLoader(Class<T> serviceType, Class<B> criteriaType, ClassLoader classLoader) {
        return this.wsModel.extensionModel.createServiceLoader(serviceType, criteriaType, classLoader);
    }

    @Override
    public NMutableClassLoader createMutableClassLoader(ClassLoader parentClassLoader) {
        return new NMutableClassLoaderImpl(parentClassLoader);
    }

    @Override
    public <T extends NComponent> NOptional<T> createComponent(Class<T> type) {
        return this.createComponent(type, null);
    }

    @Override
    public <T extends NComponent, V> NOptional<T> createComponent(Class<T> serviceType, V criteriaType) {
        if (this.wsModel.extensionModel == null) {
            switch (serviceType.getName()) {
                case "net.thevpc.nuts.text.NTexts": {
                    NTexts t = this.wsModel.textModel.defaultNTexts;
                    if (t == null) {
                        this.wsModel.textModel.defaultNTexts = t = new DefaultNTexts();
                    }
                    return NOptional.of(t);
                }
                case "net.thevpc.nuts.text.NFormats": {
                    NFormats t = this.wsModel.textModel.defaultNFormats;
                    if (t == null) {
                        this.wsModel.textModel.defaultNFormats = t = new NFormatsImpl();
                    }
                    return NOptional.of(t);
                }
                case "net.thevpc.nuts.log.NLogs": {
                    NLogs t = this.wsModel.textModel.defaultNLogs;
                    if (t == null) {
                        this.wsModel.textModel.defaultNLogs = t = new DefaultNLogs();
                    }
                    return NOptional.of(t);
                }
            }
            throw NExceptions.ofSafeUnexpectedException(NMsg.ofC("Workspace is still booting and component container is not yet available. but you asked for %s", serviceType.getName()));
        }
        return this.wsModel.extensionModel.createSupported(serviceType, criteriaType);
    }

    @Override
    public <T extends NComponent, V> List<T> createComponents(Class<T> serviceType, V criteriaType) {
        return this.wsModel.extensionModel.createAllSupported(serviceType, criteriaType);
    }

    @Override
    public <T extends NComponent> List<T> createAll(Class<T> serviceType) {
        return this.wsModel.extensionModel.createAll(serviceType);
    }

    @Override
    public <T extends NComponent> Set<Class<? extends T>> getExtensionTypes(Class<T> extensionPoint) {
        return this.wsModel.extensionModel.getExtensionTypes(extensionPoint);
    }

    @Override
    public <T extends NComponent> List<T> getExtensionObjects(Class<T> extensionPoint) {
        return this.wsModel.extensionModel.getExtensionObjects(extensionPoint);
    }

    @Override
    public <T extends NComponent> boolean isRegisteredType(Class<T> extensionPointType, String name) {
        return this.wsModel.extensionModel.isRegisteredType(extensionPointType, name);
    }

    @Override
    public <T extends NComponent> boolean isRegisteredInstance(Class<T> extensionPointType, T extensionImpl) {
        return this.wsModel.extensionModel.isRegisteredInstance(extensionPointType, extensionImpl);
    }

    @Override
    public <T extends NComponent> boolean registerInstance(Class<T> extensionPointType, T extensionImpl) {
        return this.wsModel.extensionModel.registerInstance(extensionPointType, extensionImpl);
    }

    @Override
    public <T extends NComponent> boolean registerType(Class<T> extensionPointType, Class<? extends T> implementation, NId source) {
        return this.wsModel.extensionModel.registerType(extensionPointType, implementation, source);
    }

    @Override
    public <T extends NComponent> boolean isRegisteredType(Class<T> extensionPointType, Class<? extends T> implementation) {
        return this.wsModel.extensionModel.isRegisteredType(extensionPointType, implementation);
    }

    @Override
    public boolean isLoadedExtensions(NId id) {
        return this.wsModel.extensionModel.isLoadedExtensions(id);
    }

    @Override
    public boolean isLoadedId(NId id) {
        return this.isLoadedId(id, null);
    }

    @Override
    public boolean isLoadedId(NId id, ClassLoader classLoader) {
        NDescriptor e;
        NDescriptor e2;
        URL pomXml;
        if (id == null) {
            return false;
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if ((pomXml = classLoader.getResource("META-INF/maven/" + id.getGroupId() + "/" + id.getArtifactId() + "/pom.xml")) != null && (e2 = NDescriptorParser.of().setDescriptorStyle(NDescriptorStyle.MAVEN).parse(pomXml).orNull()) != null && e2.getId() != null) {
            NVersion v2;
            NVersion v = e2.getId().getVersion();
            if (v != null && (v2 = id.getVersion()) != null && !v2.isBlank()) {
                return v2.equals(v);
            }
            return true;
        }
        URL nuts = classLoader.getResource("META-INF/nuts/" + id.getShortId().getMavenFolder() + "/nuts.json");
        if (nuts != null && (e = NDescriptorParser.of().setDescriptorStyle(NDescriptorStyle.NUTS).parse(nuts).orNull()) != null && e.getId() != null) {
            NVersion v2;
            NVersion v = e.getId().getVersion();
            if (v != null && (v2 = id.getVersion()) != null && !v2.isBlank()) {
                return v2.equals(v);
            }
            return true;
        }
        return false;
    }

    @Override
    public List<NId> getLoadedExtensions() {
        return this.wsModel.extensionModel.getLoadedExtensions();
    }

    @Override
    public NExtensions loadExtension(NId extension) {
        this.wsModel.extensionModel.loadExtension(extension);
        return this;
    }

    @Override
    public NExtensions unloadExtension(NId extension) {
        this.wsModel.extensionModel.unloadExtension(extension);
        return this;
    }

    @Override
    public List<NId> getConfigExtensions() {
        return this.wsModel.extensionModel.getConfigExtensions();
    }

    @Override
    public boolean isExcludedExtension(String extensionId, NWorkspaceOptions options) {
        return this.wsModel.configModel.isExcludedExtension(extensionId, options);
    }
}

