/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executor.zip;

import java.util.ArrayList;
import java.util.HashMap;
import net.thevpc.nuts.artifact.NArtifactCall;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NExecutionContext;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.runtime.standalone.executor.exec.NExecHelper;
import net.thevpc.nuts.runtime.standalone.io.util.IProcessExecHelper;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NExecutorComponent;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

@NComponentScope(value=NScopeType.WORKSPACE)
public class ZipExecutorComponent
implements NExecutorComponent {
    public static NId ID;

    public ZipExecutorComponent() {
        ID = NId.get("net.thevpc.nuts.exec:zip").get();
    }

    @Override
    public NId getId() {
        return ID;
    }

    @Override
    public int exec(NExecutionContext executionContext) {
        return this.execHelper(executionContext).exec();
    }

    @Override
    public int getScore(NScorableContext ctx) {
        NDefinition def = ctx.getCriteria(NDefinition.class);
        if (def != null) {
            String shortName = def.getId().getShortName();
            if ("net.thevpc.nuts.exec:exec-zip".equals(shortName)) {
                return 20;
            }
            if ("zip".equals(shortName)) {
                return 20;
            }
            switch (NStringUtils.trim(def.getDescriptor().getPackaging())) {
                case "zip": {
                    return 20;
                }
            }
        }
        return -1;
    }

    public IProcessExecHelper execHelper(NExecutionContext executionContext) {
        NDefinition def = executionContext.getDefinition();
        HashMap<String, String> osEnv = new HashMap<String, String>();
        NArtifactCall executor = def.getDescriptor().getExecutor();
        NAssert.requireNonNull(executor, () -> NMsg.ofC("missing executor %s", def.getId()));
        ArrayList<String> args = new ArrayList<String>(executionContext.getExecutorOptions());
        args.addAll(executionContext.getArguments());
        if (executor.getId() != null && !executor.getId().toString().equals("exec")) {
            throw new NIOException(NMsg.ofC("unsupported executor %s for %s", executor.getId(), def.getId()));
        }
        String directory = null;
        return NExecHelper.ofDefinition(def, args.toArray(new String[0]), osEnv, directory, true, true, executionContext.getSleepMillis(), executionContext.getIn(), executionContext.getOut(), executionContext.getErr(), executionContext.getRunAs());
    }
}

