/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executor.javasrc;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionBuilder;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecutionContext;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.executor.java.JavaExecutorComponent;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NExecutorComponent;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NScorableContext;

@NComponentScope(value=NScopeType.WORKSPACE)
public class JavaSourceExecutorComponent
implements NExecutorComponent {
    public static NId ID;

    @Override
    public NId getId() {
        return ID;
    }

    @Override
    public int exec(NExecutionContext executionContext) {
        if (executionContext.isDry()) {
            NDefinition nutMainFile = executionContext.getDefinition();
            Path javaFile = (Path)nutMainFile.getContent().flatMap(NPath::toPath).orNull();
            String folder = "__temp_folder";
            NPrintStream out = executionContext.getSession().out();
            out.println(NText.ofStyledPrimary4("compile"));
            out.println(NCmdLine.of(new String[]{"embedded-javac", "-d", "<temp-folder>", javaFile.toString()}));
            JavaExecutorComponent cc = new JavaExecutorComponent();
            NDefinitionBuilder d = executionContext.getDefinition().builder();
            d.setContent(NPath.of(folder).setUserCache(false).setUserTemporary(true));
            String fileName = javaFile.getFileName().toString();
            ArrayList<String> z = new ArrayList<String>(executionContext.getExecutorOptions());
            z.addAll(Arrays.asList("--main-class", new File(fileName.substring(fileName.length() - ".java".length())).getName(), "--class-path", folder.toString()));
            NExecutionContext executionContext2 = NWorkspaceExt.of().createExecutionContext().copyFrom(executionContext).setDefinition(d.build()).setExecutorOptions(z).failFast().temporary().build();
            return cc.exec(executionContext2);
        }
        NDefinition nutMainFile = executionContext.getDefinition();
        Path javaFile = (Path)nutMainFile.getContent().flatMap(NPath::toPath).orNull();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        NSession session = executionContext.getSession();
        Path folder = NPath.ofTempFolder("jj").toPath().get();
        int res = compiler.run(null, null, null, "-d", folder.toString(), javaFile.toString());
        if (res != 0) {
            throw new NExecutionException(NMsg.ofPlain("compilation failed"), res);
        }
        JavaExecutorComponent cc = new JavaExecutorComponent();
        NDefinitionBuilder d = executionContext.getDefinition().builder();
        d.setContent(NPath.of(folder).setUserCache(false).setUserTemporary(true));
        String fileName = javaFile.getFileName().toString();
        ArrayList<String> z = new ArrayList<String>(executionContext.getExecutorOptions());
        z.addAll(Arrays.asList("--main-class", new File(fileName.substring(fileName.length() - ".java".length())).getName(), "--class-path", folder.toString()));
        NExecutionContext executionContext2 = NWorkspaceExt.of().createExecutionContext().copyFrom(executionContext).setDefinition(d.build()).setExecutorOptions(z).failFast().temporary().build();
        return cc.exec(executionContext2);
    }

    @Override
    public int getScore(NScorableContext context) {
        NDefinition def;
        if (ID == null) {
            ID = NId.get("net.thevpc.nuts.exec:exec-java-src").get();
        }
        if ((def = context.getCriteria(NDefinition.class)) != null && "java".equals(def.getDescriptor().getPackaging())) {
            return 11;
        }
        return -1;
    }
}

