/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executor.java;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.command.NExecutionContext;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.executor.AbstractSyncIProcessExecHelper;
import net.thevpc.nuts.runtime.standalone.executor.java.JavaExecutorOptions;
import net.thevpc.nuts.runtime.standalone.executor.system.ProcessExecHelper;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.recom.NRecommendationPhase;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.recom.RequestQueryInfo;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NBlankable;

class JavaProcessExecHelper
extends AbstractSyncIProcessExecHelper {
    private final List<NText> xargs;
    private final JavaExecutorOptions joptions;
    private final NExecutionContext executionContext;
    private final NDefinition def;
    private final List<String> args;
    private final HashMap<String, String> osEnv;

    public JavaProcessExecHelper(List<NText> xargs, JavaExecutorOptions joptions, NExecutionContext executionContext, NDefinition def, List<String> args, HashMap<String, String> osEnv) {
        this.xargs = xargs;
        this.joptions = joptions;
        this.executionContext = executionContext;
        this.def = def;
        this.args = args;
        this.osEnv = osEnv;
    }

    @Override
    public int exec() {
        if (this.executionContext.isDry()) {
            NPrintStream out = this.executionContext.getSession().out();
            out.println("[dry] ==[nuts-exec]== ");
            for (int i = 0; i < this.xargs.size(); ++i) {
                NText xarg = this.xargs.get(i);
                out.println("\t\t " + xarg);
            }
            String directory = NBlankable.isBlank(this.joptions.getDir()) ? null : this.joptions.getDir().toAbsolute().toString();
            return ProcessExecHelper.ofDefinition(this.def, this.args.toArray(new String[0]), this.osEnv, directory, this.joptions.isShowCommand(), true, this.executionContext.getSleepMillis(), this.executionContext.getIn(), this.executionContext.getOut(), this.executionContext.getErr(), this.executionContext.getRunAs(), this.executionContext.getExecutorOptions().toArray(new String[0]), this.executionContext.isDry(), this.executionContext.getSession()).exec();
        }
        return this.preExec().exec();
    }

    private ProcessExecHelper preExec() {
        if (this.joptions.isShowCommand() || CoreNUtils.isShowCommand()) {
            NPrintStream out = this.executionContext.getSession().out();
            out.println(NMsg.ofC("%s ", NText.ofStyled("nuts-exec", NTextStyle.primary1())));
            for (int i = 0; i < this.xargs.size(); ++i) {
                NText xarg = this.xargs.get(i);
                out.println(NMsg.ofC("\t\t %s", xarg));
            }
        }
        String directory = NBlankable.isBlank(this.joptions.getDir()) ? null : this.joptions.getDir().toAbsolute().toString();
        NWorkspaceExt.of().getModel().recomm.getRecommendations(new RequestQueryInfo(this.def.getId().toString(), ""), NRecommendationPhase.EXEC, false);
        return ProcessExecHelper.ofDefinition(this.def, this.args.toArray(new String[0]), this.osEnv, directory, this.joptions.isShowCommand(), true, this.executionContext.getSleepMillis(), this.executionContext.getIn(), this.executionContext.getOut(), this.executionContext.getErr(), this.executionContext.getRunAs(), this.executionContext.getExecutorOptions().toArray(new String[0]), this.executionContext.isDry(), this.executionContext.getSession());
    }

    @Override
    public Future<Integer> execAsync() {
        return this.preExec().execAsync();
    }
}

