/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executor.java;

import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDependencyScopePattern;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorEffectiveConfig;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecutionEntry;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NClassLoaderNode;
import net.thevpc.nuts.core.NRepositoryFilters;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceCmdLineParser;
import net.thevpc.nuts.io.NAsk;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.platform.NPlatformLocation;
import net.thevpc.nuts.runtime.standalone.dependency.util.NClassLoaderUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.util.NDefaultClassLoaderNode;
import net.thevpc.nuts.runtime.standalone.util.jclass.JavaJarUtils;
import net.thevpc.nuts.runtime.standalone.util.jclass.NClassLoaderNodeExt;
import net.thevpc.nuts.runtime.standalone.util.jclass.NJavaSdkUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NValidationException;

public final class JavaExecutorOptions {
    private final boolean mainClassApp = false;
    private final List<String> execArgs;
    private final List<String> jvmArgs = new ArrayList<String>();
    private final List<String> extraExecutorOptions = new ArrayList<String>();
    private final List<String> extraNutsOptions = new ArrayList<String>();
    private final List<String> j9_addModules = new ArrayList<String>();
    private final List<String> j9_modulePath = new ArrayList<String>();
    private final List<String> j9_upgradeModulePath = new ArrayList<String>();
    private final List<String> prependArgs = new ArrayList<String>();
    private final List<String> appArgs;
    private final List<String> appendArgs = new ArrayList<String>();
    private final List<NClassLoaderNode> classPathNodes = new ArrayList<NClassLoaderNode>();
    private final List<String> classPath = new ArrayList<String>();
    private String javaVersion = null;
    private String javaEffVersion = null;
    private boolean java9;
    private String javaCommand = null;
    private String mainClass = null;
    private NPath dir = null;
    private boolean javaw = false;
    private boolean excludeBase = false;
    private boolean showCommand = CoreNUtils.isShowCommand();
    private boolean jar = false;
    private String splash;
    private String j9_module;

    public JavaExecutorOptions(NDefinition def, boolean tempId, List<String> args, List<String> executorOptions, NPath dir) {
        NJavaSdkUtils nJavaSdkUtils;
        NPlatformLocation nutsPlatformLocation;
        NVersion nVersion;
        NVersion nVersion2;
        NId id = def.getId();
        NDescriptor descriptor = null;
        if (tempId) {
            descriptor = def.getDescriptor();
            id = descriptor.getId();
        } else {
            descriptor = def.getEffectiveDescriptor().orElseGet(() -> NWorkspace.of().resolveEffectiveDescriptor(def.getDescriptor(), new NDescriptorEffectiveConfig().setIgnoreCurrentEnvironment(false)));
            if (!CoreNUtils.isEffectiveId(id)) {
                id = descriptor.getId();
            }
        }
        Path path = (Path)def.getContent().flatMap(NPath::toPath).orNull();
        this.dir = dir;
        this.execArgs = executorOptions;
        NCmdLine cmdLine = NCmdLine.of(this.getExecArgs()).setExpandSimpleOptions(false);
        ArrayList<NClassLoaderNode> currentCP = new ArrayList<NClassLoaderNode>();
        ArrayList<NArg> extraMayBeJvmOptions = new ArrayList<NArg>();
        block65: while (cmdLine.hasNext()) {
            NArg a = cmdLine.peek().get();
            switch (a.key()) {
                case "--java-version": 
                case "-java-version": {
                    cmdLine.matcher().matchEntry(v -> {
                        this.javaVersion = v.stringValue();
                    }).anyMatch();
                    continue block65;
                }
                case "--java-home": 
                case "-java-home": {
                    cmdLine.matcher().matchEntry(v -> {
                        this.javaCommand = v.stringValue();
                    }).anyMatch();
                    continue block65;
                }
                case "--class-path": 
                case "-class-path": 
                case "--classpath": 
                case "-classpath": 
                case "--cp": 
                case "-cp": {
                    cmdLine.matcher().matchEntry(v -> this.addCp(currentCP, v.stringValue())).anyMatch();
                    continue block65;
                }
                case "--nuts-path": 
                case "-nuts-path": 
                case "--nutspath": 
                case "-nutspath": 
                case "--np": 
                case "-np": {
                    cmdLine.matcher().matchEntry(v -> this.addNp(currentCP, v.stringValue())).anyMatch();
                    continue block65;
                }
                case "--main-class": 
                case "-main-class": 
                case "--class": 
                case "-class": {
                    cmdLine.matcher().matchEntry(v -> {
                        this.mainClass = v.stringValue();
                    }).anyMatch();
                    continue block65;
                }
                case "--dir": 
                case "-dir": {
                    cmdLine.matcher().matchEntry(v -> {
                        this.dir = NPath.of(v.stringValue());
                    }).anyMatch();
                    continue block65;
                }
                case "--win": 
                case "--javaw": {
                    cmdLine.matcher().matchFlag(v -> {
                        this.javaw = v.booleanValue();
                    }).anyMatch();
                    continue block65;
                }
                case "--jar": 
                case "-jar": {
                    cmdLine.matcher().matchFlag(v -> {
                        this.jar = v.booleanValue();
                    }).anyMatch();
                    continue block65;
                }
                case "--show-command": 
                case "-show-command": {
                    cmdLine.matcher().matchFlag(v -> {
                        this.showCommand = v.booleanValue();
                    }).anyMatch();
                    continue block65;
                }
                case "--exclude-base": 
                case "-exclude-base": {
                    cmdLine.matcher().matchFlag(v -> {
                        this.excludeBase = v.booleanValue();
                    }).anyMatch();
                    continue block65;
                }
                case "--add-module": {
                    cmdLine.matcher().matchEntry(v -> this.j9_addModules.add(v.stringValue())).anyMatch();
                    continue block65;
                }
                case "-m": 
                case "--module": {
                    cmdLine.matcher().matchEntry(v -> {
                        this.j9_module = v.stringValue();
                    }).anyMatch();
                    continue block65;
                }
                case "--module-path": {
                    cmdLine.matcher().matchEntry(v -> this.j9_modulePath.add(v.stringValue())).anyMatch();
                    continue block65;
                }
                case "-splash": {
                    cmdLine.matcher().matchEntry(v -> {
                        this.splash = v.stringValue();
                    }).anyMatch();
                    continue block65;
                }
                case "--upgrade-module-path": {
                    cmdLine.matcher().matchEntry(v -> this.j9_upgradeModulePath.add(v.stringValue())).anyMatch();
                    continue block65;
                }
                case "--prepend-arg": {
                    cmdLine.matcher().matchEntry(v -> this.prependArgs.add(v.stringValue())).anyMatch();
                    continue block65;
                }
                case "--append-arg": {
                    cmdLine.matcher().matchEntry(v -> this.appendArgs.add(v.stringValue())).anyMatch();
                    continue block65;
                }
                case "-s": {
                    NArg s = cmdLine.next().get();
                    this.getJvmArgs().add("-Dswing.aatext=true");
                    this.getJvmArgs().add("-Dawt.useSystemAAFontSettings=on");
                    this.getJvmArgs().add("-Dapple.laf.useScreenMenuBar=true");
                    this.getJvmArgs().add("-Dapple.awt.graphics.UseQuartz=true");
                    continue block65;
                }
            }
            if (!a.isOption()) continue;
            List<NArg> nArgs = NWorkspaceCmdLineParser.nextNutsArgument(cmdLine, null).orNull();
            if (nArgs != null) {
                for (NArg nArg : nArgs) {
                    this.extraNutsOptions.add(nArg.toString());
                }
                continue;
            }
            if (a.toString().startsWith("--jvm-")) {
                this.getJvmArgs().add(cmdLine.next().get().toString().substring("--jvm".length()));
                continue;
            }
            if (a.toString().startsWith("--nuts-")) {
                this.extraNutsOptions.add(cmdLine.next().get().toString().substring("--nuts".length()));
                continue;
            }
            extraMayBeJvmOptions.add(cmdLine.next().get());
        }
        this.appArgs = new ArrayList<String>();
        this.appArgs.addAll(this.prependArgs);
        this.appArgs.addAll(args);
        this.appArgs.addAll(this.appendArgs);
        ArrayList<NDefinition> nDefinitions = new ArrayList<NDefinition>();
        NSearchCmd se = NSearchCmd.of();
        NDependencyFilters dependencyFilters = NDependencyFilters.of();
        NDependencyFilter defFilter = dependencyFilters.byScope(NDependencyScopePattern.RUN).and(dependencyFilters.byOptional(false));
        if (tempId) {
            for (NDependency dependency : descriptor.getDependencies()) {
                if (!defFilter.acceptDependency(dependency, null)) continue;
                se.addId(dependency.toId());
            }
        } else {
            se.addId(id);
        }
        if (se.getIds().size() > 0) {
            nDefinitions.addAll(se.setTransitive(true).setDistinct(true).setLatest(true).setInlineDependencies(true).setDependencyFilter(dependencyFilters.byRunnable()).getResultDefinitions().toList());
        }
        if (path != null && !NBlankable.isBlank(nVersion2 = JavaJarUtils.parseJarClassVersion(NPath.of(path))) && (NBlankable.isBlank(this.javaVersion) || nVersion2.compareTo(this.javaVersion) > 0)) {
            this.javaVersion = nVersion2.toString();
        }
        if (!NBlankable.isBlank(nVersion = (NVersion)def.getDescriptor().getCondition().getPlatform().stream().map(x -> NId.get(x).get()).filter(x -> x.getShortName().equals("java")).map(NId::getVersion).min(Comparator.naturalOrder()).orElse(null)) && (NBlankable.isBlank(this.javaVersion) || nVersion.compareTo(this.javaVersion) > 0)) {
            this.javaVersion = nVersion.toString();
        }
        if ((nutsPlatformLocation = (nJavaSdkUtils = NJavaSdkUtils.of(NWorkspace.of())).resolveJdkLocation(this.getJavaVersion())) == null) {
            NLog.of(JavaExecutorOptions.class).warn(NMsg.ofC("No JRE %s is configured in nuts. search of system installations.", this.javaVersion));
            Iterator versionFilterPredicate = nJavaSdkUtils.createVersionFilterPredicate(this.getJavaVersion());
            NPlatformLocation[] existing = (NPlatformLocation[])Stream.of(nJavaSdkUtils.searchJdkLocations()).filter(arg_0 -> JavaExecutorOptions.lambda$new$20((Predicate)((Object)versionFilterPredicate), arg_0)).toArray(NPlatformLocation[]::new);
            if (existing.length > 0) {
                Object[] objectArray = new Object[4];
                objectArray[0] = this.javaVersion;
                objectArray[1] = existing.length;
                objectArray[2] = existing.length == 1 ? "is" : "are";
                Object object = objectArray[3] = existing.length == 1 ? "it" : "them";
                if (NAsk.of().forBoolean(NMsg.ofC("No JRE %s is configured in nuts. However %s %s found. Would you like to auto-configure and use %s?", objectArray)).setDefaultValue(true).getBooleanValue().booleanValue()) {
                    for (NPlatformLocation p : existing) {
                        NWorkspace.of().addPlatform(p);
                    }
                    nutsPlatformLocation = nJavaSdkUtils.resolveJdkLocation(this.getJavaVersion());
                }
            }
            if (nutsPlatformLocation == null && NAsk.of().forBoolean(NMsg.ofC("Still JRE %s is configured in nuts. Would you like to use default one : %s ?", this.javaVersion, System.getProperty("java.version"))).setDefaultValue(true).getBooleanValue().booleanValue()) {
                nutsPlatformLocation = nJavaSdkUtils.resolveJdkLocation(NPath.of(System.getProperty("java.home")), System.getProperty("java.version"));
            }
            if (nutsPlatformLocation == null) {
                throw new NExecutionException(NMsg.ofC("no java version %s was found", NStringUtils.trim(this.getJavaVersion())), 1);
            }
        }
        this.javaEffVersion = nutsPlatformLocation.getVersion();
        this.javaCommand = nJavaSdkUtils.resolveJavaCommandByVersion(nutsPlatformLocation, this.javaw);
        if (this.javaCommand == null) {
            throw new NExecutionException(NMsg.ofC("no java version %s was found", this.getJavaVersion()), 1);
        }
        for (NArg varg : extraMayBeJvmOptions) {
            if (this.isJvmOption(varg, nVersion)) {
                this.getJvmArgs().add(varg.toString());
                continue;
            }
            this.extraExecutorOptions.add(varg.toString());
        }
        this.java9 = NVersion.get(this.javaVersion).get().compareTo("9") >= 0;
        for (NArg extraMayBeJvmOption : extraMayBeJvmOptions) {
            if (extraMayBeJvmOption.toString().startsWith("--jvm-")) {
                this.getJvmArgs().add(extraMayBeJvmOption.toString().substring("--jvm".length()));
                continue;
            }
            if (!this.isJvmOption(extraMayBeJvmOption, NVersion.get(this.javaVersion).get())) continue;
            this.getJvmArgs().add(extraMayBeJvmOption.toString());
        }
        if (this.jar) {
            NSession session = NSession.of();
            if (this.mainClass != null && NOut.isPlain()) {
                session.getTerminal().err().println(NMsg.ofC("ignored main-class=%s. running jar!", this.getMainClass()));
            }
            if (!currentCP.isEmpty() && NOut.isPlain()) {
                session.getTerminal().err().println(NMsg.ofC("ignored class-path=%s. running jar!", currentCP.stream().map(x -> x.getURL().toString()).collect(Collectors.joining(","))));
            }
            if (this.excludeBase) {
                throw new NIllegalArgumentException(NMsg.ofPlain("cannot exclude base with jar modifier"));
            }
        } else {
            List<String> possibleClasses;
            String r;
            List<NExecutionEntry> classes;
            if (this.mainClass == null) {
                if (path != null) {
                    classes = NExecutionEntry.parse(NPath.of(path));
                    NExecutionEntry[] primary = (NExecutionEntry[])classes.stream().filter(NExecutionEntry::isDefaultEntry).toArray(NExecutionEntry[]::new);
                    if (primary.length > 0) {
                        this.mainClass = Arrays.stream(primary).map(NExecutionEntry::getName).collect(Collectors.joining(":"));
                    } else if (classes.size() > 0) {
                        this.mainClass = classes.stream().map(NExecutionEntry::getName).collect(Collectors.joining(":"));
                    }
                }
            } else if (!this.mainClass.contains(".") && (r = this.resolveMainClass(this.mainClass, possibleClasses = (classes = NExecutionEntry.parse(NPath.of(path))).stream().map(NExecutionEntry::getName).collect(Collectors.toList()))) != null) {
                this.mainClass = r;
            }
            NId finalId = id;
            NAssert.requireNonNull(this.mainClass, () -> NMsg.ofC("missing Main Class for %s", finalId));
            boolean baseDetected = false;
            NRepositoryFilters nRepositoryFilters = NRepositoryFilters.of();
            for (NDefinition nDefinition : nDefinitions) {
                NClassLoaderNode nn = null;
                if (nDefinition.getContent().isPresent()) {
                    if (id.getLongName().equals(nDefinition.getId().getLongName())) {
                        baseDetected = true;
                        if (!this.isExcludeBase()) {
                            nn = NClassLoaderUtils.definitionToClassLoaderNodeSafer(nDefinition, nRepositoryFilters.installedRepo());
                        }
                    } else {
                        nn = NClassLoaderUtils.definitionToClassLoaderNodeSafer(nDefinition, nRepositoryFilters.installedRepo());
                    }
                }
                if (nn == null) continue;
                currentCP.add(nn);
            }
            if (!this.isExcludeBase() && !baseDetected) {
                NAssert.requireNonNull(path, () -> NMsg.ofC("missing path %s", finalId));
                currentCP.add(0, NClassLoaderUtils.definitionToClassLoaderNodeSafer(def, nRepositoryFilters.installedRepo()));
            }
            this.classPathNodes.addAll(currentCP);
            List<NClassLoaderNodeExt> ln = NJavaSdkUtils.loadNutsClassLoaderNodeExts(currentCP.toArray(new NClassLoaderNode[0]), this.java9);
            if (this.java9) {
                ArrayList<NClassLoaderNodeExt> ln_javaFx = new ArrayList<NClassLoaderNodeExt>();
                ArrayList<NClassLoaderNodeExt> ln_others = new ArrayList<NClassLoaderNodeExt>();
                for (NClassLoaderNodeExt n : ln) {
                    if (n.jfx) {
                        ln_javaFx.add(n);
                        continue;
                    }
                    ln_others.add(n);
                }
                ln_javaFx.sort((a1, a2) -> {
                    NId b1 = a1.id;
                    NId b2 = a2.id;
                    String c1 = b1.getClassifier();
                    String c2 = b2.getClassifier();
                    if (b1.builder().setClassifier(null).build().getShortName().equals(b2.builder().setClassifier(null).build().getShortName())) {
                        if (NBlankable.isBlank(c1)) {
                            return 1;
                        }
                        if (NBlankable.isBlank(c2)) {
                            return -1;
                        }
                        return b1.compareTo(b2);
                    }
                    return b1.compareTo(b2);
                });
                ln.clear();
                ln.addAll(ln_javaFx);
                ln.addAll(ln_others);
            }
            for (NClassLoaderNodeExt s : ln) {
                if (this.java9 && s.moduleName != null && s.jfx) {
                    if (!s.moduleName.endsWith("Empty")) {
                        this.j9_addModules.add(s.moduleName);
                    }
                    this.j9_modulePath.add(s.path.toPath().get().toString());
                    for (String requiredJfx : s.requiredJfx) {
                        if (requiredJfx.endsWith("Empty")) continue;
                        this.j9_addModules.add(requiredJfx);
                    }
                    continue;
                }
                this.classPath.add(s.path.toPath().get().toString());
            }
            if (this.mainClass.contains(":")) {
                List<String> possibleClasses2 = StringTokenizerUtils.split(this.getMainClass(), ":");
                switch (possibleClasses2.size()) {
                    case 0: {
                        throw new NIllegalArgumentException(NMsg.ofC("missing Main-Class in Manifest for %s", id));
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        if (!NOut.isPlain() || NSession.of().isBot()) {
                            throw new NExecutionException(NMsg.ofC("multiple runnable classes detected : %s", possibleClasses2), 1);
                        }
                        NTexts text = NTexts.of();
                        NTextBuilder msgString = text.ofBuilder();
                        msgString.append("multiple runnable classes detected  - actually ").append(text.ofStyled("" + possibleClasses2.size(), NTextStyle.primary5())).append(" . Select one :\n");
                        int x2 = (int)Math.log(possibleClasses2.size()) + 2;
                        for (int i = 0; i < possibleClasses2.size(); ++i) {
                            StringBuilder clsIndex = new StringBuilder();
                            clsIndex.append(i + 1);
                            while (clsIndex.length() < x2) {
                                clsIndex.append(' ');
                            }
                            msgString.append((Object)clsIndex.toString(), NTextStyle.primary4());
                            msgString.append((Object)possibleClasses2.get(i), NTextStyle.primary4());
                            msgString.append("\n");
                        }
                        msgString.append("enter class ").append((Object)"#", NTextStyle.primary5()).append(" or ").append((Object)"name", NTextStyle.primary5()).append(" to run it. type ").append((Object)"cancel!", NTextStyle.error()).append(" to cancel : ");
                        this.mainClass = NAsk.of().forString(NMsg.ofNtf(msgString)).setValidator((value, question) -> {
                            Integer anyInt = NLiteral.of(value).asInt().orNull();
                            if (anyInt != null) {
                                int i = anyInt;
                                if (i >= 1 && i <= possibleClasses2.size()) {
                                    return (String)possibleClasses2.get(i - 1);
                                }
                            } else {
                                for (String possibleClass : possibleClasses2) {
                                    if (!possibleClass.equals(value)) continue;
                                    return possibleClass;
                                }
                            }
                            throw new NValidationException();
                        }).getValue();
                        break;
                    }
                }
            }
        }
    }

    private boolean isJvmOption(NArg extraMayBeJvmOption, NVersion nVersion) {
        String s = extraMayBeJvmOption.toString();
        if (s.startsWith("-d32")) {
            return true;
        }
        if (s.startsWith("-d64")) {
            return true;
        }
        if (s.startsWith("-server")) {
            return true;
        }
        if (s.startsWith("-cp")) {
            return true;
        }
        if (s.startsWith("-classpath")) {
            return true;
        }
        if (s.startsWith("-D")) {
            return true;
        }
        if (s.startsWith("-verbose:")) {
            return true;
        }
        if (s.startsWith("-ea:")) {
            return true;
        }
        if (s.startsWith("-enableassertions:")) {
            return true;
        }
        if (s.startsWith("-da:")) {
            return true;
        }
        if (s.startsWith("-disableassertions:")) {
            return true;
        }
        if (s.startsWith("-esa")) {
            return true;
        }
        if (s.startsWith("-dsa")) {
            return true;
        }
        if (s.startsWith("-enablesystemassertions")) {
            return true;
        }
        if (s.startsWith("-disablesystemassertions")) {
            return true;
        }
        if (s.startsWith("-splash:")) {
            return true;
        }
        if (s.startsWith("-agentlib:")) {
            return true;
        }
        return s.startsWith("-javaagent:");
    }

    private String resolveMainClass(String name, List<String> possibleClasses) {
        if (name != null) {
            Integer v = NLiteral.of(name).asInt().orNull();
            if (v != null) {
                int i;
                if (v >= 1 && v <= possibleClasses.size()) {
                    return possibleClasses.get(v - 1);
                }
                if (v < 0 && (i = possibleClasses.size() + v) >= 0 && i < possibleClasses.size()) {
                    return possibleClasses.get(i);
                }
            } else {
                int x;
                if (possibleClasses.contains(name)) {
                    return name;
                }
                ArrayList<String> extraPossibilities = new ArrayList<String>();
                for (String possibleClass : possibleClasses) {
                    x = possibleClass.lastIndexOf(46);
                    if (x <= 0 || !possibleClass.substring(x + 1).equals(name)) continue;
                    extraPossibilities.add(possibleClass);
                }
                if (extraPossibilities.size() == 1) {
                    return (String)extraPossibilities.get(0);
                }
                if (extraPossibilities.size() > 1) {
                    throw new NIllegalArgumentException(NMsg.ofC("ambiguous main-class %s matches all of %s", name, ((Object)extraPossibilities).toString()));
                }
                for (String possibleClass : possibleClasses) {
                    x = possibleClass.lastIndexOf(46);
                    if (x <= 0 || !possibleClass.substring(x + 1).equalsIgnoreCase(name)) continue;
                    extraPossibilities.add(possibleClass);
                }
                if (extraPossibilities.size() == 1) {
                    return (String)extraPossibilities.get(0);
                }
                if (extraPossibilities.size() > 1) {
                    throw new NIllegalArgumentException(NMsg.ofC("ambiguous main-class %s matches all of from %s", name, ((Object)extraPossibilities).toString()));
                }
            }
        }
        return null;
    }

    private void addCp(List<NClassLoaderNode> classPath, String value) {
        if (value == null) {
            value = "";
        }
        boolean files = value.matches("([^:]+\\.jar[:;]?.*)");
        boolean nutsIds = value.matches("(.*[:#?].*)");
        if (nutsIds && !files) {
            this.addNp(classPath, value);
        } else {
            for (String n : StringTokenizerUtils.splitColon(value)) {
                if (NBlankable.isBlank(n)) continue;
                URL url = NPath.of(n).toURL().get();
                classPath.add(new NDefaultClassLoaderNode(null, url, true, true, new NClassLoaderNode[0]));
            }
        }
    }

    private void addNp(List<NClassLoaderNode> classPath, String value) {
        NSearchCmd ns = NSearchCmd.of().setLatest(true);
        NRepositoryFilters nRepositoryFilters = NRepositoryFilters.of();
        for (String n : StringTokenizerUtils.splitDefault(value)) {
            if (NBlankable.isBlank(n)) continue;
            ns.addId(n);
        }
        for (NId nutsId : ns.getResultIds()) {
            NDefinition f = NSearchCmd.of().addId(nutsId).setLatest(true).getResultDefinitions().findFirst().get();
            classPath.add(NClassLoaderUtils.definitionToClassLoaderNodeSafer(f, nRepositoryFilters.installedRepo()));
        }
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getJavaCommand() {
        return this.javaCommand;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public NPath getDir() {
        return this.dir;
    }

    public boolean isMainClassApp() {
        return false;
    }

    public boolean isExcludeBase() {
        return this.excludeBase;
    }

    public boolean isShowCommand() {
        return this.showCommand;
    }

    public boolean isJar() {
        return this.jar;
    }

    public List<String> getExecArgs() {
        return this.execArgs;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public List<String> getAppArgs() {
        return this.appArgs;
    }

    public void fillNidStrings(NClassLoaderNode n, List<String> list) {
        if (NBlankable.isBlank(n.getId())) {
            URL f = n.getURL();
            list.add(NPath.of(f).toPath().get().toString());
        } else {
            list.add(n.getId().toString());
        }
        for (NClassLoaderNode d : n.getDependencies()) {
            this.fillNidStrings(d, list);
        }
    }

    public List<String> getClassPathNidStrings() {
        ArrayList<String> li = new ArrayList<String>();
        for (NClassLoaderNode n : this.getClassPathNodes()) {
            this.fillNidStrings(n, li);
        }
        return li;
    }

    public List<NClassLoaderNode> getClassPathNodes() {
        return this.classPathNodes;
    }

    public String getJavaEffVersion() {
        return this.javaEffVersion;
    }

    public boolean isJava9() {
        return this.java9;
    }

    public boolean isJavaw() {
        return this.javaw;
    }

    public String getSplash() {
        return this.splash;
    }

    public List<String> getJ9_addModules() {
        return this.j9_addModules;
    }

    public List<String> getJ9_modulePath() {
        return this.j9_modulePath;
    }

    public String getJ9_module() {
        return this.j9_module;
    }

    public List<String> getJ9_upgradeModulePath() {
        return this.j9_upgradeModulePath;
    }

    public List<String> getClassPath() {
        return this.classPath;
    }

    public List<String> getExtraNutsOptions() {
        return this.extraNutsOptions;
    }

    public List<String> getExtraExecutorOptions() {
        return this.extraExecutorOptions;
    }

    private static /* synthetic */ boolean lambda$new$20(Predicate versionFilterPredicate, NPlatformLocation aa) {
        return versionFilterPredicate.test(aa.getVersion());
    }
}

