/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.cmdline.NCmdLineConfigurable;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementMapperStore;
import net.thevpc.nuts.elem.NElementWriter;
import net.thevpc.nuts.elem.NElements;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NMemoryPrintStream;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminal;
import net.thevpc.nuts.reflect.NReflectRepository;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNElementFactoryContext;
import net.thevpc.nuts.runtime.standalone.elem.NElementFactoryService;
import net.thevpc.nuts.runtime.standalone.elem.NElementStreamFormat;
import net.thevpc.nuts.runtime.standalone.elem.parser.mapperstore.UserElementMapperStore;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTextManagerModel;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.time.NProgressFactory;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNElementWriter
implements NElementWriter {
    private final DefaultNTextManagerModel model;
    private NContentType contentType = NContentType.JSON;
    private boolean compact;
    private boolean logProgress;
    private boolean traceProgress;
    private NProgressFactory progressFactory;
    private UserElementMapperStore userElementMapperStore;
    private boolean ntf;

    public DefaultNElementWriter() {
        this.model = NWorkspaceExt.of().getModel().textModel;
        this.userElementMapperStore = new UserElementMapperStore();
        this.userElementMapperStore.setReflectRepository(NReflectRepository.of());
    }

    @Override
    public NElementMapperStore mapperStore() {
        return this.userElementMapperStore;
    }

    @Override
    public NElementWriter doWithMapperStore(Consumer<NElementMapperStore> doWith) {
        if (doWith != null) {
            doWith.accept(this.mapperStore());
        }
        return this;
    }

    @Override
    public boolean isNtf() {
        return this.ntf;
    }

    @Override
    public NElementWriter setNtf(boolean nft) {
        this.ntf = nft;
        return this;
    }

    @Override
    public boolean isLogProgress() {
        return this.logProgress;
    }

    @Override
    public NElementWriter setLogProgress(boolean logProgress) {
        this.logProgress = logProgress;
        return this;
    }

    @Override
    public boolean isTraceProgress() {
        return this.traceProgress;
    }

    @Override
    public NElementWriter setTraceProgress(boolean traceProgress) {
        this.traceProgress = traceProgress;
        return this;
    }

    @Override
    public NContentType getContentType() {
        return this.contentType;
    }

    @Override
    public NElementWriter setContentType(NContentType contentType) {
        this.contentType = contentType == null ? NContentType.JSON : contentType;
        return this;
    }

    @Override
    public NElementWriter json() {
        return this.setContentType(NContentType.JSON);
    }

    @Override
    public NElementWriter yaml() {
        return this.setContentType(NContentType.YAML);
    }

    @Override
    public NElementWriter tson() {
        return this.setContentType(NContentType.TSON);
    }

    @Override
    public NElementWriter xml() {
        return this.setContentType(NContentType.XML);
    }

    @Override
    public NElementWriter table() {
        return this.setContentType(NContentType.TABLE);
    }

    @Override
    public NElementWriter tree() {
        return this.setContentType(NContentType.TREE);
    }

    @Override
    public NElementWriter props() {
        return this.setContentType(NContentType.PROPS);
    }

    @Override
    public boolean isCompact() {
        return this.compact;
    }

    @Override
    public NElementWriter setCompact(boolean compact) {
        this.compact = compact;
        return this;
    }

    private NElementStreamFormat resolveStructuredFormat() {
        return this.model.getStreamFormat(this.contentType == null || this.contentType == NContentType.PLAIN ? NContentType.TSON : this.contentType);
    }

    private DefaultNElementFactoryContext createFactoryContext() {
        NReflectRepository reflectRepository = NWorkspaceUtils.of().getReflectRepository();
        DefaultNElementFactoryContext c = new DefaultNElementFactoryContext(this.ntf, reflectRepository, this.userElementMapperStore);
        switch (this.getContentType()) {
            case XML: 
            case JSON: 
            case TSON: 
            case YAML: {
                c.setNtf(false);
            }
        }
        return c;
    }

    private void write(Object value, NPrintStream out, NElementStreamFormat format) {
        NElement elem = NElements.of().doWithMapperStore(d -> d.copyFrom(this.userElementMapperStore)).toElement(value);
        if (out.isNtf()) {
            NMemoryPrintStream bos = NMemoryPrintStream.of();
            format.printElement(elem, bos, this.compact, this.createFactoryContext());
            out.print(NText.ofCode(this.getContentType().id(), bos.toString()));
        } else {
            format.printElement(elem, out, this.compact, this.createFactoryContext());
        }
        out.flush();
    }

    @Override
    public void write(Object value, NPrintStream out) {
        this.write(value, out, this.resolveStructuredFormat());
    }

    public NElementFactoryService getElementFactoryService() {
        return this.model.getElementFactoryService();
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public NProgressFactory getProgressFactory() {
        return this.progressFactory;
    }

    @Override
    public NElementWriter setProgressFactory(NProgressFactory progressFactory) {
        this.progressFactory = progressFactory;
        return this;
    }

    @Override
    public void write(Object any) {
        NSession session = NSession.of();
        this.write(any, session.getTerminal());
    }

    @Override
    public void writeln(Object any) {
        NSession session = NSession.of();
        this.writeln(any, session.getTerminal());
    }

    @Override
    public void write(Object any, Writer out) {
        if (out == null) {
            NPrintStream pout = this.getValidPrintStream();
            this.write(pout);
            pout.flush();
        } else {
            NPrintStream pout = NPrintStream.of(out);
            this.write(any, pout);
            pout.flush();
        }
    }

    @Override
    public void write(Object any, OutputStream out) {
        NPrintStream p = out == null ? this.getValidPrintStream() : NPrintStream.of(out);
        this.write(any, p);
        p.flush();
    }

    @Override
    public void write(Object any, Path path) {
        this.write(any, NPath.of(path));
    }

    @Override
    public void write(Object any, NPath path) {
        path.mkParentDirs();
        try (Writer w = path.getWriter();){
            this.write(any, w);
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    @Override
    public void write(Object any, File file) {
        this.write(NPath.of(file));
    }

    @Override
    public void write(Object any, NTerminal terminal) {
        NSession session = NSession.of();
        this.write(any, terminal == null ? session.getTerminal().out() : terminal.out());
    }

    @Override
    public void writeln(Object any, Writer w) {
        if (w == null) {
            NPrintStream pout = this.getValidPrintStream();
            this.writeln(any, pout);
            pout.flush();
        } else {
            NPrintStream pout = NPrintStream.of(w);
            this.writeln(any, pout);
            pout.flush();
        }
    }

    @Override
    public void writeln(Object any, NPrintStream out) {
        NPrintStream p = this.getValidPrintStream(out);
        this.write(any, out);
        p.println();
        p.flush();
    }

    @Override
    public void writeln(Object any, OutputStream out) {
        if (out == null) {
            NPrintStream pout = this.getValidPrintStream();
            this.writeln(any, pout);
            pout.flush();
        } else {
            NPrintStream pout = NPrintStream.of(out);
            this.writeln(any, pout);
            pout.flush();
        }
    }

    @Override
    public void writeln(Object any, Path path) {
        this.writeln(any, NPath.of(path));
    }

    @Override
    public void writeln(Object any, NPath out) {
        out.mkParentDirs();
        try (Writer w = out.getWriter();){
            this.writeln(any, w);
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    @Override
    public void writeln(Object any, NTerminal terminal) {
        NSession session = NSession.of();
        this.writeln(any, terminal == null ? session.getTerminal().out() : terminal.out());
    }

    @Override
    public void writeln(Object any, File file) {
        this.writeln(any, file.toPath());
    }

    @Override
    public String toString(Object object) {
        StringWriter sw = new StringWriter();
        this.write(object, sw);
        return sw.toString();
    }

    @Override
    public NText toText(Object object) {
        if (this.isNtf()) {
            return NText.of(this.toString(object));
        }
        return NText.ofPlain(this.toString(object));
    }

    public NPrintStream getValidPrintStream(NPrintStream out) {
        if (out == null) {
            out = NOut.out();
        }
        return out;
    }

    public NPrintStream getValidPrintStream() {
        return NOut.out();
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        return false;
    }

    @Override
    public NElementWriter configure(boolean skipUnsupported, String ... args) {
        return (NElementWriter)NCmdLineConfigurable.configure(this, skipUnsupported, args, "writer");
    }
}

