/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.path;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.util.NStreamTokenizer;

public class NElementPathImpl {
    private List<Item> items = new ArrayList<Item>();

    public NElementPathImpl(String pattern) {
        NStreamTokenizer tit = new NStreamTokenizer(pattern);
        tit.wordChar(42);
        while (tit.hasNext()) {
            this._readItem(tit);
            int t = tit.nextToken();
            if (t == 47 || t == -1) continue;
            throw new IllegalArgumentException("expected '/'");
        }
    }

    private ItemDepth consumeDepth(ItemDepth d) {
        while (!this.items.isEmpty() && this.items.get(this.items.size() - 1) instanceof ItemAny) {
            ItemAny u = (ItemAny)this.items.remove(this.items.size() - 1);
            if (u.depth.ordinal() <= d.ordinal()) continue;
            d = u.depth;
        }
        return d;
    }

    private void _readItem(NStreamTokenizer tit) {
        int t = tit.nextToken();
        switch (t) {
            case -1: {
                throw new IllegalArgumentException("Expected token");
            }
            case -3: {
                if (tit.image.equals("**")) {
                    this.items.add(new ItemAny(this.consumeDepth(ItemDepth.ANY)));
                    break;
                }
                if (tit.image.equals("*")) {
                    this.items.add(new ItemAny(this.consumeDepth(ItemDepth.CHILD)));
                    break;
                }
                this.items.add(new ItemName(tit.image, this.consumeDepth(ItemDepth.CURR)));
                break;
            }
            case 34: 
            case 39: {
                this.items.add(new ItemName(tit.sval, this.consumeDepth(ItemDepth.CURR)));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid token");
            }
        }
    }

    private NElement[] searchRecursive(Item i, NElementOrEntry e) {
        LinkedList<NElementOrEntry> queue = new LinkedList<NElementOrEntry>();
        queue.add(e);
        ArrayList<NElement> okkay = new ArrayList<NElement>();
        while (!queue.isEmpty()) {
            NElementOrEntry n = (NElementOrEntry)queue.removeFirst();
            if (i.accept(n)) {
                okkay.add(n.value);
                continue;
            }
            queue.addAll(e.children());
        }
        return okkay.toArray(new NElement[0]);
    }

    public NElement[] resolveReversed(NElement ... e) {
        ArrayList<NElement> all = new ArrayList<NElement>(Arrays.asList(e));
        block3: for (Item item : this.items) {
            switch (item.type().ordinal()) {
                case 0: {
                    continue block3;
                }
            }
            Arrays.stream(e).map(x -> new NElementOrEntry(-1, (NElement)x)).flatMap(x -> {
                if (item.depth == ItemDepth.CHILD) {
                    return x.children().stream().filter(item::accept);
                }
                return Arrays.stream(this.searchRecursive(item, (NElementOrEntry)x));
            }).toArray(NElement[]::new);
        }
        return all.toArray(new NElement[0]);
    }

    public Item[] getItems() {
        return this.items.toArray(new Item[0]);
    }

    public static class ItemAny
    extends Item {
        public ItemAny(ItemDepth depth) {
            super(depth);
        }

        @Override
        public boolean accept(NElementOrEntry n) {
            return true;
        }

        @Override
        public ItemType type() {
            return ItemType.ANY;
        }
    }

    public static enum ItemDepth {
        CURR,
        CHILD,
        ANY;

    }

    public static class ItemName
    extends Item {
        private String name;

        public ItemName(String name, ItemDepth depth) {
            super(depth);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public boolean accept(NElementOrEntry n) {
            return n.key.toString().equals(this.name);
        }

        @Override
        public ItemType type() {
            return ItemType.NAME;
        }
    }

    public static class NElementOrEntry {
        int index;
        NElement key;
        NElement value;

        public NElementOrEntry(int index, NElement value) {
            this.index = index;
            if (value instanceof NPairElement) {
                NPairElement ee = (NPairElement)value;
                this.key = ee.key();
                this.value = ee.value();
            } else {
                this.key = NElement.ofInt(index);
                this.value = value;
            }
        }

        List<NElementOrEntry> children() {
            ArrayList<NElementOrEntry> all = new ArrayList<NElementOrEntry>();
            if (this.value.isArray() || this.value.isObject()) {
                int i = 0;
                for (NElement item : this.value.asListContainer().get().children()) {
                    all.add(new NElementOrEntry(i, item));
                    ++i;
                }
            }
            return all;
        }
    }

    public static abstract class Item {
        ItemDepth depth;

        public Item(ItemDepth depth) {
            this.depth = depth;
        }

        public abstract ItemType type();

        public abstract boolean accept(NElementOrEntry var1);
    }

    public static enum ItemType {
        THIS,
        NAME,
        ANY,
        INDEXED,
        RANGED_INDEX;

    }

    public static class ItemStr
    extends Item {
        private String str;

        public ItemStr(String str, ItemDepth depth) {
            super(depth);
            this.str = str;
        }

        public String getStr() {
            return this.str;
        }

        @Override
        public boolean accept(NElementOrEntry n) {
            return n.key.toString().equals(this.str);
        }

        @Override
        public ItemType type() {
            return ItemType.THIS;
        }
    }
}

