/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.path;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.elem.NArrayElementBuilder;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementPath;
import net.thevpc.nuts.elem.NElementWriter;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NStreamTokenizer;

public class NElementPathFilter {
    private static final NElementNameMatcherFalse NUTS_ELEMENT_NAME_MATCHER_FALSE = new NElementNameMatcherFalse();
    private static final NElementNameMatcherEven NUTS_ELEMENT_NAME_MATCHER_EVEN = new NElementNameMatcherEven();
    private static final NElementNameMatcherOdd NUTS_ELEMENT_NAME_MATCHER_ODD = new NElementNameMatcherOdd();
    private static final NElementNameMatcherValue NUTS_ELEMENT_NAME_MATCHER_VALUE_ZERO = new NElementNameMatcherValue(0);
    private static final NElementNameMatcherValue NUTS_ELEMENT_NAME_MATCHER_VALUE_MINUS_ONE = new NElementNameMatcherValue(-1);
    private static final NElementNameMatcherTrue NUTS_ELEMENT_NAME_MATCHER_TRUE = new NElementNameMatcherTrue();
    private static final NElementIndexMatcherFalse NUTS_ELEMENT_INDEX_MATCHER_FALSE = new NElementIndexMatcherFalse();
    private static final NElementIndexMatcherUnique NUTS_ELEMENT_INDEX_MATCHER_UNIQUE = new NElementIndexMatcherUnique();
    private static final NElementIndexMatcherEven NUTS_ELEMENT_INDEX_MATCHER_EVEN = new NElementIndexMatcherEven();
    private static final NElementIndexMatcherOdd NUTS_ELEMENT_INDEX_MATCHER_ODD = new NElementIndexMatcherOdd();
    private static final NElementIndexMatcherForValue NUTS_ELEMENT_INDEX_MATCHER_FOR_VALUE_0 = new NElementIndexMatcherForValue(0);
    private static final NElementIndexMatcherForValue NUTS_ELEMENT_INDEX_MATCHER_FOR_VALUE_MINUS_ONE = new NElementIndexMatcherForValue(-1);
    private static final NElementIndexMatcherTrue NUTS_ELEMENT_INDEX_MATCHER_TRUE = new NElementIndexMatcherTrue();

    private static void compile_readChar(NStreamTokenizer st, char c) throws IOException {
        int i = st.nextToken();
        if (i != c) {
            throw new IllegalArgumentException("Expected " + c + ". got " + (char)i);
        }
    }

    private static String compile_readArrItem(NStreamTokenizer st) throws IOException {
        NElementPathFilter.compile_readChar(st, '[');
        st.nextToken();
        String value = null;
        switch (st.ttype) {
            case 93: {
                return "";
            }
            case -3: {
                value = st.sval;
                NElementPathFilter.compile_readChar(st, ']');
                return value;
            }
        }
        throw new IllegalArgumentException("Expected string, got " + st);
    }

    public static NElementPath compile(String jpath) {
        NStreamTokenizer st = new NStreamTokenizer(new StringReader(jpath));
        st.resetSyntax();
        st.wordChars(33, 255);
        st.ordinaryChar(46);
        st.ordinaryChar(91);
        st.ordinaryChar(93);
        QueueJsonPath q = new QueueJsonPath();
        try {
            boolean wasNotDotName = false;
            block7: while (st.nextToken() != -1) {
                switch (st.ttype) {
                    case -3: {
                        wasNotDotName = true;
                        q.queue.add(new SubItemJsonPath(st.sval));
                        continue block7;
                    }
                    case 46: {
                        if (!wasNotDotName) {
                            q.queue.add(new SubItemJsonPath("*"));
                        }
                        wasNotDotName = false;
                        continue block7;
                    }
                    case 91: {
                        wasNotDotName = true;
                        st.pushBack();
                        String p = NElementPathFilter.compile_readArrItem(st);
                        if (p.isEmpty()) {
                            q.queue.add(new ArrItemCollectorJsonPath());
                            continue block7;
                        }
                        q.queue.add(new SubItemJsonPath(p));
                        continue block7;
                    }
                }
                throw new IllegalArgumentException("Unexpected " + st);
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
        return q;
    }

    private static class NElementIndexMatcherFalse
    implements NElementIndexMatcher {
        @Override
        public boolean matches(NElement value, int index, int len, Map<String, Object> matchContext) {
            return false;
        }
    }

    private static class NElementIndexMatcherUnique
    implements NElementIndexMatcher {
        @Override
        public boolean matches(NElement value, int index, int len, Map<String, Object> matchContext) {
            String v;
            HashSet<String> u = (HashSet<String>)matchContext.get("unique");
            if (u == null) {
                u = new HashSet<String>();
                matchContext.put("unique", u);
            }
            if (u.contains(v = NElementWriter.ofJson().toString(value))) {
                return false;
            }
            u.add(v);
            return true;
        }
    }

    private static class NElementIndexMatcherEven
    implements NElementIndexMatcher {
        @Override
        public boolean matches(NElement value, int index, int len, Map<String, Object> matchContext) {
            return index % 2 == 0;
        }
    }

    private static class NElementIndexMatcherOdd
    implements NElementIndexMatcher {
        @Override
        public boolean matches(NElement value, int index, int len, Map<String, Object> matchContext) {
            return index % 2 == 1;
        }
    }

    private static class NElementIndexMatcherForValue
    implements NElementIndexMatcher {
        private final int a;

        public NElementIndexMatcherForValue(int a) {
            this.a = a;
        }

        @Override
        public boolean matches(NElement value, int index, int len, Map<String, Object> matchContext) {
            if (this.a < 0) {
                return index == len + this.a;
            }
            return index == this.a;
        }
    }

    private static class NElementIndexMatcherTrue
    implements NElementIndexMatcher {
        @Override
        public boolean matches(NElement value, int index, int len, Map<String, Object> matchContext) {
            return true;
        }
    }

    private static class NElementNameMatcherFalse
    implements NElementNameMatcher {
        @Override
        public boolean matches(int index, NElement name, int len, Map<String, Object> matchContext) {
            return false;
        }
    }

    private static class NElementNameMatcherEven
    implements NElementNameMatcher {
        @Override
        public boolean matches(int index, NElement name, int len, Map<String, Object> matchContext) {
            return index % 2 == 0;
        }
    }

    private static class NElementNameMatcherOdd
    implements NElementNameMatcher {
        @Override
        public boolean matches(int index, NElement name, int len, Map<String, Object> matchContext) {
            return index % 2 == 1;
        }
    }

    private static class NElementNameMatcherValue
    implements NElementNameMatcher {
        private final int a;

        public NElementNameMatcherValue(int a) {
            this.a = a;
        }

        @Override
        public boolean matches(int index, NElement name, int len, Map<String, Object> matchContext) {
            if (this.a < 0) {
                return index == len + this.a;
            }
            return index == this.a;
        }
    }

    private static class NElementNameMatcherTrue
    implements NElementNameMatcher {
        @Override
        public boolean matches(int index, NElement s, int len, Map<String, Object> matchContext) {
            return true;
        }
    }

    private static class QueueJsonPath
    implements NElementPath {
        List<NElementPath> queue = new ArrayList<NElementPath>();

        private QueueJsonPath() {
        }

        @Override
        public List<NElement> filter(NElement element) {
            ArrayList<NElement> a = new ArrayList<NElement>();
            a.add(element);
            return this.filter(a);
        }

        @Override
        public List<NElement> filter(List<NElement> elements) {
            for (NElementPath jsonPath : this.queue) {
                elements = jsonPath.filter(elements);
            }
            return elements;
        }

        public String toString() {
            return this.queue.stream().map(Object::toString).collect(Collectors.joining("."));
        }
    }

    private static class SubItemJsonPath
    extends AbstractJsonPath {
        private final String pattern;

        public SubItemJsonPath(String subItem) {
            this.pattern = subItem;
        }

        public String toString() {
            return "match(" + this.pattern + ')';
        }

        @Override
        public List<NElement> filter(NElement element) {
            if (element.isAnyArray()) {
                ArrayList<NElement> arr = new ArrayList<NElement>(element.asArray().get().children());
                ArrayList<NElement> result = new ArrayList<NElement>();
                int len = arr.size();
                NElementIndexMatcher indexMatcher = this.matchesIndex(this.pattern);
                HashMap<String, Object> matchContext = new HashMap<String, Object>();
                for (int i = 0; i < arr.size(); ++i) {
                    NElement value = (NElement)arr.get(i);
                    if (indexMatcher.matches(value, i, len, matchContext)) {
                        result.add(value);
                        continue;
                    }
                    if (!indexMatcher.matches(value, i, len, matchContext)) continue;
                    result.add(value);
                }
                return result;
            }
            if (element.isAnyObject()) {
                ArrayList<NElement> result = new ArrayList<NElement>();
                List<NElement> aa0 = element.asObject().get().children();
                int len = aa0.size();
                int index = 0;
                HashMap<String, Object> matchContext = new HashMap<String, Object>();
                NElementNameMatcher nameMatcher = this.matchesName(this.pattern);
                NElementIndexMatcher indexMatcher = this.matchesIndex(this.pattern);
                for (NElement e : aa0) {
                    if (e instanceof NPairElement) {
                        NPairElement se = (NPairElement)e;
                        if (nameMatcher.matches(index, se.key(), len, matchContext)) {
                            result.add(se.value());
                        } else if (indexMatcher.matches(e, index, len, matchContext)) {
                            result.add(e);
                        }
                    } else if (indexMatcher.matches(e, index, len, matchContext)) {
                        result.add(e);
                    }
                    ++index;
                }
                return result;
            }
            return null;
        }

        private NElementNameMatcher matchesName(String s) {
            switch (s) {
                case "*": 
                case ":*": 
                case ":#*": {
                    return NUTS_ELEMENT_NAME_MATCHER_TRUE;
                }
                case ":last": {
                    return NUTS_ELEMENT_NAME_MATCHER_VALUE_MINUS_ONE;
                }
                case ":first": {
                    return NUTS_ELEMENT_NAME_MATCHER_VALUE_ZERO;
                }
                case ":odd": {
                    return NUTS_ELEMENT_NAME_MATCHER_ODD;
                }
                case ":even": {
                    return NUTS_ELEMENT_NAME_MATCHER_EVEN;
                }
            }
            if (s.startsWith(":#")) {
                s = s.substring(2);
                ArrayList<NElementNameMatcher> ors = new ArrayList<NElementNameMatcher>();
                for (String vir : s.split(",")) {
                    if ((vir = vir.trim()).length() <= 0) continue;
                    if (vir.indexOf(45) > 0) {
                        String[] inter = vir.split("-");
                        if (inter.length != 2 || !NLiteral.of(inter[0]).asInt().isPresent() || !NLiteral.of(inter[1]).asInt().isPresent()) continue;
                        int a = Integer.parseInt(inter[0]);
                        int b = Integer.parseInt(inter[1]);
                        ors.add(new NElementNameMatcherValueInterval(a, b));
                        continue;
                    }
                    if (!NLiteral.of(vir).asInt().isPresent()) continue;
                    int a = NLiteral.of(vir).asInt().get();
                    ors.add(new NElementNameMatcherValue(a));
                }
                if (ors.size() == 1) {
                    return (NElementNameMatcher)ors.get(0);
                }
                if (ors.size() > 1) {
                    return new OrNElementNameMatcher(ors.toArray(new NElementNameMatcher[0]));
                }
                return NUTS_ELEMENT_NAME_MATCHER_FALSE;
            }
            if (s.startsWith(":nocase=")) {
                return new NElementNameMatcherString(s.substring(":nocase=".length()), true);
            }
            return new NElementNameMatcherString(this.pattern, false);
        }

        private NElementIndexMatcher matchesIndex(String s) {
            switch (s) {
                case "*": 
                case ":*": 
                case ":#*": {
                    return NUTS_ELEMENT_INDEX_MATCHER_TRUE;
                }
                case ":last": {
                    return NUTS_ELEMENT_INDEX_MATCHER_FOR_VALUE_MINUS_ONE;
                }
                case ":first": {
                    return NUTS_ELEMENT_INDEX_MATCHER_FOR_VALUE_0;
                }
                case ":odd": {
                    return NUTS_ELEMENT_INDEX_MATCHER_ODD;
                }
                case ":even": {
                    return NUTS_ELEMENT_INDEX_MATCHER_EVEN;
                }
                case ":unique": {
                    return NUTS_ELEMENT_INDEX_MATCHER_UNIQUE;
                }
            }
            if (s.startsWith(":#")) {
                s = s.substring(2);
                return this.createIndexValueInervalMatcher(s);
            }
            if (NLiteral.of(s).asInt().isPresent()) {
                return new NElementIndexMatcherForValue(NLiteral.of(s).asInt().get());
            }
            if (s.matches("[0-9][0-9,-]+")) {
                return this.createIndexValueInervalMatcher(s);
            }
            return NUTS_ELEMENT_INDEX_MATCHER_FALSE;
        }

        private NElementIndexMatcher createIndexValueInervalMatcher(String s) throws NumberFormatException {
            ArrayList<NElementIndexMatcher> ors = new ArrayList<NElementIndexMatcher>();
            for (String vir : s.split(",")) {
                if ((vir = vir.trim()).length() <= 0) continue;
                if (vir.indexOf(45) > 0) {
                    String[] inter = vir.split("-");
                    if (inter.length != 2 || !NLiteral.of(inter[0]).asInt().isPresent() || !NLiteral.of(inter[1]).asInt().isPresent()) continue;
                    int a = Integer.parseInt(inter[0]);
                    int b = Integer.parseInt(inter[1]);
                    ors.add(new NElementIndexMatcherValueInterval(a, b));
                    continue;
                }
                if (!NLiteral.of(vir).asInt().isPresent()) continue;
                ors.add(new NElementIndexMatcherForValue(Integer.parseInt(vir)));
            }
            if (ors.size() == 1) {
                return (NElementIndexMatcher)ors.get(0);
            }
            if (ors.size() > 1) {
                return new OrNElementIndexMatcher(ors.toArray(new NElementIndexMatcher[0]));
            }
            return new NElementIndexMatcherFalse();
        }
    }

    private static class ArrItemCollectorJsonPath
    implements NElementPath {
        @Override
        public List<NElement> filter(NElement element) {
            NArrayElementBuilder aa = NElement.ofArrayBuilder();
            aa.add(element);
            return aa.items();
        }

        @Override
        public List<NElement> filter(List<NElement> elements) {
            NArrayElementBuilder aa = NElement.ofArrayBuilder();
            for (NElement element : elements) {
                aa.add(element);
            }
            return aa.items();
        }
    }

    private static class NElementIndexMatcherValueInterval
    implements NElementIndexMatcher {
        private final int a;
        private final int b;

        public NElementIndexMatcherValueInterval(int a, int b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean matches(NElement value, int index, int len, Map<String, Object> matchContext) {
            return index >= this.a && index <= this.b;
        }
    }

    private static class NElementNameMatcherString
    implements NElementNameMatcher {
        private final String pat;
        private final boolean lower;

        public NElementNameMatcherString(String pat, boolean lower) {
            this.lower = lower;
            this.pat = lower ? pat.toLowerCase() : pat;
        }

        @Override
        public boolean matches(int index, NElement name, int len, Map<String, Object> matchContext) {
            if (name.isAnyString()) {
                String sname = name.asStringValue().get();
                return this.lower ? sname.toLowerCase().matches(this.pat) : sname.matches(this.pat);
            }
            return false;
        }
    }

    private static class NElementNameMatcherValueInterval
    implements NElementNameMatcher {
        private final int a;
        private final int b;

        public NElementNameMatcherValueInterval(int a, int b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean matches(int index, NElement name, int len, Map<String, Object> matchContext) {
            return index >= this.a && index <= this.b;
        }
    }

    public static class OrNElementIndexMatcher
    implements NElementIndexMatcher {
        List<NElementIndexMatcher> all = new ArrayList<NElementIndexMatcher>();

        public OrNElementIndexMatcher(NElementIndexMatcher[] all) {
            this.all.addAll(Arrays.asList(all));
        }

        @Override
        public boolean matches(NElement value, int index, int len, Map<String, Object> matchContext) {
            for (NElementIndexMatcher any : this.all) {
                if (!any.matches(value, index, len, matchContext)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "(" + this.all.stream().map(Object::toString).collect(Collectors.joining(" or ")) + ')';
        }
    }

    public static class OrNElementNameMatcher
    implements NElementNameMatcher {
        List<NElementNameMatcher> all = new ArrayList<NElementNameMatcher>();

        public OrNElementNameMatcher(NElementNameMatcher[] all) {
            this.all.addAll(Arrays.asList(all));
        }

        @Override
        public boolean matches(int index, NElement name, int len, Map<String, Object> matchContext) {
            for (NElementNameMatcher any : this.all) {
                if (!any.matches(index, name, len, matchContext)) continue;
                return true;
            }
            return false;
        }
    }

    private static abstract class AbstractJsonPath
    implements NElementPath {
        @Override
        public abstract List<NElement> filter(NElement var1);

        @Override
        public List<NElement> filter(List<NElement> elements) {
            ArrayList<NElement> a = new ArrayList<NElement>();
            for (NElement element : elements) {
                List<NElement> ff = this.filter(element);
                if (ff == null) continue;
                a.addAll(ff);
            }
            return a;
        }
    }

    public static interface NElementIndexMatcher {
        public boolean matches(NElement var1, int var2, int var3, Map<String, Object> var4);
    }

    public static interface NElementNameMatcher {
        public boolean matches(int var1, NElement var2, int var3, Map<String, Object> var4);
    }
}

