/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.mapper.builder;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.thevpc.nuts.elem.NArrayElementBuilder;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementFactoryContext;
import net.thevpc.nuts.elem.NElementMapper;
import net.thevpc.nuts.elem.NElementMapperBuilderFieldConfigurer;
import net.thevpc.nuts.elem.NElementMapperBuilderInitializer;
import net.thevpc.nuts.elem.NElementMapperBuilderInstanceFactory;
import net.thevpc.nuts.elem.NListContainerElement;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.reflect.NReflectProperty;
import net.thevpc.nuts.reflect.NReflectType;
import net.thevpc.nuts.runtime.standalone.elem.mapper.builder.DefaultNElementMapperBuilder;
import net.thevpc.nuts.runtime.standalone.elem.mapper.builder.NElementMapperBuilderFactoryContextImpl;
import net.thevpc.nuts.runtime.standalone.elem.mapper.builder.NElementMapperBuilderFieldContextImpl;
import net.thevpc.nuts.runtime.standalone.elem.mapper.builder.NElementMapperBuilderFieldImpl;
import net.thevpc.nuts.runtime.standalone.elem.mapper.builder.NElementMapperBuilderInstanceContextImpl;

class NElementMapperFromBuilder<T>
implements NElementMapper<T> {
    private DefaultNElementMapperBuilder<T> builder;
    NElementMapperBuilderInstanceFactory<T> onNewInstance;
    NReflectType type;
    List<NElementMapperBuilderInitializer<T>> postProcess = new ArrayList<NElementMapperBuilderInitializer<T>>();
    Function<String, String> renamer;
    Predicate<String> paramFieldFieldFilter;
    Predicate<String> bodyFieldNameFilter;
    List<NElementMapperBuilderFieldConfigurer<T>> onUnsupportedBody = new ArrayList<NElementMapperBuilderFieldConfigurer<T>>();
    List<NElementMapperBuilderFieldConfigurer<T>> onUnsupportedArg = new ArrayList<NElementMapperBuilderFieldConfigurer<T>>();

    public NElementMapperFromBuilder(DefaultNElementMapperBuilder<T> builder) {
        this.onNewInstance = builder.onNewInstance;
        this.builder = builder;
        this.type = builder.type;
        this.paramFieldFieldFilter = builder.paramFieldFieldFilter;
        this.bodyFieldNameFilter = builder.bodyFieldNameFilter;
        this.postProcess.addAll(builder.postProcess);
        this.onUnsupportedBody.addAll(builder.onUnsupportedBody);
        this.onUnsupportedArg.addAll(builder.onUnsupportedArg);
        this.renamer = builder.renamer;
    }

    @Override
    public Object destruct(T src, Type typeOfSrc, NElementFactoryContext context) {
        return context.defaultDestruct(src, typeOfSrc);
    }

    @Override
    public NElement createElement(T src, Type typeOfSrc, NElementFactoryContext context) {
        return context.defaultCreateElement(src, typeOfSrc);
    }

    @Override
    public T createObject(NElement element, Type to, NElementFactoryContext context) {
        List<NElement> body;
        NListContainerElement container = element.toListContainer().get();
        List<NElement> args = container.isParametrized() ? container.asParametrizedContainer().get().params().orNull() : null;
        Cloneable instance = null;
        if (this.onNewInstance != null) {
            instance = this.onNewInstance.newInstance(new NElementMapperBuilderFactoryContextImpl(element, to, context));
        }
        if (instance == null) {
            Class cType;
            Type rtype = this.type.getJavaType();
            if (rtype instanceof Class && (cType = (Class)rtype).isInterface()) {
                if (cType.getName().equals("java.util.List")) {
                    instance = new ArrayList();
                } else if (cType.getName().equals("java.util.Map")) {
                    instance = new LinkedHashMap();
                }
            }
            if (instance == null) {
                instance = this.type.newInstance();
            }
        }
        NReflectType effectiveType = this.type.getRepository().getType(instance.getClass());
        HashMap<String, NElementMapperBuilderFieldImpl<T>> allFields = new HashMap<String, NElementMapperBuilderFieldImpl<T>>();
        HashMap<String, NElementMapperBuilderFieldImpl<T>> argFields = new HashMap<String, NElementMapperBuilderFieldImpl<T>>();
        HashMap<String, NElementMapperBuilderFieldImpl<T>> bodyFields = new HashMap<String, NElementMapperBuilderFieldImpl<T>>();
        for (NReflectProperty nReflectProperty : effectiveType.getProperties()) {
            boolean arg;
            if (allFields.containsKey(nReflectProperty.getName())) continue;
            NElementMapperBuilderFieldImpl<T> f = new NElementMapperBuilderFieldImpl<T>(nReflectProperty.getName(), this.builder);
            f.uniformName = this.uniformName(f.name);
            f.field = null;
            for (NReflectProperty field : effectiveType.getProperties()) {
                String u = this.uniformName(field.getName());
                if (!u.equals(f.uniformName)) continue;
                f.field = field;
                break;
            }
            f.wrapCollections = this.builder.wrapCollections;
            f.containerIsCollection = this.builder.containerIsCollection;
            f.arg = this.paramFieldFieldFilter == null || this.paramFieldFieldFilter.test(nReflectProperty.getName());
            f.body = this.bodyFieldNameFilter == null || this.bodyFieldNameFilter.test(nReflectProperty.getName());
            boolean body2 = f.body || !f.arg && !f.body;
            boolean bl = arg = f.arg || !f.arg && !f.body;
            if (body2) {
                bodyFields.put(f.uniformName, f);
            }
            if (arg) {
                argFields.put(f.uniformName, f);
            }
            allFields.put(nReflectProperty.getName(), f);
        }
        if (args != null) {
            for (NElement nElement : args) {
                this.processField(nElement, true, instance, element, (Class)to, context, argFields, bodyFields);
            }
        }
        if ((body = container.children()) != null) {
            for (NElement arg : body) {
                this.processField(arg, false, instance, element, (Class)to, context, argFields, bodyFields);
            }
        }
        Cloneable cloneable = instance;
        NElementMapperBuilderInstanceContextImpl cc = new NElementMapperBuilderInstanceContextImpl(cloneable, element, to, context);
        for (NElementMapperBuilderInitializer<T> process : this.postProcess) {
            process.initializeInstance(cc);
        }
        return (T)instance;
    }

    private void processField(NElement arg, boolean isArg, T instance, NElement element, Class<T> to, NElementFactoryContext context, Map<String, NElementMapperBuilderFieldImpl<T>> argFields, Map<String, NElementMapperBuilderFieldImpl<T>> bodyFields) {
        Map<String, NElementMapperBuilderFieldImpl<T>> argFields2;
        Map<String, NElementMapperBuilderFieldImpl<T>> map = argFields2 = isArg ? argFields : bodyFields;
        if (arg.isSimplePair()) {
            NPairElement pair = arg.asPair().get();
            NElement key = pair.key();
            String expectedName = this.uniformName(key.asStringValue().get());
            NElementMapperBuilderFieldImpl<T> tField = argFields2.get(expectedName);
            if (tField != null) {
                Class jt;
                NElement value = pair.value();
                if (tField.isCollectionType() && tField.isWrapCollections() && !value.isArray()) {
                    if (tField.isContainerIsCollection()) {
                        if (value.isListContainer()) {
                            List<NElement> params;
                            NListContainerElement container = value.asListContainer().get();
                            NArrayElementBuilder tsonElements = NElement.ofArrayBuilder();
                            List<NElement> list = params = container.isParametrized() ? container.asParametrizedContainer().get().params().orNull() : null;
                            if (params != null) {
                                tsonElements.addAll(params);
                            }
                            if (container.children() != null) {
                                tsonElements.addAll(container.children());
                            }
                            value = tsonElements.build();
                        }
                    } else {
                        value = NElement.ofArray(value);
                    }
                }
                if (((jt = (Class)tField.field.getPropertyType().getJavaType()).isArray() || Collection.class.isAssignableFrom(jt)) && !value.isAnyArray()) {
                    tField.field.write(instance, context.createObject((NElement)value.wrapIntoArray(), jt));
                } else {
                    tField.field.write(instance, context.createObject(value, jt));
                }
            } else {
                this.onBodyNotSupported(instance, arg, isArg, element, to, context);
            }
        } else if (arg.isAnyString()) {
            String expectedName = this.uniformName(arg.asStringValue().get());
            NElementMapperBuilderFieldImpl<T> tField = argFields2.get(expectedName);
            boolean found = false;
            if (tField != null) {
                if (tField.isUseDefaultWhenMissingValue()) {
                    tField.field.write(instance, tField.getValueWhenMissing());
                }
                found = true;
            }
            if (!found) {
                this.onBodyNotSupported(instance, arg, isArg, element, to, context);
            }
        } else {
            this.onBodyNotSupported(instance, arg, isArg, element, to, context);
        }
    }

    private void onBodyNotSupported(T instance, NElement arg, boolean isArg, NElement element, Class<T> to, NElementFactoryContext context) {
        boolean found = false;
        if (!found) {
            List<NElementMapperBuilderFieldConfigurer<T>> list = isArg ? this.onUnsupportedArg : this.onUnsupportedBody;
            NElementMapperBuilderFieldContextImpl<T> cc = new NElementMapperBuilderFieldContextImpl<T>(instance, arg, element, to, context);
            for (NElementMapperBuilderFieldConfigurer<T> tOnUnsupported : list) {
                if (!tOnUnsupported.prepareField(cc)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            // empty if block
        }
    }

    private String uniformName(String s) {
        s = s.trim();
        if (this.renamer == null) {
            return s;
        }
        return this.renamer.apply(s);
    }
}

