/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.mapper.builder;

import java.lang.reflect.Type;
import java.util.Collection;
import net.thevpc.nuts.elem.NElementMapperBuilder;
import net.thevpc.nuts.reflect.NReflectProperty;
import net.thevpc.nuts.runtime.standalone.elem.mapper.builder.DefaultNElementMapperBuilder;

public class NElementMapperBuilderFieldImpl<T>
implements NElementMapperBuilder.FieldConfig<T> {
    DefaultNElementMapperBuilder<T> parent;
    String uniformName;
    String name;
    boolean arg;
    boolean body;
    NReflectProperty field;
    Boolean wrapCollections = true;
    Boolean containerIsCollection = false;
    Boolean useDefaultWhenMissingValue;
    Object valueWhenMissing;

    public NElementMapperBuilderFieldImpl(String name, DefaultNElementMapperBuilder<T> parent) {
        this.name = name;
        this.parent = parent;
    }

    @Override
    public NElementMapperBuilder.FieldConfig<T> setBooleanDefaultTrue() {
        if (this.isBooleanType()) {
            this.setDefaultValue(Boolean.TRUE);
            return this;
        }
        throw new IllegalArgumentException("expected boolean");
    }

    @Override
    public NElementMapperBuilder.FieldConfig<T> setBooleanDefaultFalse() {
        if (this.isBooleanType()) {
            this.setDefaultValue(Boolean.FALSE);
            return this;
        }
        throw new IllegalArgumentException("expected boolean");
    }

    @Override
    public NElementMapperBuilder.FieldConfig<T> setDefaultValue(Object valueWhenMissing) {
        this.useDefaultWhenMissingValue = true;
        this.valueWhenMissing = valueWhenMissing;
        return this;
    }

    Object getValueWhenMissing() {
        if (this.valueWhenMissing != null) {
            return this.valueWhenMissing;
        }
        Type raw = this.field.getDeclaringType().getJavaType();
        return this.parent.getDefaultValueByType(raw);
    }

    boolean isUseDefaultWhenMissingValue() {
        if (this.useDefaultWhenMissingValue != null) {
            return this.useDefaultWhenMissingValue;
        }
        Type raw = this.field.getDeclaringType().getJavaType();
        return this.parent.hasDefaultValueByType(raw);
    }

    public boolean isBooleanType() {
        Class cls;
        Type raw = this.field.getDeclaringType().getJavaType();
        return raw instanceof Class && ((cls = (Class)raw).equals(Boolean.class) || cls.equals(Boolean.TYPE));
    }

    public boolean isCollectionType() {
        Type raw = this.field.getDeclaringType().getJavaType();
        if (raw instanceof Class) {
            Class cls = (Class)raw;
            if (cls.isArray()) {
                return true;
            }
            if (Collection.class.isAssignableFrom(cls)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public NElementMapperBuilder.FieldConfig<T> setWrapCollections(Boolean value) {
        this.wrapCollections = value;
        return this;
    }

    @Override
    public NElementMapperBuilder.FieldConfig<T> setContainerIsCollection(Boolean value) {
        this.containerIsCollection = value;
        return this;
    }

    public boolean isWrapCollections() {
        if (this.wrapCollections != null) {
            return this.wrapCollections;
        }
        return this.parent.wrapCollections;
    }

    public boolean isContainerIsCollection() {
        if (this.containerIsCollection != null) {
            return this.containerIsCollection;
        }
        return this.parent.containerIsCollection;
    }

    @Override
    public NElementMapperBuilder.FieldConfig<T> setParam(boolean param) {
        this.arg = param;
        return this;
    }

    @Override
    public NElementMapperBuilder.FieldConfig<T> setChild(boolean child) {
        this.body = child;
        return this;
    }

    @Override
    public NElementMapperBuilder<T> end() {
        return this.parent;
    }
}

