/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.mapper;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementFactoryContext;
import net.thevpc.nuts.elem.NElementMapper;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.elem.NObjectElementBuilder;
import net.thevpc.nuts.reflect.NReflectProperty;
import net.thevpc.nuts.reflect.NReflectType;
import net.thevpc.nuts.runtime.standalone.reflect.ReflectUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class NElementMapperObjReflect
implements NElementMapper<Object> {
    @Override
    public Object destruct(Object src, Type typeOfSrc, NElementFactoryContext context) {
        NReflectType m = context.getTypesRepository().getType(typeOfSrc);
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        for (NReflectProperty property : m.getProperties()) {
            Object v;
            if (property.isDefaultValue(v = property.read(src))) continue;
            obj.put(property.getName(), context.destruct(v, null));
        }
        return obj;
    }

    @Override
    public NElement createElement(Object src, Type typeOfSrc, NElementFactoryContext context) {
        NReflectType m = context.getTypesRepository().getType(typeOfSrc);
        NObjectElementBuilder obj = NElement.ofObjectBuilder();
        for (NReflectProperty property : m.getProperties()) {
            Object v;
            if (property.isDefaultValue(v = property.read(src))) continue;
            obj.set(property.getName(), context.createElement(v));
        }
        return obj.build();
    }

    @Override
    public Object createObject(NElement o, Type typeOfResult, NElementFactoryContext context) {
        Class c = ReflectUtils.getRawClass(typeOfResult);
        switch (o.type()) {
            case NULL: {
                return null;
            }
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: 
            case TRIPLE_ANTI_QUOTED_STRING: 
            case LINE_STRING: {
                if (!c.isAssignableFrom(String.class)) break;
                return o.asStringValue().orNull();
            }
            case BOOLEAN: {
                if (!c.isAssignableFrom(Boolean.class)) break;
                return o.asLiteral().asBoolean();
            }
            case DOUBLE: {
                if (!c.isAssignableFrom(Double.class)) break;
                return o.asLiteral().asDouble();
            }
            case FLOAT: {
                if (!c.isAssignableFrom(Float.class)) break;
                return o.asLiteral().asFloat();
            }
            case BYTE: {
                if (!c.isAssignableFrom(Byte.class)) break;
                return o.asLiteral().asByte();
            }
            case BIG_DECIMAL: {
                if (!c.isAssignableFrom(BigDecimal.class)) break;
                return o.asLiteral().asNumber();
            }
            case BIG_INT: {
                if (!c.isAssignableFrom(BigInteger.class)) break;
                return o.asLiteral().asNumber();
            }
            case LONG: {
                if (!c.isAssignableFrom(Long.class)) break;
                return o.asLiteral().asLong();
            }
            case SHORT: {
                if (!c.isAssignableFrom(Short.class)) break;
                return o.asLiteral().asShort();
            }
            case INT: {
                if (!c.isAssignableFrom(Integer.class)) break;
                return o.asLiteral().asInt();
            }
            case INSTANT: {
                if (!c.isAssignableFrom(Instant.class)) break;
                return o.asLiteral().asInstant();
            }
            case ARRAY: {
                if (!c.isAssignableFrom(List.class)) break;
                return context.createObject(o, List.class);
            }
            case OBJECT: {
                if (!c.equals(Object.class)) break;
                return context.createObject(o, Map.class);
            }
            case CUSTOM: {
                return c.cast(o.asCustom().get().value());
            }
        }
        int mod = c.getModifiers();
        if (Modifier.isAbstract(mod)) {
            throw new NIllegalArgumentException(NMsg.ofC("cannot instantiate abstract class %s", typeOfResult));
        }
        NReflectType m = context.getTypesRepository().getType(typeOfResult);
        Object instance = m.newInstance();
        NObjectElement eobj = o.asObject().get();
        for (NReflectProperty property : m.getProperties()) {
            NElement v;
            if (!property.isWrite() || (v = eobj.get(property.getName()).orNull()) == null) continue;
            property.write(instance, context.createObject(v, property.getPropertyType().getJavaType()));
        }
        return instance;
    }
}

