/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.mapper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.stream.Collectors;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementFactoryContext;
import net.thevpc.nuts.elem.NElementMapper;
import net.thevpc.nuts.reflect.NReflectType;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNArrayElement;
import net.thevpc.nuts.runtime.standalone.reflect.ReflectUtils;

public class NElementMapperCollection
implements NElementMapper {
    public Object destruct(Object src, Type typeOfSrc, NElementFactoryContext context) {
        Collection coll = (Collection)src;
        return coll.stream().map(x -> context.destruct(x, null)).collect(Collectors.toList());
    }

    public NElement createElement(Object o, Type typeOfSrc, NElementFactoryContext context) {
        Collection coll = (Collection)o;
        List<NElement> collect = coll.stream().map(x -> context.createElement(x)).collect(Collectors.toList());
        return new DefaultNArrayElement(null, null, collect, new NElementAnnotation[0], null);
    }

    public Collection fillObject(NElement o, Collection coll, Type elemType, Type to, NElementFactoryContext context) {
        for (NElement nutsElement : o.asArray().get().children()) {
            coll.add(context.createObject(nutsElement, elemType));
        }
        return coll;
    }

    public Collection createObject(NElement o, Type to, NElementFactoryContext context) {
        if (to == null) {
            to = ArrayList.class;
        }
        Class cls = ReflectUtils.getRawClass((Type)to);
        Object elemType = Object.class;
        if (to instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)to;
            elemType = pt.getActualTypeArguments()[0];
        }
        switch (cls.getName()) {
            case "java.util.Collection": 
            case "java.util.List": 
            case "java.util.ArrayList": {
                return this.fillObject(o, new ArrayList(o.asArray().get().size()), (Type)elemType, (Type)to, context);
            }
            case "java.util.Set": 
            case "java.util.LinkedHashset": {
                return this.fillObject(o, new LinkedHashSet(), (Type)elemType, (Type)to, context);
            }
            case "java.util.Hashset": {
                return this.fillObject(o, new HashSet(), (Type)elemType, (Type)to, context);
            }
            case "java.util.SortedSet": 
            case "java.util.NavigableSet": 
            case "java.util.TreeSet": {
                return this.fillObject(o, new TreeSet(), (Type)elemType, (Type)to, context);
            }
            case "java.util.Queue": {
                return this.fillObject(o, new LinkedList(), (Type)elemType, (Type)to, context);
            }
            case "java.util.BlockingQueue": {
                return this.fillObject(o, new LinkedBlockingQueue(), (Type)elemType, (Type)to, context);
            }
            case "java.util.TransferQueue": {
                return this.fillObject(o, new LinkedTransferQueue(), (Type)elemType, (Type)to, context);
            }
            case "java.util.Deque": {
                return this.fillObject(o, new ArrayList(), (Type)elemType, (Type)to, context);
            }
        }
        NReflectType m = context.getTypesRepository().getType((Type)to);
        return this.fillObject(o, (Collection)m.newInstance(), (Type)elemType, (Type)to, context);
    }
}

