/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementBuilder;
import net.thevpc.nuts.elem.NElementTransform;
import net.thevpc.nuts.elem.NOperatorElementBuilder;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NUnsupportedOperationException;

public class NElementTransformHelper {
    public static NElement[] transform(NElement c, NElementTransform transform) {
        if (c == null) {
            return new NElement[0];
        }
        if (transform == null) {
            return new NElement[]{c};
        }
        NElement[] allThis = transform.preTransform(c);
        ArrayList<NElement> result = new ArrayList<NElement>();
        for (NElement a : allThis) {
            NElement[] u = NElementTransformHelper.transformAfter(a, transform);
            if (u == null) continue;
            result.addAll(Arrays.asList(u));
        }
        return result.toArray(new NElement[0]);
    }

    private static NElement[] transformAfter(NElement item, NElementTransform transform) {
        List<NElementAnnotation> annotations = item.builder().annotations();
        ArrayList<NElementAnnotation> annotations2 = new ArrayList<NElementAnnotation>();
        for (NElementAnnotation a : annotations) {
            List<NElement> u = a.params();
            if (u == null) {
                annotations2.add(NElement.ofAnnotation(a.name()));
                continue;
            }
            ArrayList<NElement> u2 = new ArrayList<NElement>(u.size());
            Iterator<NElement> iterator = u.iterator();
            while (iterator.hasNext()) {
                NElement nElement = iterator.next();
                u2.addAll(Arrays.asList(nElement.transform(transform)));
            }
            annotations2.add(NElement.ofAnnotation(a.name(), u2.toArray(new NElement[0])));
        }
        item = item.builder().clearAnnotations().addAnnotations(annotations2).build();
        switch (item.type().typeGroup()) {
            case CONTAINER: {
                NElementBuilder b;
                NElement[] v;
                NElement[] k;
                NElement[] u;
                NElementBuilder b2;
                NElement o;
                if (item.isAnyObject()) {
                    o = item.asObject().get();
                    b2 = null;
                    if (o.params().isPresent()) {
                        if (b2 == null) {
                            b2 = o.builder();
                        }
                        b2.clearParams();
                        for (NElement e : o.params().get()) {
                            u = e.transform(transform);
                            if (u == null) continue;
                            b2.addParams(Arrays.asList(u));
                        }
                    }
                    if (!o.children().isEmpty()) {
                        if (b2 == null) {
                            b2 = o.builder();
                        }
                        b2.clearChildren();
                        for (NElement e : o.children()) {
                            u = e.transform(transform);
                            if (u == null) continue;
                            b2.addAll(u);
                        }
                    }
                    if (b2 != null) {
                        o = b2.build();
                    }
                    return transform.postTransform(o);
                }
                if (item.isAnyArray()) {
                    o = item.asArray().get();
                    b2 = null;
                    if (o.params().isPresent()) {
                        if (b2 == null) {
                            b2 = o.builder();
                        }
                        b2.clearParams();
                        for (NElement e : o.params().get()) {
                            u = e.transform(transform);
                            if (u == null) continue;
                            b2.addParams(Arrays.asList(u));
                        }
                    }
                    if (!o.children().isEmpty()) {
                        if (b2 == null) {
                            b2 = o.builder();
                        }
                        b2.clearChildren();
                        for (NElement e : o.children()) {
                            u = e.transform(transform);
                            if (u == null) continue;
                            b2.addAll(u);
                        }
                    }
                    if (b2 != null) {
                        o = b2.build();
                    }
                    return transform.postTransform(o);
                }
                if (item.isAnyUplet()) {
                    o = item.asUplet().get();
                    b2 = null;
                    if (!o.params().isEmpty()) {
                        if (b2 == null) {
                            b2 = o.builder();
                        }
                        b2.clearParams();
                        for (NElement e : o.params()) {
                            u = e.transform(transform);
                            if (u == null) continue;
                            b2.addAll(Arrays.asList(u));
                        }
                    }
                    if (b2 != null) {
                        o = b2.build();
                    }
                    return transform.postTransform(o);
                }
                if (item.isPair()) {
                    o = item.asPair().get();
                    k = o.key().transform(transform);
                    v = o.value().transform(transform);
                    b = o.builder();
                    b.key(NElementTransformHelper.compressElement(k));
                    b.value(NElementTransformHelper.compressElement(v));
                    o = b.build();
                    return transform.postTransform(o);
                }
                if (item.isAnyMatrix()) {
                    throw new NUnsupportedOperationException(NMsg.ofC("matrices are not yet fully supported. cannot transform matrix"));
                }
                throw new NUnsupportedOperationException(NMsg.ofC("container %s not yet fully supported", item.type()));
            }
            case OPERATOR: {
                NElementBuilder b;
                NElement[] v;
                NElement[] k;
                NElement o;
                if (item.isBinaryOperator()) {
                    o = item.asOperator().get();
                    k = o.first().get().transform(transform);
                    v = o.second().get().transform(transform);
                    b = o.builder();
                    b.first(NElementTransformHelper.compressElement(k));
                    b.second(NElementTransformHelper.compressElement(v));
                    o = b.build();
                    return transform.postTransform(o);
                }
                if (item.isUnaryOperator()) {
                    o = item.asOperator().get();
                    k = o.first().get().transform(transform);
                    NOperatorElementBuilder b3 = o.builder();
                    b3.first(NElementTransformHelper.compressElement(k));
                    o = b3.build();
                    return transform.postTransform(o);
                }
                throw new NUnsupportedOperationException(NMsg.ofC("operator %s not yet fully supported", item.type()));
            }
        }
        return transform.postTransform(item);
    }

    private static NElement compressElement(NElement[] many) {
        if (many == null) {
            return NElement.ofNull();
        }
        if (many.length == 1) {
            return many[0] == null ? NElement.ofNull() : many[0];
        }
        return NElement.ofUplet(many);
    }
}

