/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.elem.NElementComment;
import net.thevpc.nuts.elem.NElementCommentType;
import net.thevpc.nuts.util.NStringBuilder;

public class NElementCommentImpl
implements NElementComment {
    private NElementCommentType type;
    private List<String> lines = new ArrayList<String>();

    public static NElementComment of(String text) {
        return NElementCommentImpl.ofMultiLine(text);
    }

    public static NElementCommentImpl ofMultiLine(String ... text) {
        return new NElementCommentImpl(NElementCommentType.MULTI_LINE, text);
    }

    public static NElementCommentImpl ofSingleLine(String ... text) {
        return new NElementCommentImpl(NElementCommentType.SINGLE_LINE, text);
    }

    public NElementCommentImpl(NElementCommentType type, String ... texts) {
        this.type = type;
        if (texts != null) {
            for (String text : texts) {
                this.lines.addAll(new NStringBuilder(text).lines().toList());
            }
        }
    }

    @Override
    public boolean isBlank() {
        return this.lines.isEmpty();
    }

    public String toString() {
        switch (this.type) {
            case SINGLE_LINE: {
                return new NStringBuilder(this.text()).indent("// ").append("\n").toString();
            }
            case MULTI_LINE: {
                return "/*\n" + new NStringBuilder(this.text()).indent("* ").toString() + "*/";
            }
        }
        return new NStringBuilder(this.text()).indent("// ").toString();
    }

    @Override
    public NElementCommentType type() {
        return this.type;
    }

    @Override
    public String text() {
        return this.lines.stream().collect(Collectors.joining("\n"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NElementCommentImpl that = (NElementCommentImpl)o;
        return this.type == that.type && Objects.equals(this.lines, that.lines);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.lines);
    }

    @Override
    public int compareTo(NElementComment o) {
        int i = this.text().compareTo(o.text());
        if (i != 0) {
            return i;
        }
        return this.type.compareTo(o.type());
    }
}

