/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.item;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.math.NBigComplex;
import net.thevpc.nuts.math.NDoubleComplex;
import net.thevpc.nuts.math.NFloatComplex;
import net.thevpc.nuts.runtime.standalone.elem.item.AbstractNElement;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;

public class NElementAsLiteral
implements NLiteral {
    private AbstractNElement elem;

    public NElementAsLiteral(AbstractNElement elem) {
        this.elem = elem;
    }

    @Override
    public NOptional<String> asStringAt(int index) {
        return this.asLiteralAt(index).asString();
    }

    @Override
    public NOptional<Long> asLongAt(int index) {
        return this.asLiteralAt(index).asLong();
    }

    @Override
    public NOptional<Integer> asIntAt(int index) {
        return this.asLiteralAt(index).asInt();
    }

    @Override
    public NOptional<Double> asDoubleAt(int index) {
        return this.asLiteralAt(index).asDouble();
    }

    @Override
    public boolean isNullAt(int index) {
        return this.asLiteralAt(index).isNull();
    }

    @Override
    public NLiteral asLiteralAt(int index) {
        return NLiteral.of(this.asObjectAt(index).orNull());
    }

    @Override
    public String toStringLiteral() {
        return this.toString();
    }

    @Override
    public <ET> NOptional<ET> asType(Class<ET> expectedType) {
        return this.elem.asPrimitive().flatMap(x -> x.asLiteral().asType(expectedType));
    }

    @Override
    public <ET> NOptional<ET> asType(Type expectedType) {
        return this.elem.asPrimitive().flatMap(x -> x.asLiteral().asType(expectedType));
    }

    @Override
    public NOptional<Object> asObject() {
        return NOptional.of(this.elem);
    }

    @Override
    public NOptional<Boolean> asBoolean() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asBoolean);
    }

    @Override
    public NOptional<Byte> asByte() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asByte);
    }

    @Override
    public NOptional<Double> asDouble() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asDouble);
    }

    @Override
    public NOptional<Float> asFloat() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asFloat);
    }

    @Override
    public NOptional<Instant> asInstant() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asInstant);
    }

    @Override
    public NOptional<LocalDate> asLocalDate() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asLocalDate);
    }

    @Override
    public NOptional<LocalDateTime> asLocalDateTime() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asLocalDateTime);
    }

    @Override
    public NOptional<LocalTime> asLocalTime() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asLocalTime);
    }

    @Override
    public NOptional<NBigComplex> asBigComplex() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asBigComplex);
    }

    @Override
    public NOptional<NDoubleComplex> asDoubleComplex() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asDoubleComplex);
    }

    @Override
    public NOptional<NFloatComplex> asFloatComplex() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asFloatComplex);
    }

    @Override
    public NOptional<Integer> asInt() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asInt);
    }

    @Override
    public NOptional<Long> asLong() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asLong);
    }

    @Override
    public NOptional<Short> asShort() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asShort);
    }

    @Override
    public NOptional<Character> asChar() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asChar);
    }

    @Override
    public boolean isSupportedType(Class<?> type) {
        NOptional<NLiteral> p = this.elem.asPrimitive().map(NElement::asLiteral);
        if (p.isPresent()) {
            return p.get().isSupportedType(type);
        }
        return false;
    }

    @Override
    public boolean isInstant() {
        return this.elem.type() == NElementType.INSTANT;
    }

    @Override
    public NOptional<String> asString() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asString);
    }

    @Override
    public NOptional<Number> asNumber() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asNumber);
    }

    @Override
    public NOptional<BigInteger> asBigInt() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asBigInt);
    }

    @Override
    public NOptional<BigDecimal> asBigDecimal() {
        return this.elem.asPrimitive().map(NElement::asLiteral).flatMap(NLiteral::asBigDecimal);
    }

    @Override
    public boolean isBigDecimal() {
        return this.elem.type() == NElementType.BIG_DECIMAL;
    }

    @Override
    public boolean isBigInt() {
        return this.elem.type() == NElementType.BIG_INT;
    }

    @Override
    public boolean isNull() {
        NElementType t = this.elem.type();
        return t == NElementType.NULL;
    }

    @Override
    public boolean isString() {
        NElementType t = this.elem.type();
        return t.isAnyString();
    }

    @Override
    public boolean isByte() {
        return this.elem.type() == NElementType.BYTE;
    }

    @Override
    public boolean isInt() {
        NElementType t = this.elem.type();
        return t == NElementType.INT;
    }

    @Override
    public boolean isLong() {
        return this.elem.type() == NElementType.LONG;
    }

    @Override
    public boolean isShort() {
        return this.elem.type() == NElementType.SHORT;
    }

    @Override
    public boolean isFloat() {
        return this.elem.type() == NElementType.FLOAT;
    }

    @Override
    public boolean isDouble() {
        return this.elem.type() == NElementType.DOUBLE;
    }

    @Override
    public boolean isBoolean() {
        return this.elem.type() == NElementType.BOOLEAN;
    }

    @Override
    public boolean isDecimalNumber() {
        return this.elem.type().isAnyDecimalNumber();
    }

    @Override
    public boolean isBigNumber() {
        return this.elem.type().isAnyBigNumber();
    }

    @Override
    public boolean isComplexNumber() {
        return this.elem.type().isAnyComplexNumber();
    }

    @Override
    public boolean isTemporal() {
        return this.elem.type().isAnyTemporal();
    }

    @Override
    public boolean isLocalTemporal() {
        return this.elem.type().isAnyLocalTemporal();
    }

    @Override
    public boolean isStream() {
        return this.elem.type().isAnyStream();
    }

    @Override
    public boolean isNumber() {
        return this.elem.type().isAnyNumber();
    }

    @Override
    public boolean isFloatingNumber() {
        return this.elem.type().isAnyFloatingNumber();
    }

    @Override
    public boolean isOrdinalNumber() {
        return this.elem.type().isAnyOrdinalNumber();
    }

    @Override
    public NOptional<Object> asObjectAt(int index) {
        return this.elem.asElementAt(index).map(x -> x.asLiteral().asObject().orNull());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isBlank() {
        return false;
    }
}

