/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.item;

import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NElementUtils;
import net.thevpc.nuts.elem.NStringElement;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNPrimitiveElement;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NOptional;

public class DefaultNStringElement
extends DefaultNPrimitiveElement
implements NStringElement {
    public DefaultNStringElement(NElementType type, String value) {
        this(type, value, null, null);
    }

    public DefaultNStringElement(NElementType type, String value, NElementAnnotation[] annotations, NElementComments comments) {
        super(type, value, annotations, comments);
        if (type == NElementType.NAME) {
            NAssert.requireTrue(NElementUtils.isValidElementName(value), "valid name : " + value);
        }
    }

    public DefaultNStringElement(NElementType type, Character value, NElementAnnotation[] annotations, NElementComments comments) {
        super(type, value, annotations, comments);
        if (type != NElementType.CHAR) {
            throw new NIllegalArgumentException(NMsg.ofC("expected character"));
        }
    }

    @Override
    public String stringValue() {
        return String.valueOf(this.value());
    }

    @Override
    public NOptional<NStringElement> asString() {
        return NOptional.of(this);
    }
}

