/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.elem.NPairElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.NElementToStringHelper;
import net.thevpc.nuts.runtime.standalone.elem.builder.DefaultNPairElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.item.AbstractNElement;
import net.thevpc.nuts.runtime.standalone.elem.path.NElementPathImpl;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringBuilder;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNPairElement
extends AbstractNElement
implements NPairElement {
    private final NElement key;
    private final NElement value;

    public DefaultNPairElement(NElement key, NElement value, NElementAnnotation[] annotations, NElementComments comments) {
        super(NElementType.PAIR, annotations, comments);
        this.key = key;
        this.value = value;
    }

    @Override
    public boolean isCustomTree() {
        if (super.isCustomTree()) {
            return true;
        }
        if (this.key != null && this.key.isCustomTree()) {
            return true;
        }
        return this.value != null && this.value.isCustomTree();
    }

    @Override
    public NOptional<String> name() {
        if (this.key.isAnyString()) {
            return this.key.asStringValue();
        }
        return NOptional.ofNamedEmpty("name");
    }

    @Override
    public List<NElement> resolveAll(String pattern) {
        pattern = NStringUtils.trimToNull(pattern);
        NElementPathImpl pp = new NElementPathImpl(pattern);
        NElement[] nElements = pp.resolveReversed(this);
        return new ArrayList<NElement>(Arrays.asList(nElements));
    }

    @Override
    public NPairElementBuilder builder() {
        return new DefaultNPairElementBuilder().copyFrom(this);
    }

    @Override
    public NElement key() {
        return this.key;
    }

    @Override
    public NElement value() {
        return this.value;
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean compact) {
        NStringBuilder sb = new NStringBuilder();
        sb.append(NElementToStringHelper.leadingCommentsAndAnnotations(this, compact));
        String skey = this.key.toString(compact);
        String svalue = this.value.toString(compact);
        if (compact) {
            sb.append(skey);
            sb.append(" : ");
            sb.append(svalue);
        } else if (new NStringBuilder(skey).lines().count() > 1L) {
            sb.append(skey);
            sb.append("\n : ");
            sb.append(new NStringBuilder(svalue).indent("  ", true));
        } else {
            sb.append(skey);
            sb.append(" : ");
            sb.append(new NStringBuilder(svalue).indent("  ", true));
        }
        sb.append(NElementToStringHelper.trailingComments(this, compact));
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNPairElement that = (DefaultNPairElement)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }
}

