/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.item;

import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NOperatorElement;
import net.thevpc.nuts.elem.NOperatorElementBuilder;
import net.thevpc.nuts.elem.NOperatorType;
import net.thevpc.nuts.runtime.standalone.elem.NElementToStringHelper;
import net.thevpc.nuts.runtime.standalone.elem.builder.DefaultNOperatorElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.item.AbstractNElement;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringBuilder;
import net.thevpc.nuts.util.NUnsupportedEnumException;

public class DefaultNOperatorElement
extends AbstractNElement
implements NOperatorElement {
    private NOperatorType operatorType;
    private NElement first;
    private NElement second;

    public DefaultNOperatorElement(NElementType operator, NOperatorType operatorType, NElement first, NElement second, NElementAnnotation[] annotations, NElementComments comments) {
        super(operator, annotations, comments);
        this.operatorType = operatorType;
        this.first = first;
        this.second = second;
    }

    @Override
    public NOperatorType operatorType() {
        return this.operatorType;
    }

    @Override
    public NOptional<NElement> first() {
        return NOptional.ofNamed(this.first, NMsg.ofC("first operand of %s", this.type()));
    }

    @Override
    public NOptional<NElement> second() {
        return NOptional.ofNamed(this.second, NMsg.ofC("second operand of %s", this.type()));
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean compact) {
        switch (this.operatorType()) {
            case BINARY_INFIX: {
                NStringBuilder sb = new NStringBuilder();
                sb.append(NElementToStringHelper.leadingCommentsAndAnnotations(this, compact));
                String skey = this.first.toString();
                String svalue = this.second.toString();
                String opSymbol = this.type().opSymbol();
                if (compact) {
                    sb.append(skey);
                    sb.append(" " + opSymbol + " ");
                    sb.append(svalue);
                } else if (new NStringBuilder(skey).lines().count() > 1L) {
                    sb.append(skey);
                    sb.append("\n " + opSymbol + " ");
                    sb.append(new NStringBuilder(svalue).indent("  ", true));
                } else {
                    sb.append(skey);
                    sb.append(" " + opSymbol + " ");
                    sb.append(new NStringBuilder(svalue).indent("  ", true));
                }
                sb.append(NElementToStringHelper.trailingComments(this, compact));
                return sb.toString();
            }
            case UNARY_PREFIX: {
                NStringBuilder sb = new NStringBuilder();
                sb.append(NElementToStringHelper.leadingCommentsAndAnnotations(this, compact));
                String svalue = this.first.toString();
                String opSymbol = this.type().opSymbol();
                if (compact) {
                    sb.append(opSymbol + " ");
                    sb.append(svalue);
                } else {
                    sb.append(opSymbol + " ");
                    sb.append(new NStringBuilder(svalue).indent("  ", true));
                }
                sb.append(NElementToStringHelper.trailingComments(this, compact));
                return sb.toString();
            }
        }
        throw new NUnsupportedEnumException(this.operatorType);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DefaultNOperatorElement that = (DefaultNOperatorElement)object;
        return this.operatorType == that.operatorType && Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.operatorType, this.first, this.second);
    }

    @Override
    public NOperatorElementBuilder builder() {
        return new DefaultNOperatorElementBuilder().first(this.first).second(this.second).operator(this.type()).operatorType(this.operatorType).addComments(this.comments()).addAnnotations((List)this.annotations());
    }
}

