/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.thevpc.nuts.elem.NArrayElement;
import net.thevpc.nuts.elem.NArrayElementBuilder;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NElementUtils;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.runtime.standalone.elem.NElementToStringHelper;
import net.thevpc.nuts.runtime.standalone.elem.item.AbstractNListContainerElement;
import net.thevpc.nuts.runtime.standalone.elem.path.NElementPathImpl;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringBuilder;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNArrayElement
extends AbstractNListContainerElement
implements NArrayElement {
    private final NElement[] values;
    private String name;
    private List<NElement> params;

    public DefaultNArrayElement(String name, List<NElement> params, Collection<NElement> values, NElementAnnotation[] annotations, NElementComments comments) {
        super(name == null && params == null ? NElementType.ARRAY : (name == null && params != null ? NElementType.PARAMETRIZED_ARRAY : (name != null && params == null ? NElementType.NAMED_ARRAY : NElementType.NAMED_PARAMETRIZED_ARRAY)), annotations, comments);
        if (name != null) {
            NAssert.requireTrue(NElementUtils.isValidElementName(name), "valid name : " + name);
        }
        this.values = values.toArray(new NElement[0]);
        this.name = name;
        this.params = params;
    }

    public DefaultNArrayElement(String name, List<NElement> params, NElement[] values, NElementAnnotation[] annotations, NElementComments comments) {
        super(name == null && params == null ? NElementType.ARRAY : (name == null && params != null ? NElementType.PARAMETRIZED_ARRAY : (name != null && params == null ? NElementType.NAMED_ARRAY : NElementType.NAMED_PARAMETRIZED_ARRAY)), annotations, comments);
        this.values = Arrays.copyOf(values, values.length);
        this.name = name;
        this.params = params;
    }

    @Override
    public boolean isCustomTree() {
        if (super.isCustomTree()) {
            return true;
        }
        if (this.params != null) {
            for (NElement value : this.params) {
                if (!value.isCustomTree()) continue;
                return true;
            }
        }
        if (this.values != null) {
            for (NElement value : this.values) {
                if (!value.isCustomTree()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isNamed(String name) {
        return this.isNamed() && Objects.equals(name, this.name);
    }

    @Override
    public List<NElement> children() {
        return Arrays.asList(this.values);
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Stream<NElement> stream() {
        return Arrays.asList(this.values).stream();
    }

    @Override
    public NOptional<NElement> get(int index) {
        if (index >= 0 && index < this.values.length) {
            return NOptional.of(this.values[index]);
        }
        return NOptional.ofError(() -> NMsg.ofC("invalid array index %s not in [%s,%s[", index, 0, this.values.length));
    }

    @Override
    public NOptional<NElement> getAt(int index) {
        if (index >= 0 && index < this.values.length) {
            return NOptional.of(this.values[index]);
        }
        return NOptional.ofError(() -> NMsg.ofC("invalid array index %s not in [%s,%s[", index, 0, this.values.length));
    }

    @Override
    public NArrayElementBuilder builder() {
        return NElement.ofArrayBuilder().copyFrom(this);
    }

    @Override
    public Iterator<NElement> iterator() {
        return Arrays.asList(this.values).iterator();
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean compact) {
        NStringBuilder sb = new NStringBuilder();
        sb.append(NElementToStringHelper.leadingCommentsAndAnnotations(this, compact));
        NElementToStringHelper.appendUplet(this.name, this.params, compact, sb);
        sb.append("[");
        NElementToStringHelper.appendChildren(this.children(), compact, new NElementToStringHelper.SemiCompactInfo().setMaxChildren(10).setMaxLineSize(120), sb);
        sb.append("]");
        sb.append(NElementToStringHelper.trailingComments(this, compact));
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultNArrayElement nElements = (DefaultNArrayElement)o;
        return Objects.deepEquals(this.values, nElements.values) && Objects.equals(this.name, nElements.name) && Objects.equals(this.params, nElements.params);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.values), this.name, this.params);
    }

    @Override
    public boolean isEmpty() {
        return this.values.length == 0;
    }

    @Override
    public boolean isBlank() {
        return this.values.length == 0 && NBlankable.isBlank(this.name) && (this.params == null || this.params.isEmpty());
    }

    @Override
    public NOptional<NElement> get(String s) {
        for (NElement x : this.values) {
            if (!(x instanceof NPairElement)) continue;
            NPairElement e = (NPairElement)x;
            if (!(s == null ? e.key().isNull() : e.key().isAnyString() && Objects.equals(e.key().asStringValue().get(), s))) continue;
            return NOptional.of(e.value());
        }
        if (NLiteral.of(s).asInt().isPresent()) {
            return this.get(NLiteral.of(s).asInt().get());
        }
        return NOptional.ofNamedEmpty("property " + s);
    }

    @Override
    public List<NElement> getAll(String s) {
        NOptional<NElement> u;
        ArrayList<NElement> ret = new ArrayList<NElement>();
        for (NElement x : this.values) {
            if (!(x instanceof NPairElement)) continue;
            NPairElement e = (NPairElement)x;
            if (s == null) {
                if (!e.key().isNull()) continue;
                ret.add(e.value());
                continue;
            }
            if (!e.key().isAnyString() || !Objects.equals(e.key().asStringValue().get(), s)) continue;
            ret.add(e.value());
        }
        if (ret.isEmpty() && NLiteral.of(s).asInt().isPresent() && (u = this.get(NLiteral.of(s).asInt().get())).isPresent()) {
            ret.add(u.get());
        }
        return ret;
    }

    @Override
    public NOptional<NElement> get(NElement key) {
        return key.isString() ? key.asStringValue().flatMap(this::get) : key.asIntValue().flatMap(this::get);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<NElement> getAll(NElement s) {
        int index = -1;
        if (s.isAnyString()) {
            NOptional<Integer> ii = NLiteral.of(s.asStringValue().get()).asInt();
            if (!ii.isPresent()) return Collections.emptyList();
            index = ii.get();
        } else {
            if (!s.asIntValue().isPresent()) return Collections.emptyList();
            index = s.asIntValue().get();
        }
        NOptional<NElement> a = this.get(index);
        if (!a.isPresent()) return Collections.emptyList();
        return Arrays.asList(a.get());
    }

    @Override
    public NOptional<String> name() {
        return NOptional.ofNamed(this.name, this.name);
    }

    @Override
    public boolean isNamed() {
        return this.name != null;
    }

    @Override
    public boolean isParametrized() {
        return this.params != null;
    }

    @Override
    public NOptional<List<NElement>> params() {
        return this.params == null ? NOptional.ofNamedEmpty("params") : NOptional.of(Collections.unmodifiableList(this.params));
    }

    @Override
    public int paramsCount() {
        return this.params == null ? null : Integer.valueOf(this.params.size());
    }

    @Override
    public NElement param(int index) {
        return this.params == null ? null : this.params.get(index);
    }

    @Override
    public List<NElement> resolveAll(String pattern) {
        pattern = NStringUtils.trimToNull(pattern);
        NElementPathImpl pp = new NElementPathImpl(pattern);
        NElement[] nElements = pp.resolveReversed(this);
        return new ArrayList<NElement>(Arrays.asList(nElements));
    }
}

