/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.thevpc.nuts.elem.NArrayElement;
import net.thevpc.nuts.elem.NArrayElementBuilder;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementBuilder;
import net.thevpc.nuts.elem.NElementComment;
import net.thevpc.nuts.elem.NElementCommentType;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.elem.NObjectElementBuilder;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.elem.NPairElementBuilder;
import net.thevpc.nuts.elem.NUpletElement;
import net.thevpc.nuts.elem.NUpletElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.AbstractNElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNPairElement;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNUpletElement;
import net.thevpc.nuts.runtime.standalone.elem.item.NElementCommentsImpl;
import net.thevpc.nuts.util.NMapStrategy;
import net.thevpc.nuts.util.NOptional;

public class DefaultNUpletElementBuilder
extends AbstractNElementBuilder
implements NUpletElementBuilder {
    private List<NElement> params = new ArrayList<NElement>();
    private String name;

    @Override
    public NUpletElementBuilder removeAnnotation(NElementAnnotation annotation) {
        super.removeAnnotation(annotation);
        return this;
    }

    @Override
    public NUpletElementBuilder copyFrom(NElementBuilder other) {
        this.copyFrom(other, NMapStrategy.ANY);
        return this;
    }

    @Override
    public NUpletElementBuilder copyFrom(NElement other) {
        this.copyFrom(other, NMapStrategy.ANY);
        return this;
    }

    @Override
    public NUpletElementBuilder copyFrom(NElementBuilder other, NMapStrategy strategy) {
        if (other == null) {
            return this;
        }
        super.copyFrom(other, strategy);
        if (other instanceof NPairElementBuilder) {
            NPairElementBuilder from = (NPairElementBuilder)other;
            this.add(from.key());
            this.add(from.value());
            return this;
        }
        if (other instanceof NUpletElementBuilder) {
            NUpletElementBuilder from = (NUpletElementBuilder)other;
            for (int i = 0; i < from.size(); ++i) {
                this.add(from.get(i).get());
            }
            return this;
        }
        if (other instanceof NObjectElementBuilder) {
            NObjectElementBuilder from = (NObjectElementBuilder)other;
            List<NElement> p = from.params().orNull();
            if (p != null) {
                this.addAll(p);
            }
            for (int i = 0; i < from.size(); ++i) {
                this.add(from.getAt(i).get());
            }
            this.name(from.name().orNull());
            return this;
        }
        if (other instanceof NArrayElementBuilder) {
            NArrayElementBuilder from = (NArrayElementBuilder)other;
            List<NElement> p = from.params().orNull();
            if (p != null) {
                this.addAll(p);
            }
            for (int i = 0; i < from.size(); ++i) {
                this.add(from.get(i).get());
            }
            this.name(from.name().orNull());
            return this;
        }
        return this;
    }

    @Override
    public NUpletElementBuilder copyFrom(NElement other, NMapStrategy strategy) {
        if (other == null) {
            return this;
        }
        super.copyFrom(other, strategy);
        if (other instanceof NPairElementBuilder) {
            NPairElementBuilder from = (NPairElementBuilder)((Object)other);
            this.add(from.key());
            this.add(from.value());
            return this;
        }
        if (other instanceof NUpletElement) {
            NUpletElement from = (NUpletElement)other;
            for (int i = 0; i < from.size(); ++i) {
                this.add(from.get(i).get());
            }
            return this;
        }
        if (other instanceof NObjectElement) {
            NObjectElement from = (NObjectElement)other;
            List<NElement> p = from.params().orNull();
            if (p != null) {
                this.addAll(p);
            }
            for (int i = 0; i < from.size(); ++i) {
                this.add(from.getAt(i).get());
            }
            this.name(from.name().orNull());
            return this;
        }
        if (other instanceof NArrayElement) {
            NArrayElement from = (NArrayElement)other;
            List<NElement> p = from.params().orNull();
            if (p != null) {
                this.addAll(p);
            }
            for (int i = 0; i < from.size(); ++i) {
                this.add(from.get(i).get());
            }
            this.name(from.name().orNull());
            return this;
        }
        return this;
    }

    @Override
    public boolean isCustomTree() {
        if (super.isCustomTree()) {
            return true;
        }
        if (this.params != null) {
            for (NElement value : this.params) {
                if (!value.isCustomTree()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public NUpletElementBuilder doWith(Consumer<NUpletElementBuilder> con) {
        if (con != null) {
            con.accept(this);
        }
        return this;
    }

    @Override
    public NOptional<String> name() {
        return NOptional.ofNamed(this.name, this.name);
    }

    @Override
    public NUpletElementBuilder name(String name) {
        this.name = name;
        return this;
    }

    public boolean isParametrized() {
        return this.params != null;
    }

    public NUpletElementBuilder setParametrized(boolean hasArgs) {
        if (hasArgs) {
            if (this.params == null) {
                this.params = new ArrayList<NElement>();
            }
        } else {
            this.params = null;
        }
        return this;
    }

    public NUpletElementBuilder addAt(int index, NElement arg) {
        if (arg != null) {
            if (this.params == null) {
                this.params = new ArrayList<NElement>();
            }
            this.params.add(index, arg);
        }
        return this;
    }

    @Override
    public NUpletElementBuilder removeAt(int index) {
        if (this.params != null) {
            this.params.remove(index);
        }
        return this;
    }

    @Override
    public List<NElement> params() {
        return Collections.unmodifiableList(this.params);
    }

    @Override
    public NUpletElementBuilder setParams(List<NElement> params) {
        this.params.clear();
        if (params != null) {
            this.params.addAll(params.stream().filter(x -> x != null).collect(Collectors.toList()));
        }
        return this;
    }

    @Override
    public int size() {
        return this.params.size();
    }

    @Override
    public NOptional<NElement> get(int index) {
        if (index >= 0 && index < this.params.size()) {
            return NOptional.of(this.params.get(index));
        }
        return NOptional.ofNamedEmpty("element at index " + index);
    }

    @Override
    public NUpletElementBuilder copyFrom(NUpletElement value) {
        if (value != null) {
            this.addAnnotations((List)value.annotations());
            this.addComments(value.comments());
            if (value.isNamed()) {
                this.name(value.name().get());
            }
            for (NElement child : value.children()) {
                this.add(child);
            }
        }
        return this;
    }

    @Override
    public NUpletElementBuilder addAll(NElement[] value) {
        if (value != null) {
            for (NElement e : value) {
                this.add(e);
            }
        }
        return this;
    }

    @Override
    public NUpletElementBuilder addAll(Collection<NElement> value) {
        if (value != null) {
            for (NElement e : value) {
                this.add(e);
            }
        }
        return this;
    }

    @Override
    public NUpletElementBuilder copyFrom(NUpletElementBuilder value) {
        if (value != null) {
            this.addAnnotations((List)value.annotations());
            this.addComments(value.comments());
            if (value.name().isPresent()) {
                this.name(value.name().get());
            }
            for (NElement child : value.params()) {
                this.add(child);
            }
        }
        return this;
    }

    @Override
    public NUpletElementBuilder add(NElement e) {
        this.params.add(this.denull(e));
        return this;
    }

    @Override
    public NUpletElementBuilder insert(int index, NElement e) {
        this.params.add(index, this.denull(e));
        return this;
    }

    @Override
    public NUpletElementBuilder set(int index, NElement e) {
        this.params.set(index, this.denull(e));
        return this;
    }

    @Override
    public NUpletElementBuilder clear() {
        this.params.clear();
        return this;
    }

    @Override
    public NUpletElementBuilder clearParams() {
        this.params.clear();
        return this;
    }

    @Override
    public NUpletElementBuilder remove(int index) {
        this.params.remove(index);
        return this;
    }

    @Override
    public NUpletElementBuilder addAll(String[] value) {
        for (String b : value) {
            this.add(b);
        }
        return this;
    }

    @Override
    public NUpletElementBuilder addAll(int[] value) {
        for (int b : value) {
            this.add(b);
        }
        return this;
    }

    @Override
    public NUpletElementBuilder addAll(double[] value) {
        for (double b : value) {
            this.add(b);
        }
        return this;
    }

    @Override
    public NUpletElementBuilder addAll(long[] value) {
        for (long b : value) {
            this.add(b);
        }
        return this;
    }

    @Override
    public NUpletElementBuilder addAll(float[] value) {
        for (float b : value) {
            this.add(b);
        }
        return this;
    }

    @Override
    public NUpletElementBuilder addAll(boolean[] value) {
        for (boolean b : value) {
            this.add(b);
        }
        return this;
    }

    @Override
    public NUpletElementBuilder addAll(char[] value) {
        for (char b : value) {
            this.add(b);
        }
        return this;
    }

    @Override
    public NUpletElementBuilder addAll(byte[] value) {
        for (byte b : value) {
            this.add(b);
        }
        return this;
    }

    @Override
    public NUpletElementBuilder add(int value) {
        return this.add(NElement.ofInt(value));
    }

    @Override
    public NUpletElementBuilder add(long value) {
        return this.add(NElement.ofLong(value));
    }

    @Override
    public NUpletElementBuilder add(double value) {
        return this.add(NElement.ofDouble(value));
    }

    @Override
    public NUpletElementBuilder add(float value) {
        return this.add(NElement.ofFloat(value));
    }

    @Override
    public NUpletElementBuilder add(byte value) {
        return this.add(NElement.ofByte(value));
    }

    @Override
    public NUpletElementBuilder add(boolean value) {
        return this.add(NElement.ofBoolean(value));
    }

    @Override
    public NUpletElementBuilder add(char value) {
        return this.add(NElement.ofString(String.valueOf(value)));
    }

    @Override
    public NUpletElementBuilder add(Number value) {
        return this.add(NElement.ofNumber(value));
    }

    @Override
    public NUpletElementBuilder add(String value) {
        return this.add(NElement.ofString(value));
    }

    @Override
    public NUpletElement build() {
        return new DefaultNUpletElement(this.name, this.params, this.annotations().toArray(new NElementAnnotation[0]), this.comments());
    }

    public String toString() {
        return "[" + this.params().stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }

    private NElement denull(NElement e) {
        if (e == null) {
            return NElement.ofNull();
        }
        return e;
    }

    @Override
    public NElementType type() {
        return this.name == null ? NElementType.UPLET : NElementType.NAMED_UPLET;
    }

    @Override
    public NUpletElementBuilder addLeadingComment(NElementCommentType type, String text) {
        super.addLeadingComment(type, text);
        return this;
    }

    @Override
    public NUpletElementBuilder addTrailingComment(NElementCommentType type, String text) {
        super.addTrailingComment(type, text);
        return this;
    }

    @Override
    public NUpletElementBuilder addLeadingComment(NElementComment comment) {
        super.addLeadingComment(comment);
        return this;
    }

    @Override
    public NUpletElementBuilder addLeadingComments(NElementComment ... comments) {
        super.addLeadingComments(comments);
        return this;
    }

    @Override
    public NUpletElementBuilder addTrailingComment(NElementComment comment) {
        super.addTrailingComment(comment);
        return this;
    }

    @Override
    public NUpletElementBuilder addTrailingComments(NElementComment ... comments) {
        super.addTrailingComments(comments);
        return this;
    }

    @Override
    public NUpletElementBuilder removeTrailingCommentAt(int index) {
        super.removeTrailingCommentAt(index);
        return this;
    }

    @Override
    public NUpletElementBuilder removeLeadingCommentAt(int index) {
        super.removeLeadingCommentAt(index);
        return this;
    }

    @Override
    public NUpletElementBuilder removeTrailingComment(NElementComment comment) {
        super.removeTrailingComment(comment);
        return this;
    }

    @Override
    public NUpletElementBuilder removeLeadingComment(NElementComment comment) {
        super.removeLeadingComment(comment);
        return this;
    }

    @Override
    public NUpletElementBuilder addComments(NElementComments comments) {
        super.addComments(comments);
        return this;
    }

    @Override
    public NUpletElementBuilder addAnnotations(List<NElementAnnotation> annotations) {
        super.addAnnotations(annotations);
        return this;
    }

    @Override
    public NUpletElementBuilder addAnnotation(String name, NElement ... args) {
        super.addAnnotation(name, args);
        return this;
    }

    @Override
    public NUpletElementBuilder addAnnotation(NElementAnnotation annotation) {
        super.addAnnotation(annotation);
        return this;
    }

    @Override
    public NUpletElementBuilder addAnnotationAt(int index, NElementAnnotation annotation) {
        super.addAnnotationAt(index, annotation);
        return this;
    }

    @Override
    public NUpletElementBuilder removeAnnotationAt(int index) {
        super.removeAnnotationAt(index);
        return this;
    }

    @Override
    public NUpletElementBuilder clearAnnotations() {
        super.clearAnnotations();
        return this;
    }

    @Override
    public NUpletElementBuilder clearComments() {
        super.clearComments();
        return this;
    }

    @Override
    public NUpletElementBuilder add(String name, NElement value) {
        return this.add(NElement.ofString(name), this.denull(value));
    }

    @Override
    public NUpletElementBuilder add(NElement name, NElement value) {
        this.add(this.pair(this.denull(name), this.denull(value)));
        return this;
    }

    @Override
    public NUpletElementBuilder set(NElement name, NElement value) {
        name = this.denull(name);
        value = this.denull(value);
        for (int i = 0; i < this.params.size(); ++i) {
            NElement nElement = this.params.get(i);
            if (nElement instanceof NPairElement) {
                NElement k = ((NPairElement)nElement).key();
                if (!Objects.equals(k, name)) continue;
                this.params.set(i, this.pair(name, value));
                return this;
            }
            if (!Objects.equals(nElement, name)) continue;
            this.params.set(i, this.pair(name, value));
            return this;
        }
        this.add(this.pair(name, value));
        return this;
    }

    private NPairElement pair(NElement k, NElement v) {
        return new DefaultNPairElement(k, v, new NElementAnnotation[0], new NElementCommentsImpl());
    }

    @Override
    public NUpletElementBuilder set(String name, NElement value) {
        return this.set((NElement)NElement.ofNameOrString(name), this.denull(value));
    }

    @Override
    public NUpletElementBuilder set(String name, boolean value) {
        return this.set((NElement)NElement.ofNameOrString(name), (NElement)NElement.ofBoolean(value));
    }

    @Override
    public NUpletElementBuilder set(String name, int value) {
        return this.set((NElement)NElement.ofNameOrString(name), (NElement)NElement.ofInt(value));
    }

    @Override
    public NUpletElementBuilder set(String name, double value) {
        return this.set((NElement)NElement.ofNameOrString(name), (NElement)NElement.ofDouble(value));
    }

    @Override
    public NUpletElementBuilder set(String name, String value) {
        return this.set((NElement)NElement.ofNameOrString(name), (NElement)NElement.ofString(value));
    }

    @Override
    public NUpletElementBuilder set(NElement name, boolean value) {
        return this.set(name, (NElement)NElement.ofBoolean(value));
    }

    @Override
    public NUpletElementBuilder set(NElement name, int value) {
        return this.set(name, (NElement)NElement.ofInt(value));
    }

    @Override
    public NUpletElementBuilder set(NElement name, double value) {
        return this.set(name, (NElement)NElement.ofDouble(value));
    }

    @Override
    public NUpletElementBuilder set(NElement name, String value) {
        return this.set(name, (NElement)NElement.ofString(value));
    }

    @Override
    public NUpletElementBuilder set(NPairElement entry) {
        if (entry != null) {
            this.set(entry.key(), entry.value());
        }
        return this;
    }

    @Override
    public NUpletElementBuilder add(String name, boolean value) {
        return this.add(NElement.ofNameOrString(name), (NElement)NElement.ofBoolean(value));
    }

    @Override
    public NUpletElementBuilder add(String name, int value) {
        return this.add(NElement.ofNameOrString(name), (NElement)NElement.ofInt(value));
    }

    @Override
    public NUpletElementBuilder add(String name, double value) {
        return this.add(NElement.ofNameOrString(name), (NElement)NElement.ofDouble(value));
    }

    @Override
    public NUpletElementBuilder add(String name, String value) {
        return this.add(NElement.ofNameOrString(name), (NElement)NElement.ofString(value));
    }

    @Override
    public NUpletElementBuilder addAll(Map<NElement, NElement> other) {
        if (other != null) {
            for (Map.Entry<NElement, NElement> e : other.entrySet()) {
                this.add(e.getKey(), e.getValue());
            }
        }
        return this;
    }
}

