/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.thevpc.nuts.elem.NArrayElement;
import net.thevpc.nuts.elem.NArrayElementBuilder;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementBuilder;
import net.thevpc.nuts.elem.NElementComment;
import net.thevpc.nuts.elem.NElementCommentType;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NMatrixElement;
import net.thevpc.nuts.elem.NMatrixElementBuilder;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.elem.NObjectElementBuilder;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.elem.NPairElementBuilder;
import net.thevpc.nuts.elem.NUpletElement;
import net.thevpc.nuts.elem.NUpletElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.AbstractNElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNObjectElement;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNPairElement;
import net.thevpc.nuts.runtime.standalone.elem.item.NElementCommentsImpl;
import net.thevpc.nuts.util.NMapStrategy;
import net.thevpc.nuts.util.NOptional;

public class DefaultNObjectElementBuilder
extends AbstractNElementBuilder
implements NObjectElementBuilder {
    private final List<NElement> values = new ArrayList<NElement>();
    private String name;
    private List<NElement> params;

    @Override
    public NObjectElementBuilder removeAnnotation(NElementAnnotation annotation) {
        super.removeAnnotation(annotation);
        return this;
    }

    @Override
    public NObjectElementBuilder copyFrom(NElementBuilder other) {
        this.copyFrom(other, NMapStrategy.ANY);
        return this;
    }

    @Override
    public NObjectElementBuilder copyFrom(NElement other) {
        this.copyFrom(other, NMapStrategy.ANY);
        return this;
    }

    @Override
    public NObjectElementBuilder copyFrom(NElementBuilder other, NMapStrategy strategy) {
        if (other == null) {
            return this;
        }
        super.copyFrom(other, strategy);
        if (other instanceof NPairElementBuilder) {
            NPairElementBuilder from = (NPairElementBuilder)other;
            this.add(from.key(), from.value());
            return this;
        }
        if (other instanceof NUpletElementBuilder) {
            NUpletElementBuilder from = (NUpletElementBuilder)other;
            for (int i = 0; i < from.size(); ++i) {
                this.addParam(from.get(i).get());
            }
            return this;
        }
        if (other instanceof NObjectElementBuilder) {
            NObjectElementBuilder from = (NObjectElementBuilder)other;
            for (int i = 0; i < from.size(); ++i) {
                this.add(from.getAt(i).get());
            }
            List<NElement> p = from.params().orNull();
            if (p != null) {
                this.addParams(p);
            }
            this.name(from.name().orNull());
            return this;
        }
        if (other instanceof NArrayElementBuilder) {
            NArrayElementBuilder from = (NArrayElementBuilder)other;
            for (int i = 0; i < from.size(); ++i) {
                this.add(from.get(i).get());
            }
            List<NElement> p = from.params().orNull();
            if (p != null) {
                this.addParams(p);
            }
            this.name(from.name().orNull());
            return this;
        }
        if (other instanceof NMatrixElementBuilder) {
            NMatrixElementBuilder from = (NMatrixElementBuilder)other;
            for (NArrayElement row : from.rows()) {
                this.add(row);
            }
            this.name(from.name().orNull());
            return this;
        }
        return this;
    }

    @Override
    public NObjectElementBuilder copyFrom(NElement other, NMapStrategy strategy) {
        if (other == null) {
            return this;
        }
        super.copyFrom(other, strategy);
        if (other instanceof NPairElement) {
            NPairElement from = (NPairElement)other;
            this.add(from.key(), from.value());
            return this;
        }
        if (other instanceof NUpletElement) {
            NUpletElement from = (NUpletElement)other;
            for (int i = 0; i < from.size(); ++i) {
                this.addParam(from.get(i).get());
            }
            return this;
        }
        if (other instanceof NObjectElement) {
            NObjectElement from = (NObjectElement)other;
            for (int i = 0; i < from.size(); ++i) {
                this.add(from.getAt(i).get());
            }
            List<NElement> p = from.params().orNull();
            if (p != null) {
                this.addParams(p);
            }
            this.name(from.name().orNull());
            return this;
        }
        if (other instanceof NArrayElement) {
            NArrayElement from = (NArrayElement)other;
            for (int i = 0; i < from.size(); ++i) {
                this.add(from.get(i).get());
            }
            List<NElement> p = from.params().orNull();
            if (p != null) {
                this.addParams(p);
            }
            this.name(from.name().orNull());
            return this;
        }
        if (other instanceof NMatrixElement) {
            NMatrixElement from = (NMatrixElement)other;
            for (NArrayElement row : from.rows()) {
                this.add(row);
            }
            this.name(from.name().orNull());
            return this;
        }
        return this;
    }

    @Override
    public boolean isCustomTree() {
        if (super.isCustomTree()) {
            return true;
        }
        if (this.params != null) {
            for (NElement value : this.params) {
                if (!value.isCustomTree()) continue;
                return true;
            }
        }
        if (this.values != null) {
            for (NElement value : this.values) {
                if (!value.isCustomTree()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public NOptional<String> name() {
        return NOptional.ofNamed(this.name, this.name);
    }

    @Override
    public NObjectElementBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public boolean isParametrized() {
        return this.params != null;
    }

    @Override
    public NObjectElementBuilder setParametrized(boolean parametrized) {
        if (parametrized) {
            if (this.params == null) {
                this.params = new ArrayList<NElement>();
            }
        } else {
            this.params = null;
        }
        return this;
    }

    @Override
    public NObjectElementBuilder addParams(List<NElement> params) {
        if (params != null) {
            if (this.params == null) {
                this.params = new ArrayList<NElement>();
            }
            for (NElement a : params) {
                if (a == null) continue;
                this.params.add(a);
            }
        }
        return this;
    }

    @Override
    public NObjectElementBuilder addParam(NElement param) {
        if (param != null) {
            if (this.params == null) {
                this.params = new ArrayList<NElement>();
            }
            this.params.add(param);
        }
        return this;
    }

    @Override
    public NObjectElementBuilder setParamAt(int index, NElement param) {
        if (param != null) {
            if (this.params == null) {
                this.params = new ArrayList<NElement>();
            }
            while (this.params.size() < index + 1) {
                this.params.add(NElement.ofNull());
            }
            this.params.set(index, param);
        }
        return this;
    }

    @Override
    public NObjectElementBuilder setParamAt(int index, boolean value) {
        return this.setParamAt(index, NElement.ofBoolean(value));
    }

    @Override
    public NObjectElementBuilder setParamAt(int index, int value) {
        return this.setParamAt(index, NElement.ofInt(value));
    }

    @Override
    public NObjectElementBuilder setParamAt(int index, double value) {
        return this.setParamAt(index, NElement.ofDouble(value));
    }

    @Override
    public NObjectElementBuilder setParamAt(int index, String value) {
        return this.setParamAt(index, NElement.ofString(value));
    }

    @Override
    public NObjectElementBuilder setParams(List<NElement> params) {
        this.params = params == null ? null : params.stream().filter(x -> x != null).collect(Collectors.toList());
        return this;
    }

    @Override
    public NObjectElementBuilder setChildren(List<NElement> params) {
        this.values.clear();
        if (params != null) {
            this.values.addAll(params.stream().filter(x -> x != null).collect(Collectors.toList()));
        }
        return this;
    }

    @Override
    public NObjectElementBuilder addParamAt(int index, NElement param) {
        if (param != null) {
            if (this.params == null) {
                this.params = new ArrayList<NElement>();
            }
            this.params.add(index, param);
        }
        return this;
    }

    @Override
    public NObjectElementBuilder removeParamAt(int index) {
        if (this.params != null) {
            this.params.remove(index);
        }
        return this;
    }

    @Override
    public NObjectElementBuilder clearParams() {
        if (this.params != null) {
            this.params.clear();
        }
        return this;
    }

    @Override
    public NOptional<List<NElement>> params() {
        if (this.params == null) {
            return NOptional.ofNamedEmpty("params");
        }
        return NOptional.of(Collections.unmodifiableList(this.params));
    }

    @Override
    public List<NElement> children() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public List<NElement> getAll(NElement s) {
        ArrayList<NElement> ret = new ArrayList<NElement>();
        for (NElement x : this.values) {
            NPairElement e;
            if (!(x instanceof NPairElement) || !Objects.equals((e = (NPairElement)x).key(), s)) continue;
            ret.add(e.value());
        }
        return ret;
    }

    @Override
    public NOptional<NElement> get(NElement s) {
        return NOptional.ofNamedSingleton(this.getAll(s), "property " + s);
    }

    @Override
    public NOptional<NElement> get(String s) {
        return this.get(NElement.ofString(s));
    }

    @Override
    public NOptional<NElement> getAt(int index) {
        if (index >= 0 && index < this.values.size()) {
            return NOptional.of(this.values.get(index));
        }
        return NOptional.ofNamedEmpty("property at index " + index);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public NObjectElementBuilder add(String name, NElement value) {
        return this.add(NElement.ofString(name), this.denull(value));
    }

    @Override
    public NObjectElementBuilder add(NElement name, NElement value) {
        this.add(this.pair(this.denull(name), this.denull(value)));
        return this;
    }

    @Override
    public NObjectElementBuilder set(NElement name, NElement value) {
        name = this.denull(name);
        value = this.denull(value);
        for (int i = 0; i < this.values.size(); ++i) {
            NElement nElement = this.values.get(i);
            if (nElement instanceof NPairElement) {
                NElement k = ((NPairElement)nElement).key();
                if (!Objects.equals(k, name)) continue;
                this.values.set(i, this.pair(name, value));
                return this;
            }
            if (!Objects.equals(nElement, name)) continue;
            this.values.set(i, this.pair(name, value));
            return this;
        }
        this.add(this.pair(name, value));
        return this;
    }

    private NPairElement pair(NElement k, NElement v) {
        return new DefaultNPairElement(k, v, new NElementAnnotation[0], new NElementCommentsImpl());
    }

    @Override
    public NObjectElementBuilder set(String name, NElement value) {
        return this.set((NElement)NElement.ofNameOrString(name), this.denull(value));
    }

    @Override
    public NObjectElementBuilder set(String name, boolean value) {
        return this.set((NElement)NElement.ofNameOrString(name), (NElement)NElement.ofBoolean(value));
    }

    @Override
    public NObjectElementBuilder set(String name, int value) {
        return this.set((NElement)NElement.ofNameOrString(name), (NElement)NElement.ofInt(value));
    }

    @Override
    public NObjectElementBuilder set(String name, double value) {
        return this.set((NElement)NElement.ofNameOrString(name), (NElement)NElement.ofDouble(value));
    }

    @Override
    public NObjectElementBuilder set(String name, String value) {
        return this.set((NElement)NElement.ofNameOrString(name), (NElement)NElement.ofString(value));
    }

    @Override
    public NObjectElementBuilder remove(NElement name) {
        name = this.denull(name);
        for (int i = 0; i < this.values.size(); ++i) {
            NElement nElement = this.values.get(i);
            if (nElement instanceof NPairElement) {
                NElement k = ((NPairElement)nElement).key();
                if (!Objects.equals(k, name)) continue;
                this.values.remove(i);
                return this;
            }
            if (!Objects.equals(nElement, name)) continue;
            this.values.remove(i);
            return this;
        }
        return this;
    }

    @Override
    public NObjectElementBuilder removeAll(NElement name) {
        name = this.denull(name);
        for (int i = this.values.size() - 1; i >= 0; --i) {
            NElement nElement = this.values.get(i);
            if (nElement instanceof NPairElement) {
                NElement k = ((NPairElement)nElement).key();
                if (!Objects.equals(k, name)) continue;
                this.values.remove(i);
                continue;
            }
            if (!Objects.equals(nElement, name)) continue;
            this.values.remove(i);
        }
        return this;
    }

    @Override
    public NObjectElementBuilder remove(String name) {
        return this.remove(NElement.ofString(name));
    }

    @Override
    public NObjectElementBuilder removeAll(String name) {
        return this.removeAll(NElement.ofString(name));
    }

    @Override
    public NObjectElementBuilder addAll(Map<NElement, NElement> other) {
        if (other != null) {
            for (Map.Entry<NElement, NElement> e : other.entrySet()) {
                this.add(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    @Override
    public NObjectElementBuilder addAll(List<NElement> other) {
        if (other != null) {
            for (NElement e : other) {
                if (e == null) continue;
                this.add(e);
            }
        }
        return this;
    }

    @Override
    public NObjectElementBuilder setAll(Map<NElement, NElement> other) {
        if (other != null) {
            for (Map.Entry<NElement, NElement> e : other.entrySet()) {
                this.set(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    @Override
    public NObjectElementBuilder set(NElement name, boolean value) {
        return this.set(name, (NElement)NElement.ofBoolean(value));
    }

    @Override
    public NObjectElementBuilder set(NElement name, int value) {
        return this.set(name, (NElement)NElement.ofInt(value));
    }

    @Override
    public NObjectElementBuilder set(NElement name, double value) {
        return this.set(name, (NElement)NElement.ofDouble(value));
    }

    @Override
    public NObjectElementBuilder set(NElement name, String value) {
        return this.set(name, (NElement)NElement.ofString(value));
    }

    @Override
    public NObjectElementBuilder clear() {
        this.values.clear();
        return this;
    }

    @Override
    public NObjectElementBuilder clearChildren() {
        this.values.clear();
        return this;
    }

    @Override
    public NObjectElementBuilder copyFrom(NObjectElement other) {
        if (other != null) {
            this.addAnnotations((List)other.annotations());
            this.addComments(other.comments());
            if (other.isNamed()) {
                this.name(other.name().get());
            }
            this.addParams(other.params().orNull());
            this.addAll(other.children());
        }
        return this;
    }

    @Override
    public NObjectElementBuilder add(NElement entry) {
        if (entry != null) {
            this.values.add(entry);
        }
        return this;
    }

    @Override
    public NObjectElementBuilder set(NPairElement entry) {
        if (entry != null) {
            this.set(entry.key(), entry.value());
        }
        return this;
    }

    @Override
    public NObjectElementBuilder addAll(NElement ... entries) {
        if (entries != null) {
            for (NElement entry : entries) {
                this.add(entry);
            }
        }
        return this;
    }

    @Override
    public NObjectElementBuilder add(String name, boolean value) {
        return this.add(NElement.ofNameOrString(name), (NElement)NElement.ofBoolean(value));
    }

    @Override
    public NObjectElementBuilder add(String name, int value) {
        return this.add(NElement.ofNameOrString(name), (NElement)NElement.ofInt(value));
    }

    @Override
    public NObjectElementBuilder add(String name, double value) {
        return this.add(NElement.ofNameOrString(name), (NElement)NElement.ofDouble(value));
    }

    @Override
    public NObjectElementBuilder add(String name, String value) {
        return this.add(NElement.ofNameOrString(name), (NElement)NElement.ofString(value));
    }

    @Override
    public NObjectElementBuilder doWith(Consumer<NObjectElementBuilder> con) {
        if (con != null) {
            con.accept(this);
        }
        return this;
    }

    @Override
    public NObjectElementBuilder addAll(NObjectElementBuilder other) {
        if (other != null) {
            for (NElement entry : other.build()) {
                this.add(entry);
            }
        }
        return this;
    }

    @Override
    public NObjectElement build() {
        return new DefaultNObjectElement(this.name, this.params, this.values, this.annotations().toArray(new NElementAnnotation[0]), this.comments());
    }

    public String toString() {
        return "{" + this.children().stream().map(x -> x.toString()).collect(Collectors.joining(", ")) + "}";
    }

    private NElement denull(NElement e) {
        if (e == null) {
            return NElement.ofNull();
        }
        return e;
    }

    @Override
    public NElementType type() {
        if (this.name != null && this.params != null) {
            return NElementType.NAMED_PARAMETRIZED_OBJECT;
        }
        if (this.name != null) {
            return NElementType.NAMED_OBJECT;
        }
        if (this.params != null) {
            return NElementType.PARAMETRIZED_OBJECT;
        }
        return NElementType.OBJECT;
    }

    @Override
    public NObjectElementBuilder addLeadingComment(NElementCommentType type, String text) {
        super.addLeadingComment(type, text);
        return this;
    }

    @Override
    public NObjectElementBuilder addTrailingComment(NElementCommentType type, String text) {
        super.addTrailingComment(type, text);
        return this;
    }

    @Override
    public NObjectElementBuilder addLeadingComment(NElementComment comment) {
        super.addLeadingComment(comment);
        return this;
    }

    @Override
    public NObjectElementBuilder addLeadingComments(NElementComment ... comments) {
        super.addLeadingComments(comments);
        return this;
    }

    @Override
    public NObjectElementBuilder addTrailingComment(NElementComment comment) {
        super.addTrailingComment(comment);
        return this;
    }

    @Override
    public NObjectElementBuilder addTrailingComments(NElementComment ... comments) {
        super.addTrailingComments(comments);
        return this;
    }

    @Override
    public NObjectElementBuilder removeTrailingCommentAt(int index) {
        super.removeTrailingCommentAt(index);
        return this;
    }

    @Override
    public NObjectElementBuilder removeLeadingCommentAt(int index) {
        super.removeLeadingCommentAt(index);
        return this;
    }

    @Override
    public NObjectElementBuilder removeTrailingComment(NElementComment comment) {
        super.removeTrailingComment(comment);
        return this;
    }

    @Override
    public NObjectElementBuilder removeLeadingComment(NElementComment comment) {
        super.removeLeadingComment(comment);
        return this;
    }

    @Override
    public NObjectElementBuilder addComments(NElementComments comments) {
        super.addComments(comments);
        return this;
    }

    @Override
    public NObjectElementBuilder addAnnotations(List<NElementAnnotation> annotations) {
        super.addAnnotations(annotations);
        return this;
    }

    @Override
    public NObjectElementBuilder addAnnotation(String name, NElement ... args) {
        super.addAnnotation(name, args);
        return this;
    }

    @Override
    public NObjectElementBuilder addAnnotation(NElementAnnotation annotation) {
        super.addAnnotation(annotation);
        return this;
    }

    @Override
    public NObjectElementBuilder addAnnotationAt(int index, NElementAnnotation annotation) {
        super.addAnnotationAt(index, annotation);
        return this;
    }

    @Override
    public NObjectElementBuilder removeAnnotationAt(int index) {
        super.removeAnnotationAt(index);
        return this;
    }

    @Override
    public NObjectElementBuilder clearAnnotations() {
        super.clearAnnotations();
        return this;
    }

    @Override
    public NObjectElementBuilder clearComments() {
        super.clearComments();
        return this;
    }

    @Override
    public NObjectElementBuilder addParam(String name, NElement value) {
        return this.addParam(NElement.ofPair(name, value));
    }

    @Override
    public NObjectElementBuilder addParam(String name, String value) {
        return this.addParam(NElement.ofPair(name, value));
    }

    @Override
    public NObjectElementBuilder addParam(String name, Integer value) {
        return this.addParam(NElement.ofPair(name, value));
    }

    @Override
    public NObjectElementBuilder addParam(String name, Long value) {
        return this.addParam(NElement.ofPair(name, value));
    }

    @Override
    public NObjectElementBuilder addParam(String name, Double value) {
        return this.addParam(NElement.ofPair(name, value));
    }

    @Override
    public NObjectElementBuilder addParam(String name, Boolean value) {
        return this.addParam(NElement.ofPair(name, value));
    }
}

