/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.thevpc.nuts.elem.NArrayElement;
import net.thevpc.nuts.elem.NArrayElementBuilder;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementBuilder;
import net.thevpc.nuts.elem.NElementComment;
import net.thevpc.nuts.elem.NElementCommentType;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NMatrixElement;
import net.thevpc.nuts.elem.NMatrixElementBuilder;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.elem.NObjectElementBuilder;
import net.thevpc.nuts.elem.NPairElementBuilder;
import net.thevpc.nuts.elem.NUpletElement;
import net.thevpc.nuts.elem.NUpletElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.AbstractNElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNArrayElement;
import net.thevpc.nuts.util.NMapStrategy;
import net.thevpc.nuts.util.NOptional;

public class DefaultNArrayElementBuilder
extends AbstractNElementBuilder
implements NArrayElementBuilder {
    private final List<NElement> values = new ArrayList<NElement>();
    private List<NElement> params;
    private String name;

    @Override
    public NArrayElementBuilder copyFrom(NElementBuilder other) {
        this.copyFrom(other, NMapStrategy.ANY);
        return this;
    }

    @Override
    public NArrayElementBuilder copyFrom(NElement other) {
        return (NArrayElementBuilder)super.copyFrom(other);
    }

    @Override
    public NArrayElementBuilder copyFrom(NElementBuilder other, NMapStrategy strategy) {
        if (other == null) {
            return this;
        }
        super.copyFrom(other, strategy);
        if (other instanceof NPairElementBuilder) {
            NPairElementBuilder from = (NPairElementBuilder)other;
            this.add(from.key());
            this.add(from.value());
            return this;
        }
        if (other instanceof NUpletElementBuilder) {
            NUpletElementBuilder from = (NUpletElementBuilder)other;
            for (int i = 0; i < from.size(); ++i) {
                this.add(from.get(i).get());
            }
            return this;
        }
        if (other instanceof NObjectElementBuilder) {
            NObjectElementBuilder from = (NObjectElementBuilder)other;
            for (int i = 0; i < from.size(); ++i) {
                this.add(from.getAt(i).get());
            }
            List<NElement> p = from.params().orNull();
            if (p != null) {
                this.addParams(p);
            }
            this.name(from.name().orNull());
            return this;
        }
        if (other instanceof NArrayElementBuilder) {
            NArrayElementBuilder from = (NArrayElementBuilder)other;
            for (int i = 0; i < from.size(); ++i) {
                this.add(from.get(i).get());
            }
            List<NElement> p = from.params().orNull();
            if (p != null) {
                this.addParams(p);
            }
            this.name(from.name().orNull());
            return this;
        }
        if (other instanceof NMatrixElementBuilder) {
            NMatrixElementBuilder from = (NMatrixElementBuilder)other;
            for (NArrayElement row : from.rows()) {
                this.add(row);
            }
            this.name(from.name().orNull());
            return this;
        }
        return this;
    }

    @Override
    public NArrayElementBuilder copyFrom(NElement other, NMapStrategy strategy) {
        if (other == null) {
            return this;
        }
        super.copyFrom(other, strategy);
        if (other instanceof NPairElementBuilder) {
            NPairElementBuilder from = (NPairElementBuilder)((Object)other);
            this.add(from.key());
            this.add(from.value());
            return this;
        }
        if (other instanceof NUpletElement) {
            NUpletElement from = (NUpletElement)other;
            for (int i = 0; i < from.size(); ++i) {
                this.add(from.get(i).get());
            }
            return this;
        }
        if (other instanceof NObjectElement) {
            NObjectElement from = (NObjectElement)other;
            for (int i = 0; i < from.size(); ++i) {
                this.add(from.getAt(i).get());
            }
            List<NElement> p = from.params().orNull();
            if (p != null) {
                this.addParams(p);
            }
            this.name(from.name().orNull());
            return this;
        }
        if (other instanceof NArrayElement) {
            NArrayElement from = (NArrayElement)other;
            for (int i = 0; i < from.size(); ++i) {
                this.add(from.get(i).get());
            }
            List<NElement> p = from.params().orNull();
            if (p != null) {
                this.addParams(p);
            }
            this.name(from.name().orNull());
            return this;
        }
        if (other instanceof NMatrixElement) {
            NMatrixElement from = (NMatrixElement)other;
            for (NArrayElement row : from.rows()) {
                this.add(row);
            }
            this.name(from.name().orNull());
            return this;
        }
        return this;
    }

    @Override
    public boolean isCustomTree() {
        if (super.isCustomTree()) {
            return true;
        }
        if (this.params != null) {
            for (NElement value : this.params) {
                if (!value.isCustomTree()) continue;
                return true;
            }
        }
        if (this.values != null) {
            for (NElement value : this.values) {
                if (!value.isCustomTree()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public NArrayElementBuilder doWith(Consumer<NArrayElementBuilder> con) {
        if (con != null) {
            con.accept(this);
        }
        return this;
    }

    @Override
    public NOptional<String> name() {
        return NOptional.ofNamed(this.name, this.name);
    }

    @Override
    public NArrayElementBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public boolean isParametrized() {
        return this.params != null;
    }

    @Override
    public NArrayElementBuilder setParametrized(boolean parametrized) {
        if (parametrized) {
            if (this.params == null) {
                this.params = new ArrayList<NElement>();
            }
        } else {
            this.params = null;
        }
        return this;
    }

    @Override
    public NArrayElementBuilder addParams(List<NElement> params) {
        if (params != null) {
            for (NElement a : params) {
                if (a == null) continue;
                if (this.params == null) {
                    this.params = new ArrayList<NElement>();
                }
                this.params.add(a);
            }
        }
        return this;
    }

    @Override
    public NArrayElementBuilder addParam(NElement param) {
        if (param != null) {
            if (this.params == null) {
                this.params = new ArrayList<NElement>();
            }
            this.params.add(param);
        }
        return this;
    }

    @Override
    public NArrayElementBuilder addParamAt(int index, NElement param) {
        if (param != null) {
            if (this.params == null) {
                this.params = new ArrayList<NElement>();
            }
            this.params.add(index, param);
        }
        return this;
    }

    @Override
    public NArrayElementBuilder removeParamAt(int index) {
        if (this.params != null) {
            this.params.remove(index);
        }
        return this;
    }

    @Override
    public NArrayElementBuilder clearParams() {
        if (this.params != null) {
            this.params.clear();
        }
        return this;
    }

    @Override
    public NOptional<List<NElement>> params() {
        if (this.params == null) {
            return NOptional.ofNamedEmpty("params");
        }
        return NOptional.of(Collections.unmodifiableList(this.params));
    }

    @Override
    public List<NElement> items() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public NArrayElementBuilder clearChildren() {
        this.values.clear();
        return this;
    }

    @Override
    public NOptional<NElement> get(int index) {
        if (index >= 0 && index < this.values.size()) {
            return NOptional.of(this.values.get(index));
        }
        return NOptional.ofNamedEmpty("element at index " + index);
    }

    @Override
    public NArrayElementBuilder addAll(NElement[] value) {
        if (value != null) {
            for (NElement e : value) {
                this.add(e);
            }
        }
        return this;
    }

    @Override
    public NArrayElementBuilder addAll(Collection<NElement> value) {
        if (value != null) {
            for (NElement e : value) {
                this.add(e);
            }
        }
        return this;
    }

    @Override
    public NArrayElementBuilder addAll(NArrayElementBuilder value) {
        if (value == null) {
            this.add(NElement.ofNull());
        } else {
            for (NElement child : value.items()) {
                this.add(child);
            }
        }
        return this;
    }

    @Override
    public NArrayElementBuilder add(NElement e) {
        this.values.add(this.denull(e));
        return this;
    }

    @Override
    public NArrayElementBuilder insert(int index, NElement e) {
        this.values.add(index, this.denull(e));
        return this;
    }

    @Override
    public NArrayElementBuilder set(int index, NElement e) {
        this.values.set(index, this.denull(e));
        return this;
    }

    @Override
    public NArrayElementBuilder clear() {
        this.values.clear();
        return this;
    }

    @Override
    public NArrayElementBuilder remove(int index) {
        this.values.remove(index);
        return this;
    }

    @Override
    public NArrayElementBuilder copyFrom(NArrayElement other) {
        if (other != null) {
            this.addAnnotations((List)other.annotations());
            this.addComments(other.comments());
            if (other.isNamed()) {
                this.name(other.name().orNull());
            }
            this.addParams(other.params().orNull());
            this.addAll(other.children());
        }
        return this;
    }

    @Override
    public NArrayElementBuilder addAll(String[] value) {
        for (String b : value) {
            this.add(b);
        }
        return this;
    }

    @Override
    public NArrayElementBuilder addAll(int[] value) {
        for (int b : value) {
            this.add(b);
        }
        return this;
    }

    @Override
    public NArrayElementBuilder addAll(double[] value) {
        for (double b : value) {
            this.add(b);
        }
        return this;
    }

    @Override
    public NArrayElementBuilder addAll(long[] value) {
        for (long b : value) {
            this.add(b);
        }
        return this;
    }

    @Override
    public NArrayElementBuilder addAll(float[] value) {
        for (float b : value) {
            this.add(b);
        }
        return this;
    }

    @Override
    public NArrayElementBuilder addAll(boolean[] value) {
        for (boolean b : value) {
            this.add(b);
        }
        return this;
    }

    @Override
    public NArrayElementBuilder addAll(char[] value) {
        for (char b : value) {
            this.add(b);
        }
        return this;
    }

    @Override
    public NArrayElementBuilder addAll(byte[] value) {
        for (byte b : value) {
            this.add(b);
        }
        return this;
    }

    @Override
    public NArrayElementBuilder add(int value) {
        return this.add(NElement.ofInt(value));
    }

    @Override
    public NArrayElementBuilder add(long value) {
        return this.add(NElement.ofLong(value));
    }

    @Override
    public NArrayElementBuilder add(double value) {
        return this.add(NElement.ofDouble(value));
    }

    @Override
    public NArrayElementBuilder add(float value) {
        return this.add(NElement.ofFloat(value));
    }

    @Override
    public NArrayElementBuilder add(byte value) {
        return this.add(NElement.ofByte(value));
    }

    @Override
    public NArrayElementBuilder add(boolean value) {
        return this.add(NElement.ofBoolean(value));
    }

    @Override
    public NArrayElementBuilder add(char value) {
        return this.add(NElement.ofString(String.valueOf(value)));
    }

    @Override
    public NArrayElementBuilder add(Number value) {
        return this.add(NElement.ofNumber(value));
    }

    @Override
    public NArrayElementBuilder add(String value) {
        return this.add(NElement.ofString(value));
    }

    @Override
    public NArrayElement build() {
        return new DefaultNArrayElement(this.name, this.params, this.values, this.annotations().toArray(new NElementAnnotation[0]), this.comments());
    }

    public String toString() {
        return "[" + this.items().stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }

    private NElement denull(NElement e) {
        if (e == null) {
            return NElement.ofNull();
        }
        return e;
    }

    @Override
    public NElementType type() {
        if (this.name != null && this.params != null) {
            return NElementType.NAMED_PARAMETRIZED_ARRAY;
        }
        if (this.name != null) {
            return NElementType.NAMED_ARRAY;
        }
        if (this.params != null) {
            return NElementType.PARAMETRIZED_ARRAY;
        }
        return NElementType.ARRAY;
    }

    @Override
    public NArrayElementBuilder addLeadingComment(NElementCommentType type, String text) {
        super.addLeadingComment(type, text);
        return this;
    }

    @Override
    public NArrayElementBuilder addTrailingComment(NElementCommentType type, String text) {
        super.addTrailingComment(type, text);
        return this;
    }

    @Override
    public NArrayElementBuilder addLeadingComment(NElementComment comment) {
        super.addLeadingComment(comment);
        return this;
    }

    @Override
    public NArrayElementBuilder addLeadingComments(NElementComment ... comments) {
        super.addLeadingComments(comments);
        return this;
    }

    @Override
    public NArrayElementBuilder addTrailingComment(NElementComment comment) {
        super.addTrailingComment(comment);
        return this;
    }

    @Override
    public NArrayElementBuilder addTrailingComments(NElementComment ... comments) {
        super.addTrailingComments(comments);
        return this;
    }

    @Override
    public NArrayElementBuilder removeTrailingCommentAt(int index) {
        super.removeTrailingCommentAt(index);
        return this;
    }

    @Override
    public NArrayElementBuilder removeLeadingCommentAt(int index) {
        super.removeLeadingCommentAt(index);
        return this;
    }

    @Override
    public NArrayElementBuilder removeTrailingComment(NElementComment comment) {
        super.removeTrailingComment(comment);
        return this;
    }

    @Override
    public NArrayElementBuilder removeLeadingComment(NElementComment comment) {
        super.removeLeadingComment(comment);
        return this;
    }

    @Override
    public NArrayElementBuilder addComments(NElementComments comments) {
        super.addComments(comments);
        return this;
    }

    @Override
    public NArrayElementBuilder addAnnotations(List<NElementAnnotation> annotations) {
        super.addAnnotations(annotations);
        return this;
    }

    @Override
    public NArrayElementBuilder addAnnotation(String name, NElement ... args) {
        super.addAnnotation(name, args);
        return this;
    }

    @Override
    public NArrayElementBuilder addAnnotation(NElementAnnotation annotation) {
        super.addAnnotation(annotation);
        return this;
    }

    @Override
    public NArrayElementBuilder addAnnotationAt(int index, NElementAnnotation annotation) {
        super.addAnnotationAt(index, annotation);
        return this;
    }

    @Override
    public NArrayElementBuilder removeAnnotationAt(int index) {
        super.removeAnnotationAt(index);
        return this;
    }

    @Override
    public NArrayElementBuilder removeAnnotation(NElementAnnotation annotation) {
        super.removeAnnotation(annotation);
        return this;
    }

    @Override
    public NArrayElementBuilder clearAnnotations() {
        super.clearAnnotations();
        return this;
    }

    @Override
    public NArrayElementBuilder clearComments() {
        super.clearComments();
        return this;
    }

    @Override
    public NArrayElementBuilder addParam(String name, NElement value) {
        return this.addParam(NElement.ofPair(name, value));
    }

    @Override
    public NArrayElementBuilder addParam(String name, String value) {
        return this.addParam(NElement.ofPair(name, value));
    }

    @Override
    public NArrayElementBuilder addParam(String name, Integer value) {
        return this.addParam(NElement.ofPair(name, value));
    }

    @Override
    public NArrayElementBuilder addParam(String name, Long value) {
        return this.addParam(NElement.ofPair(name, value));
    }

    @Override
    public NArrayElementBuilder addParam(String name, Double value) {
        return this.addParam(NElement.ofPair(name, value));
    }

    @Override
    public NArrayElementBuilder addParam(String name, Boolean value) {
        return this.addParam(NElement.ofPair(name, value));
    }

    @Override
    public NArrayElementBuilder setParams(List<NElement> params) {
        this.params = params == null ? null : params.stream().filter(x -> x != null).collect(Collectors.toList());
        return this;
    }

    @Override
    public NArrayElementBuilder setChildren(List<NElement> params) {
        this.values.clear();
        if (params != null) {
            this.values.addAll(params.stream().filter(x -> x != null).collect(Collectors.toList()));
        }
        return this;
    }

    @Override
    public List<NElement> children() {
        return new ArrayList<NElement>(this.values);
    }
}

