/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem;

import java.lang.reflect.Type;
import java.util.function.Consumer;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementFormat;
import net.thevpc.nuts.elem.NElementMapperStore;
import net.thevpc.nuts.elem.NElements;
import net.thevpc.nuts.io.NMemoryPrintStream;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.reflect.NReflectRepository;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNElementFactoryContext;
import net.thevpc.nuts.runtime.standalone.elem.NElementFactoryService;
import net.thevpc.nuts.runtime.standalone.elem.NElementStreamFormat;
import net.thevpc.nuts.runtime.standalone.elem.parser.mapperstore.UserElementMapperStore;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.format.NFetchDisplayOptions;
import net.thevpc.nuts.runtime.standalone.format.json.DefaultSearchFormatJson;
import net.thevpc.nuts.runtime.standalone.format.plain.DefaultSearchFormatPlain;
import net.thevpc.nuts.runtime.standalone.format.props.DefaultSearchFormatProps;
import net.thevpc.nuts.runtime.standalone.format.table.DefaultSearchFormatTable;
import net.thevpc.nuts.runtime.standalone.format.tree.DefaultSearchFormatTree;
import net.thevpc.nuts.runtime.standalone.format.tson.DefaultSearchFormatTson;
import net.thevpc.nuts.runtime.standalone.format.xml.DefaultSearchFormatXml;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTextManagerModel;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NIterableFormat;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.time.NProgressFactory;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NUnsupportedOperationException;

public class DefaultNElementFormat
extends DefaultFormatBase<NElementFormat>
implements NElementFormat {
    private final DefaultNTextManagerModel model;
    private Object value;
    private NContentType contentType = NContentType.JSON;
    private boolean compact;
    private boolean logProgress;
    private boolean traceProgress;
    private NProgressFactory progressFactory;
    private UserElementMapperStore userElementMapperStore;

    public DefaultNElementFormat() {
        super("element-format");
        this.model = NWorkspaceExt.of().getModel().textModel;
        this.userElementMapperStore = new UserElementMapperStore();
        this.userElementMapperStore.setReflectRepository(NReflectRepository.of());
    }

    @Override
    public NElementMapperStore mapperStore() {
        return this.userElementMapperStore;
    }

    @Override
    public NElementFormat doWithMapperStore(Consumer<NElementMapperStore> doWith) {
        if (doWith != null) {
            doWith.accept(this.mapperStore());
        }
        return this;
    }

    @Override
    public boolean isLogProgress() {
        return this.logProgress;
    }

    @Override
    public NElementFormat setLogProgress(boolean logProgress) {
        this.logProgress = logProgress;
        return this;
    }

    @Override
    public boolean isTraceProgress() {
        return this.traceProgress;
    }

    @Override
    public NElementFormat setTraceProgress(boolean traceProgress) {
        this.traceProgress = traceProgress;
        return this;
    }

    @Override
    public NContentType getContentType() {
        return this.contentType;
    }

    @Override
    public NElementFormat setContentType(NContentType contentType) {
        this.contentType = contentType == null ? NContentType.JSON : contentType;
        return this;
    }

    @Override
    public NElementFormat json() {
        return this.setContentType(NContentType.JSON);
    }

    @Override
    public NElementFormat yaml() {
        return this.setContentType(NContentType.YAML);
    }

    @Override
    public NElementFormat tson() {
        return this.setContentType(NContentType.TSON);
    }

    @Override
    public NElementFormat xml() {
        return this.setContentType(NContentType.XML);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public NElementFormat setValue(Object value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean isCompact() {
        return this.compact;
    }

    @Override
    public NElementFormat setCompact(boolean compact) {
        this.compact = compact;
        return this;
    }

    @Override
    public NIterableFormat iter(NPrintStream writer) {
        switch (this.getContentType()) {
            case JSON: {
                return new DefaultSearchFormatJson(writer, new NFetchDisplayOptions());
            }
            case TSON: {
                return new DefaultSearchFormatTson(writer, new NFetchDisplayOptions());
            }
            case XML: {
                return new DefaultSearchFormatXml(writer, new NFetchDisplayOptions());
            }
            case PLAIN: {
                return new DefaultSearchFormatPlain(writer, new NFetchDisplayOptions());
            }
            case TABLE: {
                return new DefaultSearchFormatTable(writer, new NFetchDisplayOptions());
            }
            case TREE: {
                return new DefaultSearchFormatTree(writer, new NFetchDisplayOptions());
            }
            case PROPS: {
                return new DefaultSearchFormatProps(writer, new NFetchDisplayOptions());
            }
        }
        throw new NUnsupportedOperationException(NMsg.ofC("unsupported iterator for %s", this.getContentType()));
    }

    private DefaultNElementFactoryContext createFactoryContext() {
        NReflectRepository reflectRepository = NWorkspaceUtils.of().getReflectRepository();
        DefaultNElementFactoryContext c = new DefaultNElementFactoryContext(this.isNtf(), reflectRepository, this.userElementMapperStore);
        switch (this.getContentType()) {
            case JSON: 
            case TSON: 
            case XML: 
            case YAML: {
                c.setNtf(false);
            }
        }
        return c;
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        return false;
    }

    private void print(NPrintStream out, NElementStreamFormat format) {
        NElement elem = NElements.of().doWithMapperStore(d -> d.copyFrom(this.mapperStore())).toElement(this.value);
        if (out.isNtf()) {
            NMemoryPrintStream bos = NMemoryPrintStream.of();
            format.printElement(elem, bos, this.compact, this.createFactoryContext());
            out.print(NText.ofCode(this.getContentType().id(), bos.toString()));
        } else {
            format.printElement(elem, out, this.compact, this.createFactoryContext());
        }
        out.flush();
    }

    @Override
    public void print(NPrintStream out) {
        if (this.contentType == NContentType.PLAIN) {
            this.print(out, this.model.getJsonMan());
        } else {
            this.print(out, this.model.getStreamFormat(this.contentType == null ? NContentType.JSON : this.contentType));
        }
    }

    public Object elementToObject(NElement o, Type type) {
        return this.createFactoryContext().createObject(o, type);
    }

    public NElementFactoryService getElementFactoryService() {
        return this.model.getElementFactoryService();
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public NProgressFactory getProgressFactory() {
        return this.progressFactory;
    }

    @Override
    public NElementFormat setProgressFactory(NProgressFactory progressFactory) {
        this.progressFactory = progressFactory;
        return this;
    }
}

