/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementFactoryContext;
import net.thevpc.nuts.elem.NElementMapper;
import net.thevpc.nuts.reflect.NReflectRepository;
import net.thevpc.nuts.runtime.standalone.elem.CoreNElementUtils;
import net.thevpc.nuts.runtime.standalone.elem.parser.mapperstore.UserElementMapperStore;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTextManagerModel;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class DefaultNElementFactoryContext
implements NElementFactoryContext {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Set<RefItem> visited = new LinkedHashSet<RefItem>();
    private final NReflectRepository repository;
    private boolean ntf;
    private UserElementMapperStore userElementMapperStore;
    private final DefaultNTextManagerModel model;
    private globalIndustructibleTypesFilter globalIndustructibleTypesFilter = new globalIndustructibleTypesFilter();

    public DefaultNElementFactoryContext(boolean ntf, NReflectRepository repository, UserElementMapperStore userElementMapperStore) {
        this.repository = repository;
        this.ntf = ntf;
        this.userElementMapperStore = userElementMapperStore;
        this.model = NWorkspaceExt.of().getModel().textModel;
    }

    @Override
    public NElement createElement(Object o) {
        return this.createElement(o, null);
    }

    public NElementMapper getMapper(Type type, boolean defaultOnly) {
        return this.userElementMapperStore.getMapper(type, defaultOnly);
    }

    @Override
    public <T> NElementMapper<T> getMapper(NElement element, boolean defaultOnly) {
        return this.userElementMapperStore.getMapper(element, defaultOnly);
    }

    @Override
    public Predicate<Type> getIndestructibleTypesFilter() {
        return this.globalIndustructibleTypesFilter;
    }

    @Override
    public boolean isIndestructibleObject(Object any) {
        if (any == null) {
            return false;
        }
        Predicate<Type> f = this.getIndestructibleTypesFilter();
        if (f == null) {
            return false;
        }
        return f.test(any.getClass());
    }

    @Override
    public boolean isIndestructibleType(Type any) {
        if (any == null) {
            return true;
        }
        Predicate<Type> f = this.getIndestructibleTypesFilter();
        if (f == null) {
            return true;
        }
        return f.test(any);
    }

    @Override
    public boolean isSimpleObject(Object any) {
        if (any == null) {
            return true;
        }
        return this.isSimpleType(any.getClass());
    }

    @Override
    public boolean isSimpleType(Type any) {
        if (any == null) {
            return true;
        }
        return CoreNElementUtils.DEFAULT_SIMPLE_TYPE.test(any);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    private String stacktrace() {
        StringBuilder sb = new StringBuilder();
        boolean nl = false;
        for (RefItem refItem : this.visited) {
            if (nl) {
                sb.append("\n");
            } else {
                nl = true;
            }
            sb.append(refItem.step).append(": ").append(refItem.o.getClass().getName());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NElement defaultCreateElement(Object o, Type expectedType) {
        if (o != null) {
            RefItem ro = new RefItem(o, "defaultObjectToElement");
            if (this.visited.contains(ro)) {
                throw new NIllegalArgumentException(NMsg.ofC("unable to serialize object of type %s because of cyclic references: %s", o.getClass().getName(), this.stacktrace()));
            }
            this.visited.add(ro);
            try {
                NElement nElement = this.model.getElementFactoryService().defaultCreateElement(o, expectedType, this);
                return nElement;
            }
            finally {
                this.visited.remove(ro);
            }
        }
        return this.model.getElementFactoryService().defaultCreateElement(o, expectedType, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object defaultDestruct(Object o, Type expectedType) {
        if (o != null) {
            RefItem ro = new RefItem(o, "defaultDestruct");
            if (this.visited.contains(ro)) {
                throw new NIllegalArgumentException(NMsg.ofC("unable to destruct object of type %s because of cyclic references: %s", o.getClass().getName(), this.stacktrace()));
            }
            this.visited.add(ro);
            try {
                Object object = this.model.getElementFactoryService().defaultDestruct(o, expectedType, this);
                return object;
            }
            finally {
                this.visited.remove(ro);
            }
        }
        return this.model.getElementFactoryService().defaultDestruct(o, expectedType, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NElement createElement(Object o, Type expectedType) {
        if (o != null) {
            RefItem ro = new RefItem(o, "objectToElement");
            if (this.visited.contains(ro)) {
                throw new NIllegalArgumentException(NMsg.ofC("unable to serialize object of type %s because of cyclic references: %s", o.getClass().getName(), this.stacktrace()));
            }
            this.visited.add(ro);
            try {
                NElement nElement = this.model.getElementFactoryService().createElement(o, expectedType, this);
                return nElement;
            }
            finally {
                this.visited.remove(ro);
            }
        }
        return this.model.getElementFactoryService().createElement(o, expectedType, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object destruct(Object o, Type expectedType) {
        if (o != null) {
            RefItem ro = new RefItem(o, "destruct");
            if (this.visited.contains(ro)) {
                throw new NIllegalArgumentException(NMsg.ofC("unable to destruct object of type %s because of cyclic references.", o.getClass().getName()));
            }
            this.visited.add(ro);
            try {
                Object object = this.model.getElementFactoryService().destruct(o, expectedType, this);
                return object;
            }
            finally {
                this.visited.remove(ro);
            }
        }
        return this.model.getElementFactoryService().destruct(o, expectedType, this);
    }

    @Override
    public <T> T createObject(NElement o, Class<T> type) {
        return (T)this.createObject(o, (Type)type);
    }

    @Override
    public Object createObject(NElement o, Type type) {
        return this.model.getElementFactoryService().createObject(o, type, this);
    }

    @Override
    public <T> T defaultCreateObject(NElement o, Class<T> type) {
        return this.defaultCreateObject(o, (Type)type);
    }

    @Override
    public <T> T defaultCreateObject(NElement o, Type type) {
        return (T)this.model.getElementFactoryService().defaultCreateObject(o, type, this);
    }

    @Override
    public boolean isNtf() {
        return this.ntf;
    }

    public DefaultNElementFactoryContext setNtf(boolean ntf) {
        this.ntf = ntf;
        return this;
    }

    @Override
    public NReflectRepository getTypesRepository() {
        return this.repository;
    }

    private class globalIndustructibleTypesFilter
    implements Predicate<Type> {
        private globalIndustructibleTypesFilter() {
        }

        @Override
        public boolean test(Type type) {
            for (Predicate<Type> f : DefaultNElementFactoryContext.this.userElementMapperStore.getIndestructibleTypesFilters()) {
                if (!f.test(type)) continue;
                return true;
            }
            return false;
        }
    }

    private static class RefItem {
        private final Object o;
        private final String step;

        public RefItem(Object o, String step) {
            this.o = o;
            this.step = step;
        }

        public int hashCode() {
            return System.identityHashCode(this.o) * 31 + this.step.hashCode();
        }

        public boolean equals(Object o1) {
            if (this == o1) {
                return true;
            }
            if (o1 == null || this.getClass() != o1.getClass()) {
                return false;
            }
            RefItem refItem = (RefItem)o1;
            return this.o == refItem.o && this.step.equals(refItem.step);
        }

        public String toString() {
            return this.step + "(" + this.o + ')';
        }
    }
}

