/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.thevpc.nuts.elem.NArrayElement;
import net.thevpc.nuts.elem.NArrayElementBuilder;
import net.thevpc.nuts.elem.NBinaryStreamElementBuilder;
import net.thevpc.nuts.elem.NCharStreamElementBuilder;
import net.thevpc.nuts.elem.NCustomElement;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementComment;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.elem.NElementFactory;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NElementUtils;
import net.thevpc.nuts.elem.NMatrixElementBuilder;
import net.thevpc.nuts.elem.NNumberLayout;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.elem.NObjectElementBuilder;
import net.thevpc.nuts.elem.NOperatorElement;
import net.thevpc.nuts.elem.NOperatorElementBuilder;
import net.thevpc.nuts.elem.NOperatorType;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.elem.NPairElementBuilder;
import net.thevpc.nuts.elem.NPrimitiveElement;
import net.thevpc.nuts.elem.NPrimitiveElementBuilder;
import net.thevpc.nuts.elem.NUpletElement;
import net.thevpc.nuts.elem.NUpletElementBuilder;
import net.thevpc.nuts.expr.NParseException;
import net.thevpc.nuts.io.NInputStreamProvider;
import net.thevpc.nuts.io.NReaderProvider;
import net.thevpc.nuts.math.NBigComplex;
import net.thevpc.nuts.math.NDoubleComplex;
import net.thevpc.nuts.math.NFloatComplex;
import net.thevpc.nuts.runtime.standalone.elem.builder.DefaultNArrayElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.builder.DefaultNBinaryStreamElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.builder.DefaultNCharStreamElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.builder.DefaultNObjectElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.builder.DefaultNOperatorElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.builder.DefaultNPairElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.builder.DefaultNPrimitiveElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.builder.DefaultNUpletElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNBinaryStreamElement;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNCharStreamElement;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNCustomElement;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNNumberElement;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNPairElement;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNPrimitiveElement;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNStringElement;
import net.thevpc.nuts.runtime.standalone.elem.item.NElementAnnotationImpl;
import net.thevpc.nuts.runtime.standalone.elem.item.NElementCommentImpl;
import net.thevpc.nuts.runtime.standalone.elem.item.NElementCommentsImpl;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.DefaultNLiteral;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NUnsupportedEnumException;
import net.thevpc.nuts.util.NUnsupportedOperationException;

@NComponentScope(value=NScopeType.WORKSPACE)
public class DefaultNElementFactory
implements NElementFactory {
    @Override
    public NPairElement ofPair(NElement key, NElement value) {
        return new DefaultNPairElement(key == null ? this.ofNull() : key, value == null ? this.ofNull() : value, new NElementAnnotation[0], null);
    }

    @Override
    public NPairElement ofPair(String key, NElement value) {
        return this.ofPair(this.ofNameOrString(key), value);
    }

    @Override
    public NPairElement ofPair(String key, Boolean value) {
        return this.ofPair(this.ofNameOrString(key), (NElement)this.ofBoolean(value));
    }

    @Override
    public NPairElement ofPair(String key, Short value) {
        return this.ofPair(this.ofNameOrString(key), (NElement)this.ofShort(value));
    }

    @Override
    public NPairElement ofPair(String key, Byte value) {
        return this.ofPair(this.ofNameOrString(key), (NElement)this.ofByte(value));
    }

    @Override
    public NPairElement ofPair(String key, Integer value) {
        return this.ofPair(this.ofNameOrString(key), (NElement)this.ofInt(value));
    }

    @Override
    public NPairElement ofPair(String key, Long value) {
        return this.ofPair(this.ofNameOrString(key), (NElement)this.ofLong(value));
    }

    @Override
    public NPairElement ofPair(String key, String value) {
        return this.ofPair(this.ofNameOrString(key), (NElement)this.ofString(value));
    }

    @Override
    public NPairElement ofPair(String key, Double value) {
        return this.ofPair(this.ofNameOrString(key), (NElement)this.ofDouble(value));
    }

    @Override
    public NPairElement ofPair(String key, Instant value) {
        return this.ofPair(this.ofNameOrString(key), (NElement)this.ofInstant(value));
    }

    @Override
    public NPairElement ofPair(String key, LocalDate value) {
        return this.ofPair(this.ofNameOrString(key), (NElement)this.ofLocalDate(value));
    }

    @Override
    public NPairElement ofPair(String key, LocalDateTime value) {
        return this.ofPair(this.ofNameOrString(key), (NElement)this.ofLocalDateTime(value));
    }

    @Override
    public NPairElement ofPair(String key, LocalTime value) {
        return this.ofPair(this.ofNameOrString(key), (NElement)this.ofLocalTime(value));
    }

    @Override
    public NPairElementBuilder ofPairBuilder(NElement key, NElement value) {
        return new DefaultNPairElementBuilder(key == null ? this.ofNull() : key, value == null ? this.ofNull() : value);
    }

    @Override
    public NOperatorElementBuilder ofOpBuilder() {
        return new DefaultNOperatorElementBuilder();
    }

    @Override
    public NOperatorElement ofOp(NElementType op, NOperatorType type, NElement first, NElement second) {
        return this.ofOpBuilder().operator(op).operatorType(type).first(first).second(second).build();
    }

    @Override
    public NOperatorElement ofOp(NElementType op, NElement first, NElement second) {
        return this.ofOp(op, null, first, second);
    }

    @Override
    public NOperatorElement ofOp(NElementType op, NElement operand) {
        return this.ofOp(op, null, operand, null);
    }

    @Override
    public NPairElementBuilder ofPairBuilder() {
        return new DefaultNPairElementBuilder();
    }

    @Override
    public NObjectElementBuilder ofObjectBuilder() {
        return new DefaultNObjectElementBuilder();
    }

    @Override
    public NObjectElementBuilder ofObjectBuilder(String name) {
        return this.ofObjectBuilder().name(name);
    }

    @Override
    public NArrayElementBuilder ofArrayBuilder() {
        return new DefaultNArrayElementBuilder();
    }

    @Override
    public NArrayElementBuilder ofArrayBuilder(String name) {
        return this.ofArrayBuilder().name(name);
    }

    @Override
    public NArrayElement ofArray() {
        return this.ofArrayBuilder().build();
    }

    @Override
    public NArrayElement ofStringArray(String ... items) {
        return this.ofArrayBuilder().addAll(Arrays.stream(items).map(this::ofString).collect(Collectors.toList())).build();
    }

    @Override
    public NArrayElement ofDoubleArray(double ... items) {
        return this.ofArrayBuilder().addAll(Arrays.stream(items).mapToObj(this::ofDouble).collect(Collectors.toList())).build();
    }

    @Override
    public NArrayElement ofDoubleArray(Double ... items) {
        return this.ofArrayBuilder().addAll(Arrays.stream(items).map(this::ofDouble).collect(Collectors.toList())).build();
    }

    @Override
    public NArrayElement ofFloatArray(float ... items) {
        return this.ofArrayBuilder().addAll(IntStream.range(0, items.length).mapToObj(i -> this.ofFloat(items[i])).collect(Collectors.toList())).build();
    }

    @Override
    public NArrayElement ofFloatArray(Float ... items) {
        return this.ofArrayBuilder().addAll(Arrays.stream(items).map(this::ofFloat).collect(Collectors.toList())).build();
    }

    @Override
    public NArrayElement ofByteArray(byte ... items) {
        return this.ofArrayBuilder().addAll(IntStream.range(0, items.length).mapToObj(i -> this.ofByte(items[i])).collect(Collectors.toList())).build();
    }

    @Override
    public NArrayElement ofByteArray(Byte ... items) {
        return this.ofArrayBuilder().addAll(Arrays.stream(items).map(this::ofByte).collect(Collectors.toList())).build();
    }

    @Override
    public NArrayElement ofShortArray(short ... items) {
        return this.ofArrayBuilder().addAll(IntStream.range(0, items.length).mapToObj(i -> this.ofShort(items[i])).collect(Collectors.toList())).build();
    }

    @Override
    public NArrayElement ofShortArray(Short ... items) {
        return this.ofArrayBuilder().addAll(Arrays.stream(items).map(this::ofShort).collect(Collectors.toList())).build();
    }

    @Override
    public NArrayElement ofIntArray(int ... items) {
        return this.ofArrayBuilder().addAll(Arrays.stream(items).mapToObj(this::ofInt).collect(Collectors.toList())).build();
    }

    @Override
    public NArrayElement ofIntArray(Integer ... items) {
        return this.ofArrayBuilder().addAll(Arrays.stream(items).map(this::ofInt).collect(Collectors.toList())).build();
    }

    @Override
    public NArrayElement ofLongArray(long ... items) {
        return this.ofArrayBuilder().addAll(Arrays.stream(items).mapToObj(this::ofLong).collect(Collectors.toList())).build();
    }

    @Override
    public NArrayElement ofLongArray(Long ... items) {
        return this.ofArrayBuilder().addAll(Arrays.stream(items).map(this::ofLong).collect(Collectors.toList())).build();
    }

    @Override
    public NArrayElement ofNumberArray(Number ... items) {
        return this.ofArrayBuilder().addAll(Arrays.stream(items).map(this::ofNumber).collect(Collectors.toList())).build();
    }

    @Override
    public NArrayElement ofBooleanArray(boolean ... items) {
        NArrayElementBuilder b = this.ofArrayBuilder();
        for (boolean item : items) {
            b.add(item);
        }
        return b.build();
    }

    @Override
    public NArrayElement ofBooleanArray(Boolean ... items) {
        return this.ofArrayBuilder().addAll(Arrays.stream(items).map(this::ofBoolean).collect(Collectors.toList())).build();
    }

    @Override
    public NArrayElement ofArray(NElement ... items) {
        return this.ofArrayBuilder().addAll(items).build();
    }

    @Override
    public NArrayElement ofArray(String name, NElement ... items) {
        return this.ofArrayBuilder().name(name).addAll(items).build();
    }

    @Override
    public NArrayElement ofNamedArray(String name, NElement ... items) {
        return this.ofArrayBuilder().name(name).addAll(items).build();
    }

    @Override
    public NArrayElement ofNamedParametrizedArray(String name, NElement[] params, NElement ... items) {
        return this.ofArrayBuilder().name(name).addParams(params == null ? null : Arrays.asList(params)).addAll(items).build();
    }

    @Override
    public NArrayElement ofArray(String name, NElement[] params, NElement ... items) {
        return this.ofArrayBuilder().name(name).addParams(params == null ? null : Arrays.asList(params)).addAll(items).build();
    }

    @Override
    public NArrayElement ofParametrizedArray(NElement ... params) {
        return this.ofArrayBuilder().addParams(params == null ? null : Arrays.asList(params)).build();
    }

    @Override
    public NArrayElement ofParametrizedArray(NElement[] params, NElement ... items) {
        return this.ofArrayBuilder().addParams(params == null ? null : Arrays.asList(params)).addAll(items).build();
    }

    @Override
    public NArrayElement ofParametrizedArray(String name, NElement[] params, NElement ... items) {
        return this.ofArrayBuilder().name(name).addParams(params == null ? null : Arrays.asList(params)).addAll(items).build();
    }

    @Override
    public NObjectElement ofObject(NElement ... items) {
        return this.ofObjectBuilder().addAll(items).build();
    }

    @Override
    public NArrayElement ofParametrizedArray(String name, NElement ... params) {
        return this.ofArrayBuilder().name(name).addParams(params == null ? null : Arrays.asList(params)).build();
    }

    @Override
    public NObjectElement ofObject(String name, NElement ... items) {
        return this.ofObjectBuilder().name(name).addAll(items).build();
    }

    @Override
    public NObjectElement ofParametrizedObject(NElement[] params, NElement ... items) {
        return this.ofObjectBuilder().addParams(params == null ? null : Arrays.asList(params)).addAll(items).build();
    }

    @Override
    public NObjectElement ofParametrizedObject(String name, NElement[] params, NElement ... items) {
        return this.ofObjectBuilder().name(name).addParams(params == null ? null : Arrays.asList(params)).addAll(items).build();
    }

    @Override
    public NObjectElement ofObject(String name, NElement[] params, NElement ... items) {
        return this.ofObjectBuilder().name(name).addParams(params == null ? null : Arrays.asList(params)).addAll(items).build();
    }

    @Override
    public NObjectElement ofNamedObject(String name, NElement ... items) {
        return this.ofObjectBuilder().name(name).addAll(items).build();
    }

    @Override
    public NObjectElement ofNamedParametrizedObject(String name, NElement[] params, NElement ... items) {
        return this.ofObjectBuilder().name(name).addParams(params == null ? null : Arrays.asList(params)).addAll(items).build();
    }

    @Override
    public NObjectElement ofParametrizedObject(NElement ... params) {
        return this.ofObjectBuilder().addParams(params == null ? null : Arrays.asList(params)).build();
    }

    @Override
    public NObjectElement ofParametrizedObject(String name, NElement ... params) {
        return this.ofObjectBuilder().name(name).addParams(params == null ? null : Arrays.asList(params)).build();
    }

    @Override
    public NObjectElement ofObject() {
        return this.ofObjectBuilder().build();
    }

    @Override
    public NPrimitiveElement ofBoolean(String value) {
        NOptional<Boolean> o = NLiteral.of(value).asBoolean();
        if (o.isEmpty()) {
            return this.ofNull();
        }
        return this.ofBoolean(o.get());
    }

    @Override
    public NPrimitiveElement ofBoolean(boolean value) {
        if (value) {
            return new DefaultNPrimitiveElement(NElementType.BOOLEAN, true, null, null);
        }
        return new DefaultNPrimitiveElement(NElementType.BOOLEAN, false, null, null);
    }

    @Override
    public <T extends Enum<T>> NPrimitiveElement ofEnum(Enum<T> value) {
        if (value == null) {
            return this.ofNull();
        }
        if (value instanceof NEnum) {
            return this.ofName(((NEnum)((Object)value)).id());
        }
        return this.ofName(value.name());
    }

    @Override
    public NPrimitiveElement ofString(String str) {
        return this.ofString(str, null);
    }

    @Override
    public NPrimitiveElement ofString(String str, NElementType stringLayout) {
        if (str == null) {
            return this.ofNull();
        }
        if (stringLayout == null) {
            stringLayout = NElementType.DOUBLE_QUOTED_STRING;
        }
        if (stringLayout.isAnyStringOrName()) {
            return new DefaultNStringElement(stringLayout, str, null, null);
        }
        throw new NUnsupportedEnumException(stringLayout);
    }

    @Override
    public NPrimitiveElement ofRegex(String str) {
        return str == null ? this.ofNull() : new DefaultNStringElement(NElementType.REGEX, str, null, null);
    }

    @Override
    public NPrimitiveElement ofName(String str) {
        return str == null ? this.ofNull() : new DefaultNStringElement(NElementType.NAME, str, null, null);
    }

    @Override
    public NPrimitiveElement ofNameOrString(String value) {
        if (value == null) {
            return this.ofNull();
        }
        return NElementUtils.isValidElementName(value) ? new DefaultNStringElement(NElementType.NAME, value, null, null) : new DefaultNStringElement(NElementType.DOUBLE_QUOTED_STRING, value, null, null);
    }

    @Override
    public NCustomElement ofCustom(Object object) {
        NAssert.requireNonNull(object, "custom element");
        return new DefaultNCustomElement(object, null, null);
    }

    @Override
    public NPrimitiveElement ofTrue() {
        return this.ofBoolean(true);
    }

    @Override
    public NPrimitiveElement ofFalse() {
        return this.ofBoolean(false);
    }

    @Override
    public NPrimitiveElement ofInstant(Instant instant) {
        return instant == null ? this.ofNull() : new DefaultNPrimitiveElement(NElementType.INSTANT, instant, null, null);
    }

    @Override
    public NPrimitiveElement ofLocalDate(LocalDate localDate) {
        return localDate == null ? this.ofNull() : new DefaultNPrimitiveElement(NElementType.LOCAL_DATE, localDate, null, null);
    }

    @Override
    public NPrimitiveElement ofLocalDateTime(LocalDateTime localDateTime) {
        return localDateTime == null ? this.ofNull() : new DefaultNPrimitiveElement(NElementType.LOCAL_DATE, localDateTime, null, null);
    }

    @Override
    public NPrimitiveElement ofLocalTime(LocalTime localTime) {
        return localTime == null ? this.ofNull() : new DefaultNPrimitiveElement(NElementType.LOCAL_TIME, localTime, null, null);
    }

    @Override
    public NPrimitiveElement ofFloat(Float value) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.FLOAT, value);
    }

    @Override
    public NPrimitiveElement ofFloat(float value) {
        return new DefaultNNumberElement(NElementType.FLOAT, Float.valueOf(value));
    }

    @Override
    public NPrimitiveElement ofFloat(Float value, String suffix) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.FLOAT, value, null, suffix);
    }

    @Override
    public NPrimitiveElement ofFloat(float value, String suffix) {
        return new DefaultNNumberElement(NElementType.FLOAT, Float.valueOf(value), null, suffix);
    }

    @Override
    public NPrimitiveElement ofInt(Integer value) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.INT, value);
    }

    @Override
    public NPrimitiveElement ofInt(int value) {
        return new DefaultNNumberElement(NElementType.INT, value, null, null);
    }

    @Override
    public NPrimitiveElement ofInt(Integer value, String suffix) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.INT, value, null, suffix);
    }

    @Override
    public NPrimitiveElement ofInt(int value, String suffix) {
        return new DefaultNNumberElement(NElementType.INT, value, null, suffix);
    }

    @Override
    public NPrimitiveElement ofInt(Integer value, NNumberLayout layout, String suffix) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.INT, value, layout, suffix);
    }

    @Override
    public NPrimitiveElement ofInt(int value, NNumberLayout layout, String suffix) {
        return new DefaultNNumberElement(NElementType.INT, value, layout, suffix);
    }

    @Override
    public NPrimitiveElement ofInt(Integer value, NNumberLayout layout) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.INT, value, layout, null);
    }

    @Override
    public NPrimitiveElement ofInt(int value, NNumberLayout layout) {
        return new DefaultNNumberElement(NElementType.INT, value, layout, null);
    }

    @Override
    public NElement ofBinaryStream(NInputStreamProvider value) {
        return value == null ? this.ofNull() : new DefaultNBinaryStreamElement(value, null, null);
    }

    @Override
    public NBinaryStreamElementBuilder ofBinaryStreamBuilder() {
        return new DefaultNBinaryStreamElementBuilder();
    }

    @Override
    public NElement ofCharStream(NReaderProvider value) {
        return value == null ? this.ofNull() : new DefaultNCharStreamElement(value, null, null);
    }

    @Override
    public NCharStreamElementBuilder ofCharStreamBuilder() {
        return new DefaultNCharStreamElementBuilder();
    }

    @Override
    public NElementAnnotation ofAnnotation(String name, NElement ... values) {
        return new NElementAnnotationImpl(name, values);
    }

    @Override
    public NElementAnnotation ofAnnotation(String name) {
        return new NElementAnnotationImpl(name, null);
    }

    @Override
    public NPrimitiveElement ofLong(Long value) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.LONG, value);
    }

    @Override
    public NPrimitiveElement ofLong(long value, NNumberLayout layout) {
        return new DefaultNNumberElement(NElementType.LONG, value, layout, null);
    }

    @Override
    public NPrimitiveElement ofLong(Long value, NNumberLayout layout) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.LONG, value, layout, null);
    }

    @Override
    public NPrimitiveElement ofLong(long value, NNumberLayout layout, String suffix) {
        return new DefaultNNumberElement(NElementType.LONG, value, layout, suffix);
    }

    @Override
    public NPrimitiveElement ofLong(Long value, NNumberLayout layout, String suffix) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.LONG, value, layout, suffix);
    }

    @Override
    public NPrimitiveElement ofLong(long value, String suffix) {
        return new DefaultNNumberElement(NElementType.LONG, value, null, suffix);
    }

    @Override
    public NPrimitiveElement ofLong(Long value, String suffix) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.LONG, value, null, suffix);
    }

    @Override
    public NPrimitiveElement ofLong(long value) {
        return new DefaultNNumberElement(NElementType.LONG, value, null, null);
    }

    @Override
    public NPrimitiveElement ofNull() {
        return new DefaultNPrimitiveElement(NElementType.NULL, null, null, null);
    }

    @Override
    public NPrimitiveElement ofNumber(String value) {
        if (value == null) {
            return this.ofNull();
        }
        if (value.indexOf(46) >= 0) {
            try {
                return this.ofNumber(Double.parseDouble(value));
            }
            catch (Exception exception) {
                try {
                    return this.ofNumber(new BigDecimal(value));
                }
                catch (Exception exception2) {
                }
            }
        } else {
            try {
                return this.ofNumber(Integer.parseInt(value));
            }
            catch (Exception exception) {
                try {
                    return this.ofNumber(Long.parseLong(value));
                }
                catch (Exception exception3) {
                    try {
                        return this.ofNumber(new BigInteger(value));
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
            }
        }
        throw new NParseException(NMsg.ofC("unable to parse number %s", value));
    }

    @Override
    public NPrimitiveElement ofInstant(Date value) {
        if (value == null) {
            return this.ofNull();
        }
        return new DefaultNPrimitiveElement(NElementType.INSTANT, value.toInstant(), null, null);
    }

    @Override
    public NPrimitiveElement ofInstant(String value) {
        if (value == null) {
            return this.ofNull();
        }
        return new DefaultNPrimitiveElement(NElementType.INSTANT, DefaultNLiteral.parseInstant(value).get(), null, null);
    }

    @Override
    public NPrimitiveElement ofByte(Byte value) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.BYTE, value);
    }

    @Override
    public NPrimitiveElement ofByte(Byte value, String suffix) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.BYTE, value, null, suffix);
    }

    @Override
    public NPrimitiveElement ofByte(byte value) {
        return new DefaultNNumberElement(NElementType.BYTE, value);
    }

    @Override
    public NPrimitiveElement ofByte(Byte value, NNumberLayout layout, String suffix) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.BYTE, value, layout, suffix);
    }

    @Override
    public NPrimitiveElement ofByte(byte value, NNumberLayout layout, String suffix) {
        return new DefaultNNumberElement(NElementType.BYTE, value, layout, suffix);
    }

    @Override
    public NPrimitiveElement ofByte(Byte value, NNumberLayout layout) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.BYTE, value, layout, null);
    }

    @Override
    public NPrimitiveElement ofByte(byte value, NNumberLayout layout) {
        return new DefaultNNumberElement(NElementType.BYTE, value, layout, null);
    }

    @Override
    public NPrimitiveElement ofByte(byte value, String suffix) {
        return new DefaultNNumberElement(NElementType.BYTE, value, null, suffix);
    }

    @Override
    public NPrimitiveElement ofShort(Short value) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.SHORT, value);
    }

    @Override
    public NPrimitiveElement ofShort(short value) {
        return new DefaultNNumberElement(NElementType.SHORT, value, null, null);
    }

    @Override
    public NPrimitiveElement ofShort(Short value, NNumberLayout layout, String suffix) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.SHORT, value, layout, suffix);
    }

    @Override
    public NPrimitiveElement ofShort(short value, NNumberLayout layout, String suffix) {
        return new DefaultNNumberElement(NElementType.SHORT, value, layout, suffix);
    }

    @Override
    public NPrimitiveElement ofShort(Short value, NNumberLayout layout) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.SHORT, value, layout, null);
    }

    @Override
    public NPrimitiveElement ofShort(short value, NNumberLayout layout) {
        return new DefaultNNumberElement(NElementType.SHORT, value, layout, null);
    }

    @Override
    public NPrimitiveElement ofShort(Short value, String suffix) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.SHORT, value, null, suffix);
    }

    @Override
    public NPrimitiveElement ofShort(short value, String suffix) {
        return new DefaultNNumberElement(NElementType.SHORT, value, null, suffix);
    }

    @Override
    public NPrimitiveElement ofChar(Character value) {
        return value == null ? this.ofNull() : new DefaultNStringElement(NElementType.CHAR, value, null, null);
    }

    @Override
    public NPrimitiveElement ofDouble(Double value) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.DOUBLE, value);
    }

    @Override
    public NPrimitiveElement ofDouble(double value) {
        return new DefaultNNumberElement(NElementType.DOUBLE, value);
    }

    @Override
    public NPrimitiveElement ofDouble(Double value, String suffix) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.DOUBLE, value, NNumberLayout.DECIMAL, suffix);
    }

    @Override
    public NPrimitiveElement ofDouble(double value, String suffix) {
        return new DefaultNNumberElement(NElementType.DOUBLE, value, NNumberLayout.DECIMAL, suffix);
    }

    @Override
    public NPrimitiveElement ofBigDecimal(BigDecimal value) {
        if (value == null) {
            return this.ofNull();
        }
        return new DefaultNNumberElement(NElementType.BIG_DECIMAL, value);
    }

    @Override
    public NPrimitiveElement ofBigDecimal(BigDecimal value, String suffix) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.BIG_DECIMAL, value, NNumberLayout.DECIMAL, suffix);
    }

    @Override
    public NPrimitiveElement ofBigInt(BigInteger value) {
        if (value == null) {
            return this.ofNull();
        }
        return new DefaultNNumberElement(NElementType.BIG_INT, value);
    }

    @Override
    public NPrimitiveElement ofBigInt(BigInteger value, NNumberLayout layout, String suffix) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.BIG_INT, value, layout, suffix);
    }

    @Override
    public NPrimitiveElement ofBigInt(BigInteger value, NNumberLayout layout) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.BIG_INT, value, layout, null);
    }

    @Override
    public NPrimitiveElement ofBigInt(BigInteger value, String suffix) {
        return value == null ? this.ofNull() : new DefaultNNumberElement(NElementType.BIG_INT, value, null, suffix);
    }

    @Override
    public NUpletElementBuilder ofUpletBuilder() {
        return new DefaultNUpletElementBuilder();
    }

    @Override
    public NUpletElementBuilder ofUpletBuilder(String name) {
        return this.ofUpletBuilder().name(name);
    }

    @Override
    public NUpletElement ofUplet() {
        return this.ofUpletBuilder().build();
    }

    @Override
    public NUpletElement ofUplet(String name, NElement ... items) {
        return this.ofUpletBuilder().name(name).addAll(items).build();
    }

    @Override
    public NUpletElement ofNamedUplet(String name, NElement ... items) {
        return this.ofUpletBuilder().name(name).addAll(items).build();
    }

    @Override
    public NUpletElement ofUplet(NElement ... items) {
        return this.ofUpletBuilder().addAll(items).build();
    }

    @Override
    public NPrimitiveElement ofDoubleComplex(double real) {
        return this.ofDoubleComplex(real, 0.0);
    }

    @Override
    public NPrimitiveElement ofDoubleComplex(double real, double imag) {
        return new DefaultNNumberElement(NElementType.DOUBLE_COMPLEX, new NDoubleComplex(real, imag));
    }

    @Override
    public NPrimitiveElement ofFloatComplex(float real) {
        return this.ofFloatComplex(real, 0.0f);
    }

    @Override
    public NPrimitiveElement ofFloatComplex(float real, float imag) {
        return new DefaultNNumberElement(NElementType.FLOAT_COMPLEX, new NFloatComplex(real, imag));
    }

    @Override
    public NPrimitiveElement ofBigComplex(BigDecimal real) {
        return this.ofBigComplex(real, BigDecimal.ZERO);
    }

    @Override
    public NPrimitiveElement ofBigComplex(BigDecimal real, BigDecimal imag) {
        if (real == null && imag == null) {
            return this.ofNull();
        }
        return new DefaultNNumberElement(NElementType.BIG_COMPLEX, new NBigComplex(real, imag));
    }

    @Override
    public NPrimitiveElement ofNumber(Number value) {
        if (value == null) {
            return this.ofNull();
        }
        switch (value.getClass().getName()) {
            case "java.lang.Byte": {
                return new DefaultNNumberElement(NElementType.BYTE, value);
            }
            case "java.lang.Short": {
                return new DefaultNNumberElement(NElementType.SHORT, value);
            }
            case "java.lang.Integer": {
                return new DefaultNNumberElement(NElementType.INT, value);
            }
            case "java.lang.Long": {
                return new DefaultNNumberElement(NElementType.LONG, value);
            }
            case "java.math.BigInteger": {
                return new DefaultNNumberElement(NElementType.BIG_INT, value);
            }
            case "java.lang.float": {
                return new DefaultNNumberElement(NElementType.FLOAT, value);
            }
            case "java.lang.Double": {
                return new DefaultNNumberElement(NElementType.DOUBLE, value);
            }
            case "java.math.BigDecimal": {
                return new DefaultNNumberElement(NElementType.BIG_DECIMAL, value);
            }
        }
        if (value instanceof NDoubleComplex) {
            return new DefaultNNumberElement(NElementType.DOUBLE_COMPLEX, value);
        }
        if (value instanceof NBigComplex) {
            return new DefaultNNumberElement(NElementType.BIG_COMPLEX, value);
        }
        if (value instanceof NFloatComplex) {
            return new DefaultNNumberElement(NElementType.FLOAT_COMPLEX, value);
        }
        return new DefaultNNumberElement(NElementType.FLOAT, value);
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public NMatrixElementBuilder ofMatrixBuilder() {
        throw new NUnsupportedOperationException(NMsg.ofC("not implemented yet ofMatrixBuilder()"));
    }

    @Override
    public NElementComments ofMultiLineComments(String ... lines) {
        return new NElementCommentsImpl(new NElementComment[]{this.ofMultiLineComment(lines)}, null);
    }

    @Override
    public NElementComments ofSingleLineComments(String ... lines) {
        return new NElementCommentsImpl((NElementComment[])Arrays.stream(lines == null ? new String[]{} : lines).map(x -> this.ofSingleLineComment((String)x)).toArray(NElementComment[]::new), null);
    }

    @Override
    public NElementComments ofComments(NElementComment[] leading, NElementComment[] trailing) {
        return new NElementCommentsImpl(leading, trailing);
    }

    @Override
    public NElementComment ofMultiLineComment(String ... lines) {
        return NElementCommentImpl.ofMultiLine(lines);
    }

    @Override
    public NElementComment ofSingleLineComment(String ... lines) {
        return NElementCommentImpl.ofSingleLine(lines);
    }

    @Override
    public NPrimitiveElementBuilder ofPrimitiveBuilder() {
        return new DefaultNPrimitiveElementBuilder();
    }
}

