/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.function.Predicate;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.text.NFormattable;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;

public class CoreNElementUtils {
    public static Predicate<Type> DEFAULT_SIMPLE_TYPE = new Predicate<Type>(){

        @Override
        public boolean test(Type type) {
            if (type == null) {
                return true;
            }
            if (type instanceof Class) {
                Class cls = (Class)type;
                switch (cls.getName()) {
                    case "boolean": 
                    case "byte": 
                    case "char": 
                    case "short": 
                    case "int": 
                    case "long": 
                    case "float": 
                    case "double": 
                    case "java.lang.Character": 
                    case "java.lang.String": 
                    case "java.lang.StringBuilder": 
                    case "java.lang.Boolean": 
                    case "java.lang.Byte": 
                    case "java.lang.Short": 
                    case "java.lang.Integer": 
                    case "java.lang.Long": 
                    case "java.lang.Float": 
                    case "java.lang.Double": 
                    case "java.math.BigDecimal": 
                    case "java.math.BigInteger": 
                    case "java.util.Date": 
                    case "java.sql.Time": 
                    case "net.thevpc.nuts.math.NDoubleComplex": 
                    case "net.thevpc.nuts.math.NFloatComplex": 
                    case "net.thevpc.nuts.math.NBigComplex": {
                        return true;
                    }
                }
                if (Temporal.class.isAssignableFrom(cls)) {
                    return true;
                }
                if (Date.class.isAssignableFrom(cls)) {
                    return true;
                }
                if (NElement.class.isAssignableFrom(cls)) {
                    return true;
                }
                return NText.class.isAssignableFrom(cls) || NElement.class.isAssignableFrom(cls) || NFormattable.class.isAssignableFrom(cls) || NMsg.class.isAssignableFrom(cls);
            }
            if (type instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)type).getRawType();
                if (rawType instanceof Class) {
                    return this.test((Class)rawType);
                }
                throw new IllegalArgumentException("Unexpected raw type: " + rawType);
            }
            if (type instanceof GenericArrayType) {
                return false;
            }
            if (type instanceof TypeVariable) {
                return false;
            }
            if (type instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type;
                Type[] upperBounds = wildcardType.getUpperBounds();
                if (upperBounds.length == 0) {
                    return this.test((Type)((Object)Object.class));
                }
                return this.test(upperBounds[0]);
            }
            throw new IllegalArgumentException("Unknown Type: " + type);
        }
    };
    public static Predicate<Type> DEFAULT_INDESTRUCTIBLE = new Predicate<Type>(){

        @Override
        public boolean test(Type type) {
            if (type == null) {
                return true;
            }
            if (type instanceof Class) {
                Class cls = (Class)type;
                switch (cls.getName()) {
                    case "boolean": 
                    case "byte": 
                    case "char": 
                    case "short": 
                    case "int": 
                    case "long": 
                    case "float": 
                    case "double": 
                    case "java.lang.Character": 
                    case "java.lang.String": 
                    case "java.lang.StringBuilder": 
                    case "java.lang.Boolean": 
                    case "java.lang.Byte": 
                    case "java.lang.Short": 
                    case "java.lang.Integer": 
                    case "java.lang.Long": 
                    case "java.lang.Float": 
                    case "java.lang.Double": 
                    case "java.math.BigDecimal": 
                    case "java.math.BigInteger": 
                    case "java.util.Date": 
                    case "java.sql.Time": 
                    case "net.thevpc.nuts.math.NDoubleComplex": 
                    case "net.thevpc.nuts.math.NFloatComplex": 
                    case "net.thevpc.nuts.math.NBigComplex": {
                        return true;
                    }
                }
                if (Temporal.class.isAssignableFrom(cls)) {
                    return true;
                }
                if (Date.class.isAssignableFrom(cls)) {
                    return true;
                }
                return NText.class.isAssignableFrom(cls) || NElement.class.isAssignableFrom(cls) || NFormattable.class.isAssignableFrom(cls) || NMsg.class.isAssignableFrom(cls);
            }
            if (type instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)type).getRawType();
                if (rawType instanceof Class) {
                    return this.test((Class)rawType);
                }
                throw new IllegalArgumentException("Unexpected raw type: " + rawType);
            }
            if (type instanceof GenericArrayType) {
                return false;
            }
            if (type instanceof TypeVariable) {
                return false;
            }
            if (type instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type;
                Type[] upperBounds = wildcardType.getUpperBounds();
                if (upperBounds.length == 0) {
                    return this.test((Type)((Object)Object.class));
                }
                return this.test(upperBounds[0]);
            }
            throw new IllegalArgumentException("Unknown Type: " + type);
        }
    };
}

