/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.parser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorParser;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NDescriptorContentParserComponent;
import net.thevpc.nuts.spi.NDescriptorContentParserContext;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

@NComponentScope(value=NScopeType.WORKSPACE)
public class ZipDescriptorContentParserComponent
implements NDescriptorContentParserComponent {
    public static final Set<String> POSSIBLE_PATHS = new LinkedHashSet<String>(Arrays.asList("nuts.json", "META-INF/nuts.json", "WEB-INF/nuts.json", "APP-INF/nuts.json"));
    public static final Set<String> POSSIBLE_EXT = new HashSet<String>(Arrays.asList("zip", "gzip", "gz", "war", "ear"));

    @Override
    public int getScore(NScorableContext criteria) {
        String e;
        NDescriptorContentParserContext constraints = criteria.getCriteria(NDescriptorContentParserContext.class);
        if (constraints != null && !POSSIBLE_EXT.contains(e = NStringUtils.trim(constraints.getFileExtension()))) {
            return -1;
        }
        return -1;
    }

    @Override
    public NDescriptor parse(NDescriptorContentParserContext parserContext) {
        String e = NStringUtils.trim(parserContext.getFileExtension());
        if (!POSSIBLE_EXT.contains(e)) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            if (ZipUtils.extractFirstPath(parserContext.getFullStream(), POSSIBLE_PATHS, buffer, true)) {
                return NDescriptorParser.of().parse(buffer.toByteArray()).get();
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
        return null;
    }
}

