/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.parser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorBuilder;
import net.thevpc.nuts.artifact.NDescriptorFlag;
import net.thevpc.nuts.artifact.NDescriptorParser;
import net.thevpc.nuts.artifact.NDescriptorStyle;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.expr.NParseException;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.DefaultNArtifactCallBuilder;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorBuilder;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorPropertyBuilder;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenUtils;
import net.thevpc.nuts.runtime.standalone.util.CorePlatformUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUnsupportedEnumException;

@NComponentScope(value=NScopeType.PROTOTYPE)
public class DefaultNDescriptorParser
implements NDescriptorParser {
    private NDescriptorStyle descriptorStyle;
    private String format;

    @Override
    public NOptional<NDescriptor> parse(URL url) {
        return this.parse(NPath.of(url));
    }

    @Override
    public NOptional<NDescriptor> parse(byte[] bytes) {
        return this.parse(new ByteArrayInputStream(bytes), null, true);
    }

    @Override
    public NOptional<NDescriptor> parse(Path path) {
        return this.parse(NPath.of(path));
    }

    @Override
    public NOptional<NDescriptor> parse(File file) {
        return this.parse(file.toPath());
    }

    @Override
    public NOptional<NDescriptor> parse(InputStream stream) {
        return this.parse(stream, null, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NOptional<NDescriptor> parse(NPath path) {
        try {
            boolean startParsing = false;
            try {
                try (InputStream is = path.getInputStream();){
                    String canonicalPathName;
                    startParsing = true;
                    NDescriptorStyle defaultDescriptorStyle = null;
                    switch (canonicalPathName = path.getName().toLowerCase()) {
                        case "pom.xml": {
                            defaultDescriptorStyle = NDescriptorStyle.MAVEN;
                            break;
                        }
                        case "manifest.mf": {
                            defaultDescriptorStyle = NDescriptorStyle.MANIFEST;
                            break;
                        }
                        case "nuts.json": {
                            defaultDescriptorStyle = NDescriptorStyle.NUTS;
                            break;
                        }
                        default: {
                            if (canonicalPathName.endsWith(".pom")) {
                                defaultDescriptorStyle = NDescriptorStyle.MAVEN;
                                break;
                            }
                            if (!canonicalPathName.endsWith(".nuts")) break;
                            defaultDescriptorStyle = NDescriptorStyle.NUTS;
                        }
                    }
                    NOptional<NDescriptor> r = this.parse(is, defaultDescriptorStyle, true);
                    if (r.isError()) {
                        NOptional<NDescriptor> nOptional = NOptional.ofError(() -> NMsg.ofC("unable to parse descriptor from %s : %s", path, r.getMessage().get()));
                        return nOptional;
                    }
                    NOptional<NDescriptor> nOptional = r;
                    return nOptional;
                }
                catch (RuntimeException ex) {
                    return NOptional.ofError(() -> NMsg.ofC("unable to parse descriptor from %s : %s", path, ex), (Throwable)ex);
                }
            }
            catch (IOException ex) {
                if (startParsing) return NOptional.ofError(() -> NMsg.ofC("unable to parse descriptor from %s : %s", path, ex), (Throwable)ex);
                return NOptional.ofError(() -> NMsg.ofC("unable to parse descriptor from %s : file not found", path), (Throwable)ex);
            }
        }
        catch (Exception ex) {
            return NOptional.ofError(() -> NMsg.ofC("unable to parse descriptor from %s : %s", path, ex), (Throwable)ex);
        }
    }

    @Override
    public NOptional<NDescriptor> parse(String str) {
        if (NBlankable.isBlank(str)) {
            return null;
        }
        return this.parse(new ByteArrayInputStream(str.getBytes()), null, true);
    }

    @Override
    public NDescriptorStyle getDescriptorStyle() {
        return this.descriptorStyle;
    }

    @Override
    public DefaultNDescriptorParser setDescriptorStyle(NDescriptorStyle descriptorStyle) {
        this.descriptorStyle = descriptorStyle;
        return this;
    }

    private NOptional<NDescriptor> parse(InputStream in, NDescriptorStyle defaultDescriptorStyle, boolean closeStream) {
        try {
            return NOptional.of(this.parseNonLenient(in, defaultDescriptorStyle, closeStream));
        }
        catch (Exception ex) {
            return NOptional.ofError(() -> NMsg.ofC("unable to parse descriptor from %s : %s", in, ex), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NDescriptor parseNonLenient(InputStream in, NDescriptorStyle defaultDescriptorStyle, boolean closeStream) {
        NDescriptorStyle style = this.getDescriptorStyle();
        if (style == null) {
            style = defaultDescriptorStyle;
        }
        if (style == null) {
            style = NDescriptorStyle.NUTS;
        }
        switch (style) {
            case MAVEN: {
                try {
                    NDescriptor nDescriptor = MavenUtils.of().parsePomXml(in, NFetchMode.LOCAL, "descriptor", null);
                    return nDescriptor;
                }
                finally {
                    if (closeStream) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            throw new NIOException(ex);
                        }
                    }
                }
            }
            case NUTS: {
                try {
                    InputStreamReader rr = new InputStreamReader(in);
                    NDescriptor ex = NElementParser.ofJson().parse(rr, NDescriptor.class);
                    return ex;
                }
                finally {
                    if (closeStream) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            throw new NIOException(ex);
                        }
                    }
                }
            }
            case MANIFEST: {
                try {
                    String artifactVersion;
                    Manifest manifest = new Manifest(in);
                    Attributes attrs = manifest.getMainAttributes();
                    String automaticModuleName = null;
                    String mainVersion = null;
                    String mainClass = null;
                    String implVendorId = null;
                    String implVendorTitle = null;
                    String implTitle = null;
                    Set deps = new LinkedHashSet();
                    NId explicitId = null;
                    HashMap<String, String> all = new HashMap<String, String>();
                    for (Object o : attrs.keySet()) {
                        Attributes.Name attrName = (Attributes.Name)o;
                        if ("Main-Class".equals(attrName.toString())) {
                            mainClass = NStringUtils.trimToNull(attrs.getValue(attrName));
                        }
                        if ("Automatic-Module-Name".equals(attrName.toString())) {
                            automaticModuleName = NStringUtils.trimToNull(attrs.getValue(attrName));
                        }
                        if ("Implementation-Version".equals(attrName.toString())) {
                            mainVersion = NStringUtils.trimToNull(attrs.getValue(attrName));
                        }
                        if ("Implementation-Vendor-Id".equals(attrName.toString())) {
                            implVendorId = NStringUtils.trimToNull(attrs.getValue(attrName));
                        }
                        if ("Implementation-Title".equals(attrName.toString())) {
                            implTitle = NStringUtils.trimToNull(attrs.getValue(attrName));
                        }
                        if ("Implementation-Vendor-Title".equals(attrName.toString())) {
                            implVendorTitle = NStringUtils.trimToNull(attrs.getValue(attrName));
                        }
                        if ("Nuts-Id".equals(attrName.toString())) {
                            explicitId = NId.get(NStringUtils.trimToNull(attrs.getValue(attrName))).orNull();
                        }
                        if ("Nuts-Dependencies".equals(attrName.toString())) {
                            String nutsDependencies = NStringUtils.trimToNull(attrs.getValue(attrName));
                            deps = nutsDependencies == null ? Collections.emptySet() : (Set)StringTokenizerUtils.splitSemiColon(nutsDependencies).stream().map(String::trim).filter(x -> x.length() > 0).map(x -> NDependency.get(x).orNull()).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
                        }
                        all.put(attrName.toString(), NStringUtils.trimToNull(attrs.getValue(attrName)));
                    }
                    String groupId = null;
                    String artifactId = null;
                    String string = artifactVersion = NBlankable.isBlank(mainVersion) ? "1.0" : mainVersion.trim();
                    if (!NBlankable.isBlank(implVendorId) && DefaultNDescriptorParser.validGroupId(implVendorId.trim())) {
                        groupId = implVendorId.trim();
                    }
                    if (!NBlankable.isBlank(implTitle) && DefaultNDescriptorParser.validArtifactId(implTitle)) {
                        artifactId = implTitle.trim();
                    }
                    if (explicitId == null && !NBlankable.isBlank(groupId) && !NBlankable.isBlank(artifactId)) {
                        explicitId = NIdBuilder.of(groupId, artifactId).setVersion(NBlankable.isBlank(artifactVersion) ? "1.0" : artifactVersion.trim()).build();
                    }
                    if (explicitId == null) {
                        if (automaticModuleName == null && implVendorId == null) {
                            if (!NBlankable.isBlank(mainClass)) {
                                automaticModuleName = CorePlatformUtils.getPackageName(mainClass);
                            }
                        } else if (automaticModuleName == null && implVendorId != null) {
                            automaticModuleName = implVendorId;
                        }
                        if (!NBlankable.isBlank(automaticModuleName)) {
                            if (NBlankable.isBlank(groupId) && !NBlankable.isBlank(CorePlatformUtils.getPackageName(automaticModuleName))) {
                                groupId = NStringUtils.trim(CorePlatformUtils.getPackageName(automaticModuleName));
                            }
                            if (NBlankable.isBlank(artifactId) && !NBlankable.isBlank(CorePlatformUtils.getSimpleClassName(automaticModuleName))) {
                                artifactId = NStringUtils.trim(CorePlatformUtils.getSimpleClassName(automaticModuleName));
                            }
                            explicitId = NIdBuilder.of(groupId, artifactId).setVersion(artifactVersion).build();
                        }
                    }
                    if (explicitId != null || !deps.isEmpty()) {
                        String[] stringArray;
                        String nutsName = NStringUtils.trimToNull((String)all.get("Nuts-Name"));
                        if (nutsName == null) {
                            nutsName = implVendorTitle;
                        }
                        NDescriptorBuilder nDescriptorBuilder = new DefaultNDescriptorBuilder().setId(explicitId).setName(nutsName).addFlag(NBlankable.isBlank(mainClass) ? NDescriptorFlag.EXEC : null).addFlags((NDescriptorFlag[])StringTokenizerUtils.splitDefault((String)all.get("Nuts-Flags")).stream().map(x -> NDescriptorFlag.parse(x).orNull()).filter(Objects::nonNull).toArray(NDescriptorFlag[]::new)).setPackaging(CoreStringUtils.coalesce(NStringUtils.trimToNull((String)all.get("Nuts-Packaging")), "jar")).setCategories(StringTokenizerUtils.splitDefault((String)all.get("Nuts-Categories")).stream().map(NStringUtils::trimToNull).filter(Objects::nonNull).collect(Collectors.toList())).setIcons(StringTokenizerUtils.splitDefault((String)all.get("Nuts-Icons")).stream().map(NStringUtils::trimToNull).filter(Objects::nonNull).collect(Collectors.toList())).setName(nutsName).setDescription(NStringUtils.trimToNull((String)all.get("Nuts-Description"))).setGenericName(NStringUtils.trimToNull((String)all.get("Nuts-Generic-Name"))).setProperties(all.entrySet().stream().filter(x -> ((String)x.getKey()).startsWith("Nuts-Property-")).map(x -> new DefaultNDescriptorPropertyBuilder().setName(((String)x.getKey()).substring("Nuts-Property-".length())).setValue((String)x.getValue()).build()).collect(Collectors.toList()));
                        DefaultNArtifactCallBuilder defaultNArtifactCallBuilder = new DefaultNArtifactCallBuilder().setId(NId.get("java").get());
                        if (NBlankable.isBlank(mainClass)) {
                            stringArray = null;
                        } else {
                            String[] stringArray2 = new String[2];
                            stringArray2[0] = "--main-class=";
                            stringArray = stringArray2;
                            stringArray2[1] = mainClass;
                        }
                        NDescriptor nDescriptor = nDescriptorBuilder.setExecutor(defaultNArtifactCallBuilder.setArguments(stringArray).build()).setDependencies(new ArrayList<NDependency>(deps)).build();
                        return nDescriptor;
                    }
                    try {
                        throw new NParseException(NMsg.ofC("Missing Explicit Nuts Id in Manifest from %s", in));
                    }
                    catch (IOException ex) {
                        throw new NIOException(ex);
                    }
                }
                finally {
                    if (closeStream) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            throw new NIOException(ex);
                        }
                    }
                }
            }
        }
        throw new NUnsupportedEnumException(style);
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    public static boolean validGroupId(String g) {
        return g != null && NId.GROUP_ID_PATTERN.matcher(g).matches();
    }

    public static boolean validArtifactId(String a) {
        return a != null && NId.ARTIFACT_ID_PATTERN.matcher(a).matches();
    }
}

